/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.tasks.DoToClosestBlockTask;
import com.player2.playerengine.tasks.InteractWithBlockTask;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.DestroyBlockTask;
import com.player2.playerengine.tasks.movement.DefaultGoToDimensionTask;
import com.player2.playerengine.tasks.movement.GetCloseToBlockTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.progresscheck.MovementProgressChecker;
import com.player2.playerengine.util.time.TimerGame;
import java.util.HashSet;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_3959;

public class CollectBucketLiquidTask
extends ResourceTask {
    private final HashSet<class_2338> blacklist = new HashSet();
    private final TimerGame tryImmediatePickupTimer = new TimerGame(3.0);
    private final TimerGame pickedUpTimer = new TimerGame(0.5);
    private final int count;
    private final class_1792 target;
    private final class_2248 toCollect;
    private final String liquidName;
    private final MovementProgressChecker progressChecker = new MovementProgressChecker();
    private boolean wasWandering = false;
    int tries = 0;
    TimerGame timeoutTimer = new TimerGame(2.0);

    public CollectBucketLiquidTask(String liquidName, class_1792 filledBucket, int targetCount, class_2248 toCollect) {
        super(filledBucket, targetCount);
        this.liquidName = liquidName;
        this.target = filledBucket;
        this.count = targetCount;
        this.toCollect = toCollect;
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
        mod.getBehaviour().push();
        mod.getBehaviour().setRayTracingFluidHandling(class_3959.class_242.field_1345);
        mod.getBehaviour().avoidBlockBreaking(pos -> this.controller.getWorld().method_8320(pos).method_26204() == this.toCollect);
        mod.getBehaviour().avoidBlockPlacing(pos -> this.controller.getWorld().method_8320(pos).method_26204() == this.toCollect);
        mod.getBaritoneSettings().avoidUpdatingFallingBlocks.set(Boolean.TRUE);
        this.progressChecker.reset();
    }

    @Override
    protected Task onTick() {
        Task result = super.onTick();
        if (!this.thisOrChildAreTimedOut()) {
            this.wasWandering = false;
        }
        return result;
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        class_2248 standingInside;
        if (mod.getBaritone().getPathingBehavior().isPathing()) {
            this.progressChecker.reset();
        }
        if (this.tryImmediatePickupTimer.elapsed() && !mod.getItemStorage().hasItem(class_1802.field_8705) && (standingInside = mod.getWorld().method_8320(mod.getPlayer().method_24515()).method_26204()) == this.toCollect && WorldHelper.isSourceBlock(this.controller, mod.getPlayer().method_24515(), false)) {
            this.setDebugState("Trying to collect (we are in it)");
            mod.getInputControls().forceLook(0.0f, 90.0f);
            this.tryImmediatePickupTimer.reset();
            if (mod.getSlotHandler().forceEquipItem(class_1802.field_8550)) {
                mod.getInputControls().tryPress(Input.CLICK_RIGHT);
                mod.getExtraBaritoneSettings().setInteractionPaused(true);
                this.pickedUpTimer.reset();
                this.progressChecker.reset();
            }
            return null;
        }
        if (!this.pickedUpTimer.elapsed()) {
            mod.getExtraBaritoneSettings().setInteractionPaused(false);
            this.progressChecker.reset();
            return null;
        }
        int bucketsNeeded = this.count - mod.getItemStorage().getItemCount(class_1802.field_8550) - mod.getItemStorage().getItemCount(this.target);
        if (bucketsNeeded > 0) {
            this.setDebugState("Getting bucket...");
            return TaskCatalogue.getItemTask(class_1802.field_8550, bucketsNeeded);
        }
        Predicate<class_2338> isSafeSourceLiquid = blockPos -> {
            if (this.blacklist.contains(blockPos)) {
                return false;
            }
            if (!WorldHelper.canReach(this.controller, blockPos)) {
                return false;
            }
            if (!WorldHelper.canReach(this.controller, blockPos.method_10084())) {
                return false;
            }
            assert (this.controller.getWorld() != null);
            class_2248 above = mod.getWorld().method_8320(blockPos.method_10084()).method_26204();
            if (above != class_2246.field_9987 && above != class_2246.field_10382) {
                for (class_2350 direction : class_2350.values()) {
                    if (direction.method_10166().method_10178() || mod.getWorld().method_8320(blockPos.method_10084().method_10093(direction)).method_26204() != class_2246.field_10382) continue;
                    return false;
                }
                return WorldHelper.isSourceBlock(this.controller, blockPos, false);
            }
            return false;
        };
        if (mod.getBlockScanner().anyFound(isSafeSourceLiquid, this.toCollect)) {
            this.setDebugState("Trying to collect...");
            return new DoToClosestBlockTask(blockPos -> {
                if (mod.getWorld().method_8320(blockPos.method_10084()).method_51367()) {
                    if (!this.progressChecker.check(mod)) {
                        mod.getBaritone().getPathingBehavior().cancelEverything();
                        mod.getBaritone().getPathingBehavior().forceCancel();
                        mod.getBaritone().getExploreProcess().onLostControl();
                        mod.getBaritone().getCustomGoalProcess().onLostControl();
                        Debug.logMessage("Failed to break, blacklisting.");
                        mod.getBlockScanner().requestBlockUnreachable((class_2338)blockPos);
                        this.blacklist.add((class_2338)blockPos);
                    }
                    return new DestroyBlockTask(blockPos.method_10084());
                }
                if (this.tries > 75) {
                    if (this.timeoutTimer.elapsed()) {
                        this.tries = 0;
                    }
                    mod.log("trying to wander " + this.timeoutTimer.getDuration());
                    return new TimeoutWanderTask();
                }
                this.timeoutTimer.reset();
                if (LookHelper.getReach(this.controller, blockPos).isPresent() && mod.getBaritone().getPathingBehavior().isSafeToCancel()) {
                    ++this.tries;
                    return new InteractWithBlockTask(new ItemTarget(class_1802.field_8550, 1), (class_2338)blockPos, this.toCollect != class_2246.field_10164, new class_2382(0, 1, 0));
                }
                if (this.thisOrChildAreTimedOut() && !this.wasWandering) {
                    mod.getBlockScanner().requestBlockUnreachable(blockPos.method_10084());
                    this.wasWandering = true;
                }
                return new GetCloseToBlockTask(blockPos.method_10084());
            }, isSafeSourceLiquid, this.toCollect);
        }
        if (this.toCollect == class_2246.field_10382 && WorldHelper.getCurrentDimension(this.controller) == Dimension.NETHER) {
            return new DefaultGoToDimensionTask(Dimension.OVERWORLD);
        }
        this.setDebugState("Searching for liquid by wandering around aimlessly");
        return new TimeoutWanderTask();
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
        mod.getBehaviour().pop();
        mod.getExtraBaritoneSettings().setInteractionPaused(false);
        mod.getBaritoneSettings().avoidUpdatingFallingBlocks.set(false);
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        if (other instanceof CollectBucketLiquidTask) {
            CollectBucketLiquidTask task = (CollectBucketLiquidTask)other;
            return task.count != this.count ? false : task.toCollect == this.toCollect;
        }
        return false;
    }

    @Override
    protected String toDebugStringName() {
        return "Collect " + this.count + " " + this.liquidName + " buckets";
    }

    public static class CollectWaterBucketTask
    extends CollectBucketLiquidTask {
        public CollectWaterBucketTask(int targetCount) {
            super("water", class_1802.field_8705, targetCount, class_2246.field_10382);
        }
    }

    public static class CollectLavaBucketTask
    extends CollectBucketLiquidTask {
        public CollectLavaBucketTask(int targetCount) {
            super("lava", class_1802.field_8187, targetCount, class_2246.field_10164);
        }
    }
}

