/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.entity.DoToClosestEntityTask;
import com.player2.playerengine.tasks.movement.DefaultGoToDimensionTask;
import com.player2.playerengine.tasks.movement.GetToEntityTask;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.helpers.WorldHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1428;
import net.minecraft.class_1802;

public class CollectEggsTask
extends ResourceTask {
    private final int count;
    private final DoToClosestEntityTask waitNearChickens;
    private PlayerEngineController mod;

    public CollectEggsTask(int targetCount) {
        super(class_1802.field_8803, targetCount);
        this.count = targetCount;
        this.waitNearChickens = new DoToClosestEntityTask(chicken -> new GetToEntityTask((class_1297)chicken, 5.0), class_1428.class);
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
        this.mod = mod;
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        if (this.waitNearChickens.wasWandering() && WorldHelper.getCurrentDimension(this.controller) != Dimension.OVERWORLD) {
            this.setDebugState("Going to right dimension.");
            return new DefaultGoToDimensionTask(Dimension.OVERWORLD);
        }
        this.setDebugState("Waiting around chickens. Yes.");
        return this.waitNearChickens;
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        return other instanceof CollectEggsTask;
    }

    @Override
    protected String toDebugStringName() {
        return "Collecting " + this.count + " eggs.";
    }
}

