/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.container.SmeltInSmokerTask;
import com.player2.playerengine.tasks.movement.PickupDroppedItemTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.tasks.resources.CollectFoodTask;
import com.player2.playerengine.tasks.resources.KillAndLootTask;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.SmeltTarget;
import com.player2.playerengine.util.time.TimerGame;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1428;
import net.minecraft.class_1430;
import net.minecraft.class_1452;
import net.minecraft.class_1463;
import net.minecraft.class_1472;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public class CollectMeatTask
extends Task {
    public static final CollectFoodTask.CookableFoodTarget[] COOKABLE_MEATS = new CollectFoodTask.CookableFoodTarget[]{new CollectFoodTask.CookableFoodTarget("beef", class_1430.class), new CollectFoodTask.CookableFoodTarget("porkchop", class_1452.class), new CollectFoodTask.CookableFoodTarget("chicken", class_1428.class), new CollectFoodTask.CookableFoodTarget("mutton", class_1472.class), new CollectFoodTask.CookableFoodTarget("rabbit", class_1463.class)};
    private static final double NEARBY_PICKUP_RADIUS = 15.0;
    private final double unitsNeeded;
    private final TimerGame checkNewOptionsTimer = new TimerGame(10.0);
    private Task currentResourceTask = null;

    public CollectMeatTask(double unitsNeeded) {
        this.unitsNeeded = unitsNeeded;
    }

    @Override
    protected void onStart() {
        this.controller.getBehaviour().push();
        for (CollectFoodTask.CookableFoodTarget meat : COOKABLE_MEATS) {
            this.controller.getBehaviour().addProtectedItems(meat.getRaw(), meat.getCooked());
        }
    }

    @Override
    protected Task onTick() {
        SmeltTarget toSmelt;
        CollectFoodTask.blackListChickenJockeys(this.controller);
        double potentialFood = CollectMeatTask.calculateFoodPotential(this.controller);
        if (potentialFood >= this.unitsNeeded && (toSmelt = this.getBestSmeltTarget(this.controller)) != null) {
            this.setDebugState("Cooking meat");
            return new SmeltInSmokerTask(toSmelt);
        }
        if (this.checkNewOptionsTimer.elapsed()) {
            this.checkNewOptionsTimer.reset();
            this.currentResourceTask = null;
        }
        if (this.currentResourceTask != null && this.currentResourceTask.isActive() && !this.currentResourceTask.isFinished() && !this.currentResourceTask.thisOrChildAreTimedOut()) {
            return this.currentResourceTask;
        }
        class_1792[] allMeats = (class_1792[])Arrays.stream(COOKABLE_MEATS).flatMap(meat -> Stream.of(meat.getRaw(), meat.getCooked())).toArray(class_1792[]::new);
        Optional<class_1542> closestDrop = this.controller.getEntityTracker().getClosestItemDrop(this.controller.getPlayer().method_19538(), allMeats);
        if (closestDrop.isPresent() && (double)closestDrop.get().method_5739((class_1297)this.controller.getPlayer()) < 15.0) {
            this.setDebugState("Picking up nearby dropped meat");
            this.currentResourceTask = new PickupDroppedItemTask(new ItemTarget(allMeats, 9999), true);
            return this.currentResourceTask;
        }
        class_1297 bestEntityToKill = this.getBestAnimalToKill(this.controller);
        if (bestEntityToKill != null) {
            this.setDebugState("Hunting " + bestEntityToKill.method_5864().method_5897().getString());
            class_1792 rawFood = Arrays.stream(COOKABLE_MEATS).filter(c -> c.mobToKill == bestEntityToKill.getClass()).findFirst().get().getRaw();
            this.currentResourceTask = new KillAndLootTask(bestEntityToKill.getClass(), new ItemTarget(rawFood, 1));
            return this.currentResourceTask;
        }
        this.setDebugState("Searching for animals...");
        return new TimeoutWanderTask();
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBehaviour().pop();
    }

    @Override
    public boolean isFinished() {
        double currentFoodScore = 0.0;
        for (CollectFoodTask.CookableFoodTarget meat : COOKABLE_MEATS) {
            currentFoodScore += (double)(this.controller.getItemStorage().getItemCount(meat.getCooked()) * meat.getCookedUnits());
        }
        return currentFoodScore >= this.unitsNeeded;
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (other instanceof CollectMeatTask) {
            CollectMeatTask task = (CollectMeatTask)other;
            bl = task.unitsNeeded == this.unitsNeeded;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Collecting " + this.unitsNeeded + " units of meat.";
    }

    private SmeltTarget getBestSmeltTarget(PlayerEngineController controller) {
        for (CollectFoodTask.CookableFoodTarget cookable : COOKABLE_MEATS) {
            int rawCount = controller.getItemStorage().getItemCount(cookable.getRaw());
            if (rawCount <= 0) continue;
            return new SmeltTarget(new ItemTarget(cookable.getCooked(), rawCount), new ItemTarget(cookable.getRaw(), rawCount), new class_1792[0]);
        }
        return null;
    }

    private class_1297 getBestAnimalToKill(PlayerEngineController controller) {
        double bestScore = -1.0;
        class_1297 bestEntity = null;
        Predicate<class_1297> notBaby = entity -> entity instanceof class_1309 && !((class_1309)entity).method_6109();
        for (CollectFoodTask.CookableFoodTarget cookable : COOKABLE_MEATS) {
            double score;
            double distanceSq;
            Optional<class_1297> nearest;
            if (!controller.getEntityTracker().entityFound(cookable.mobToKill) || !(nearest = controller.getEntityTracker().getClosestEntity(controller.getEntity().method_19538(), notBaby, cookable.mobToKill)).isPresent() || (distanceSq = nearest.get().method_19538().method_1025(controller.getEntity().method_19538())) == 0.0 || !((score = (double)cookable.getCookedUnits() / distanceSq) > bestScore)) continue;
            bestScore = score;
            bestEntity = nearest.get();
        }
        return bestEntity;
    }

    private static double calculateFoodPotential(PlayerEngineController controller) {
        double potentialFood = 0.0;
        for (class_1799 stack : controller.getItemStorage().getItemStacksPlayerInventory(true)) {
            potentialFood += CollectMeatTask.getFoodPotential(stack);
        }
        return potentialFood;
    }

    public static double getFoodPotential(class_1799 food) {
        if (food != null && !food.method_7960()) {
            int count = food.method_7947();
            for (CollectFoodTask.CookableFoodTarget cookable : COOKABLE_MEATS) {
                if (food.method_7909() == cookable.getRaw()) {
                    return (double)count * (double)cookable.getCookedUnits();
                }
                if (food.method_7909() != cookable.getCooked()) continue;
                return (double)count * (double)cookable.getCookedUnits();
            }
            return 0.0;
        }
        return 0.0;
    }
}

