/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.CraftInInventoryTask;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.resources.MineAndCollectTask;
import com.player2.playerengine.trackers.storage.ItemStorageTracker;
import com.player2.playerengine.util.CraftingRecipe;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.RecipeTarget;
import com.player2.playerengine.util.helpers.ItemHelper;
import java.util.Optional;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;

public class CollectSticksTask
extends ResourceTask {
    private final int targetCount;

    public CollectSticksTask(int targetCount) {
        super(class_1802.field_8600, targetCount);
        this.targetCount = targetCount;
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
        mod.getBehaviour().push();
    }

    @Override
    protected double getPickupRange(PlayerEngineController mod) {
        ItemStorageTracker storage = mod.getItemStorage();
        return storage.getItemCount(ItemHelper.PLANKS) * 4 + storage.getItemCount(ItemHelper.LOG) * 4 * 4 > this.targetCount ? 10.0 : 35.0;
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        if (mod.getItemStorage().getItemCount(class_1802.field_8648) >= 2) {
            return new CraftInInventoryTask(new RecipeTarget(class_1802.field_8600, Math.min(mod.getItemStorage().getItemCount(class_1802.field_8648) / 2, this.targetCount), CraftingRecipe.newShapedRecipe("sticks", new ItemTarget[]{new ItemTarget("bamboo"), null, new ItemTarget("bamboo"), null}, 1)));
        }
        Optional<class_2338> nearestBush = mod.getBlockScanner().getNearestBlock(class_2246.field_10428);
        return nearestBush.isPresent() && nearestBush.get().method_19769((class_2374)mod.getPlayer().method_19538(), 20.0) ? new MineAndCollectTask(class_1802.field_8689, 1, new class_2248[]{class_2246.field_10428}, MiningRequirement.HAND) : new CraftInInventoryTask(new RecipeTarget(class_1802.field_8600, this.targetCount, CraftingRecipe.newShapedRecipe("sticks", new ItemTarget[]{new ItemTarget("planks"), null, new ItemTarget("planks"), null}, 4)));
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
        mod.getBehaviour().pop();
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        return other instanceof CollectSticksTask;
    }

    @Override
    protected String toDebugStringName() {
        return "Crafting " + this.targetCount + " sticks";
    }
}

