/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.trackers.storage;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.trackers.Tracker;
import com.player2.playerengine.trackers.TrackerManager;
import com.player2.playerengine.trackers.storage.ContainerCache;
import com.player2.playerengine.trackers.storage.ContainerType;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;

public class ContainerSubTracker
extends Tracker {
    private final HashMap<Dimension, HashMap<class_2338, ContainerCache>> containerCaches = new HashMap();
    private class_2338 lastInteractedContainer;

    public ContainerSubTracker(TrackerManager manager) {
        super(manager);
        for (Dimension dimension : Dimension.values()) {
            this.containerCaches.put(dimension, new HashMap());
        }
    }

    public Optional<ContainerCache> WritableCache(PlayerEngineController controller, class_2338 pos) {
        class_2586 class_25862 = controller.getWorld().method_8321(pos);
        if (class_25862 instanceof class_1263) {
            class_1263 containerInventory = (class_1263)class_25862;
            this.lastInteractedContainer = pos;
            class_2248 block = controller.getWorld().method_8320(pos).method_26204();
            ContainerType type = ContainerType.getFromBlock(block);
            if (type == ContainerType.EMPTY) {
                return Optional.empty();
            }
            ContainerCache cache = this.containerCaches.get((Object)WorldHelper.getCurrentDimension(controller)).computeIfAbsent(pos, p -> new ContainerCache(WorldHelper.getCurrentDimension(controller), (class_2338)p, type));
            cache.update(containerInventory, s -> {});
            return Optional.of(cache);
        }
        this.containerCaches.get((Object)WorldHelper.getCurrentDimension(controller)).remove(pos);
        return Optional.empty();
    }

    public Optional<ContainerCache> getContainerAtPosition(class_2338 pos) {
        return Optional.ofNullable(this.containerCaches.get((Object)WorldHelper.getCurrentDimension(this.mod)).get(pos));
    }

    public List<ContainerCache> getCachedContainers(Predicate<ContainerCache> accept) {
        ArrayList<ContainerCache> result = new ArrayList<ContainerCache>();
        this.containerCaches.get((Object)WorldHelper.getCurrentDimension(this.mod)).values().forEach(cache -> {
            if (accept.test((ContainerCache)cache)) {
                result.add((ContainerCache)cache);
            }
        });
        return result;
    }

    public List<ContainerCache> getContainersWithItem(class_1792 ... items) {
        return this.getCachedContainers(cache -> cache.hasItem(items));
    }

    public Optional<class_2338> getLastInteractedContainer() {
        return Optional.ofNullable(this.lastInteractedContainer);
    }

    @Override
    protected void updateState() {
    }

    @Override
    protected void reset() {
        this.containerCaches.values().forEach(HashMap::clear);
        this.lastInteractedContainer = null;
    }
}

