/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.tasks.construction.PlaceBlockNearbyTask;
import com.player2.playerengine.tasks.construction.PlaceStructureBlockTask;
import com.player2.playerengine.tasks.construction.compound.ConstructIronGolemTask;
import com.player2.playerengine.tasks.construction.compound.ConstructNetherPortalObsidianTask;
import com.player2.playerengine.tasks.container.SmeltInFurnaceTask;
import com.player2.playerengine.tasks.container.StoreInAnyContainerTask;
import com.player2.playerengine.tasks.entity.KillEntityTask;
import com.player2.playerengine.tasks.entity.ShootArrowSimpleProjectileTask;
import com.player2.playerengine.tasks.examples.ExampleTask2;
import com.player2.playerengine.tasks.misc.EquipArmorTask;
import com.player2.playerengine.tasks.misc.PlaceBedAndSetSpawnTask;
import com.player2.playerengine.tasks.misc.RavageDesertTemplesTask;
import com.player2.playerengine.tasks.misc.RavageRuinedPortalsTask;
import com.player2.playerengine.tasks.movement.EnterNetherPortalTask;
import com.player2.playerengine.tasks.movement.GoToStrongholdPortalTask;
import com.player2.playerengine.tasks.movement.LocateDesertTempleTask;
import com.player2.playerengine.tasks.movement.PickupDroppedItemTask;
import com.player2.playerengine.tasks.movement.ThrowEnderPearlSimpleProjectileTask;
import com.player2.playerengine.tasks.resources.CollectBlazeRodsTask;
import com.player2.playerengine.tasks.resources.CollectFlintTask;
import com.player2.playerengine.tasks.resources.CollectFoodTask;
import com.player2.playerengine.tasks.resources.TradeWithPiglinsTask;
import com.player2.playerengine.tasks.speedrun.KillEnderDragonTask;
import com.player2.playerengine.tasks.speedrun.KillEnderDragonWithBedsTask;
import com.player2.playerengine.util.CraftingRecipe;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.SmeltTarget;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1571;
import net.minecraft.class_1642;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2812;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class Playground {
    public static void IDLE_TEST_INIT_FUNCTION(PlayerEngineController mod) {
    }

    public static void IDLE_TEST_TICK_FUNCTION(PlayerEngineController mod) {
    }

    public static void TEMP_TEST_FUNCTION(PlayerEngineController mod, String arg) {
        Debug.logMessage("Running test...");
        switch (arg) {
            case "": {
                Debug.logWarning("Please specify a test (ex. stacked, bed, terminate)");
                return;
            }
            case "pickup": {
                mod.runUserTask(new PickupDroppedItemTask(new ItemTarget(class_1802.field_33400, 3), true));
                return;
            }
            case "chunk": {
                class_2338 p = new class_2338(100000, 3, 100000);
                Debug.logMessage("LOADED? " + (!(mod.getWorld().method_22350(p) instanceof class_2812) ? 1 : 0));
                return;
            }
            case "structure": {
                mod.runUserTask(new PlaceStructureBlockTask(new class_2338(10, 6, 10)));
                return;
            }
            case "place": {
                mod.runUserTask(new PlaceBlockNearbyTask(class_2246.field_9980, class_2246.field_10181));
                return;
            }
            case "stacked": {
                mod.runUserTask(new EquipArmorTask(class_1802.field_8058, class_1802.field_8348, class_1802.field_8805, class_1802.field_8285));
                return;
            }
            case "stacked2": {
                mod.runUserTask(new EquipArmorTask(class_1802.field_8058));
                return;
            }
            case "ravage": {
                mod.runUserTask(new RavageRuinedPortalsTask());
                return;
            }
            case "temples": {
                mod.runUserTask(new RavageDesertTemplesTask());
                return;
            }
            case "smelt": {
                ItemTarget target = new ItemTarget("iron_ingot", 4);
                ItemTarget material = new ItemTarget("iron_ore", 4);
                mod.runUserTask(new SmeltInFurnaceTask(new SmeltTarget(target, material, new class_1792[0])));
                return;
            }
            case "iron": {
                mod.runUserTask(new ConstructIronGolemTask());
                return;
            }
            case "avoid": {
                mod.getBehaviour().avoidBlockBreaking(b -> -1000 < b.method_10263() && b.method_10263() < 1000 && -1000 < b.method_10264() && b.method_10264() < 1000 && -1000 < b.method_10260() && b.method_10260() < 1000);
                Debug.logMessage("Testing avoid from -1000, -1000, -1000 to 1000, 1000, 1000");
                return;
            }
            case "portal": {
                mod.runUserTask(new EnterNetherPortalTask(new ConstructNetherPortalObsidianTask(), WorldHelper.getCurrentDimension(mod) == Dimension.OVERWORLD ? Dimension.NETHER : Dimension.OVERWORLD));
                return;
            }
            case "kill": {
                List<class_1642> zombs = mod.getEntityTracker().getTrackedEntities(class_1642.class);
                if (zombs.size() == 0) {
                    Debug.logWarning("No zombs found.");
                } else {
                    class_1309 entity = (class_1309)zombs.get(0);
                    mod.runUserTask(new KillEntityTask((class_1297)entity));
                }
                return;
            }
            case "craft": {
                new Thread(() -> {
                    for (int i = 3; i > 0; --i) {
                        Debug.logMessage(i + "...");
                        Playground.sleepSec(1.0);
                    }
                    class_1792[] c = new class_1792[]{class_1802.field_20412};
                    class_1792[] s = new class_1792[]{class_1802.field_8600};
                    CraftingRecipe recipe = CraftingRecipe.newShapedRecipe("test pickaxe", new class_1792[][]{c, c, c, null, s, null, null, s, null}, 1);
                }).start();
                return;
            }
            case "food": {
                mod.runUserTask(new CollectFoodTask(20.0));
                return;
            }
            case "temple": {
                mod.runUserTask(new LocateDesertTempleTask());
                return;
            }
            case "blaze": {
                mod.runUserTask(new CollectBlazeRodsTask(7));
                return;
            }
            case "flint": {
                mod.runUserTask(new CollectFlintTask(5));
                return;
            }
            case "unobtainable": {
                String fname = "unobtainables.txt";
                try {
                    int unobtainable = 0;
                    int total = 0;
                    File f = new File(fname);
                    FileWriter fw = new FileWriter(f);
                    for (class_2960 id : class_7923.field_41178.method_10235()) {
                        class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
                        if (!TaskCatalogue.isObtainable(item)) {
                            ++unobtainable;
                            fw.write(item.method_7876() + "\n");
                        }
                        ++total;
                    }
                    fw.flush();
                    fw.close();
                    Debug.logMessage(unobtainable + " / " + unobtainable + " unobtainable items. Wrote a list of items to \"" + total + "\".");
                }
                catch (IOException var17) {
                    Debug.logWarning(var17.toString());
                }
                return;
            }
            case "piglin": {
                mod.runUserTask(new TradeWithPiglinsTask(32, new ItemTarget(class_1802.field_8634, 12)));
                return;
            }
            case "stronghold": {
                mod.runUserTask(new GoToStrongholdPortalTask(12));
                return;
            }
            case "bed": {
                mod.runUserTask(new PlaceBedAndSetSpawnTask());
                return;
            }
            case "dragon": {
                mod.runUserTask(new KillEnderDragonWithBedsTask());
                return;
            }
            case "dragon-pearl": {
                mod.runUserTask(new ThrowEnderPearlSimpleProjectileTask(new class_2338(0, 60, 0)));
                return;
            }
            case "dragon-old": {
                mod.runUserTask(new KillEnderDragonTask());
                return;
            }
            case "chest": {
                mod.runUserTask(new StoreInAnyContainerTask(true, new ItemTarget(class_1802.field_8477, 3)));
                return;
            }
            case "example": {
                mod.runUserTask(new ExampleTask2());
                return;
            }
            case "netherite": {
                mod.runUserTask(TaskCatalogue.getSquashedItemTask(new ItemTarget("netherite_pickaxe", 1), new ItemTarget("netherite_sword", 1), new ItemTarget("netherite_helmet", 1), new ItemTarget("netherite_chestplate", 1), new ItemTarget("netherite_leggings", 1), new ItemTarget("netherite_boots", 1)));
                return;
            }
            case "arrow": {
                List<class_1571> ghasts = mod.getEntityTracker().getTrackedEntities(class_1571.class);
                if (ghasts.size() == 0) {
                    Debug.logWarning("No ghasts found.");
                } else {
                    class_1571 ghast = ghasts.get(0);
                    mod.runUserTask(new ShootArrowSimpleProjectileTask((class_1297)ghast));
                }
                return;
            }
        }
        mod.logWarning("Test not found: \"" + arg + "\".");
    }

    private static void sleepSec(double seconds) {
        try {
            Thread.sleep((int)(1000.0 * seconds));
        }
        catch (InterruptedException var3) {
            var3.printStackTrace();
        }
    }
}

