/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util.helpers;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.pathing.movement.CalculationContext;
import com.player2.playerengine.automaton.pathing.movement.MovementHelper;
import com.player2.playerengine.automaton.process.MineProcess;
import com.player2.playerengine.automaton.utils.BlockStateInterface;
import com.player2.playerengine.multiversion.MethodWrapper;
import com.player2.playerengine.multiversion.world.WorldVer;
import com.player2.playerengine.util.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2304;
import net.minecraft.class_2331;
import net.minecraft.class_2336;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2363;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_2406;
import net.minecraft.class_243;
import net.minecraft.class_2449;
import net.minecraft.class_2496;
import net.minecraft.class_2586;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2742;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3708;
import net.minecraft.class_3711;
import net.minecraft.class_5321;
import net.minecraft.class_6880;

public interface WorldHelper {
    public static class_243 toVec3d(class_2338 pos) {
        return pos == null ? null : new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
    }

    public static class_243 toVec3d(class_2382 pos) {
        return new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
    }

    public static class_2382 toVec3i(class_243 pos) {
        return new class_2382((int)pos.method_10216(), (int)pos.method_10214(), (int)pos.method_10215());
    }

    public static class_2338 toBlockPos(class_243 pos) {
        return new class_2338((int)pos.method_10216(), (int)pos.method_10214(), (int)pos.method_10215());
    }

    public static boolean isSourceBlock(PlayerEngineController controller, class_2338 pos, boolean onlyAcceptStill) {
        class_3218 world = controller.getWorld();
        class_2680 s = world.method_8320(pos);
        if (s.method_26204() instanceof class_2404) {
            if (!s.method_26227().method_15771() && onlyAcceptStill) {
                return false;
            }
            int level = s.method_26227().method_15761();
            class_2680 above = world.method_8320(pos.method_10084());
            return above.method_26204() instanceof class_2404 ? false : level == 8;
        }
        return false;
    }

    public static double distanceXZSquared(class_243 from, class_243 to) {
        class_243 delta = to.method_1020(from);
        return delta.field_1352 * delta.field_1352 + delta.field_1350 * delta.field_1350;
    }

    public static double distanceXZ(class_243 from, class_243 to) {
        return Math.sqrt(WorldHelper.distanceXZSquared(from, to));
    }

    public static boolean inRangeXZ(class_243 from, class_243 to, double range) {
        return WorldHelper.distanceXZSquared(from, to) < range * range;
    }

    public static boolean inRangeXZ(class_2338 from, class_2338 to, double range) {
        return WorldHelper.inRangeXZ(WorldHelper.toVec3d(from), WorldHelper.toVec3d(to), range);
    }

    public static boolean inRangeXZ(class_1297 entity, class_243 to, double range) {
        return WorldHelper.inRangeXZ(entity.method_19538(), to, range);
    }

    public static boolean inRangeXZ(class_1297 entity, class_2338 to, double range) {
        return WorldHelper.inRangeXZ(entity, WorldHelper.toVec3d(to), range);
    }

    public static boolean inRangeXZ(class_1297 entity, class_1297 to, double range) {
        return WorldHelper.inRangeXZ(entity, to.method_19538(), range);
    }

    public static Dimension getCurrentDimension(PlayerEngineController controller) {
        class_3218 world = controller.getWorld();
        if (world == null) {
            return Dimension.OVERWORLD;
        }
        if (world.method_8597().comp_644()) {
            return Dimension.NETHER;
        }
        return world.method_8597().comp_645() ? Dimension.OVERWORLD : Dimension.END;
    }

    public static boolean isSolidBlock(PlayerEngineController controller, class_2338 pos) {
        class_3218 world = controller.getWorld();
        return world.method_8320(pos).method_26212((class_1922)world, pos);
    }

    public static class_2338 getBedHead(PlayerEngineController controller, class_2338 posWithBed) {
        class_3218 world = controller.getWorld();
        class_2680 state = world.method_8320(posWithBed);
        if (state.method_26204() instanceof class_2244) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)class_2244.field_11177);
            return ((class_2742)world.method_8320(posWithBed).method_11654((class_2769)class_2244.field_9967)).equals((Object)class_2742.field_12560) ? posWithBed : posWithBed.method_10093(facing);
        }
        return null;
    }

    public static class_2338 getBedFoot(PlayerEngineController controller, class_2338 posWithBed) {
        class_3218 world = controller.getWorld();
        class_2680 state = world.method_8320(posWithBed);
        if (state.method_26204() instanceof class_2244) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)class_2244.field_11177);
            return ((class_2742)world.method_8320(posWithBed).method_11654((class_2769)class_2244.field_9967)).equals((Object)class_2742.field_12557) ? posWithBed : posWithBed.method_10093(facing.method_10153());
        }
        return null;
    }

    public static int getGroundHeight(PlayerEngineController controller, int x, int z) {
        class_3218 world = controller.getWorld();
        for (int y = world.method_31600(); y >= world.method_31607(); --y) {
            class_2338 check = new class_2338(x, y, z);
            if (!WorldHelper.isSolidBlock(controller, check)) continue;
            return y;
        }
        return -1;
    }

    public static class_2338 getADesertTemple(PlayerEngineController controller) {
        class_3218 world = controller.getWorld();
        List<class_2338> stonePressurePlates = controller.getBlockScanner().getKnownLocations(class_2246.field_10158);
        if (!stonePressurePlates.isEmpty()) {
            for (class_2338 pos : stonePressurePlates) {
                if (world.method_8320(pos).method_26204() != class_2246.field_10158 || world.method_8320(pos.method_10074()).method_26204() != class_2246.field_10361 || world.method_8320(pos.method_10087(2)).method_26204() != class_2246.field_10375) continue;
                return pos;
            }
        }
        return null;
    }

    public static boolean isUnopenedChest(PlayerEngineController controller, class_2338 pos) {
        return controller.getItemStorage().getContainerAtPosition(pos).isEmpty();
    }

    public static int getGroundHeight(PlayerEngineController controller, int x, int z, class_2248 ... groundBlocks) {
        class_3218 world = controller.getWorld();
        HashSet<class_2248> possibleBlocks = new HashSet<class_2248>(Arrays.asList(groundBlocks));
        for (int y = world.method_31600(); y >= world.method_31607(); --y) {
            class_2338 check = new class_2338(x, y, z);
            if (!possibleBlocks.contains(world.method_8320(check).method_26204())) continue;
            return y;
        }
        return -1;
    }

    public static boolean canBreak(PlayerEngineController controller, class_2338 pos) {
        boolean prevInteractionPaused = controller.getExtraBaritoneSettings().isInteractionPaused();
        controller.getExtraBaritoneSettings().setInteractionPaused(false);
        boolean canBreak = controller.getWorld().method_8320(pos).method_26214((class_1922)controller.getWorld(), pos) >= 0.0f && !controller.getExtraBaritoneSettings().shouldAvoidBreaking(pos) && MineProcess.plausibleToBreak(new CalculationContext(controller.getBaritone()), pos) && WorldHelper.canReach(controller, pos);
        controller.getExtraBaritoneSettings().setInteractionPaused(prevInteractionPaused);
        return canBreak;
    }

    public static boolean isInNetherPortal(PlayerEngineController controller) {
        class_1309 player = controller.getPlayer();
        return player != null && player.field_51994 != null && player.field_51994.method_60709();
    }

    public static boolean canPlace(PlayerEngineController controller, class_2338 pos) {
        return !controller.getExtraBaritoneSettings().shouldAvoidPlacingAt(pos) && WorldHelper.canReach(controller, pos);
    }

    public static boolean canReach(PlayerEngineController controller, class_2338 pos) {
        return controller.getModSettings().shouldAvoidOcean() && controller.getPlayer().method_23318() > 47.0 && controller.getChunkTracker().isChunkLoaded(pos) && WorldHelper.isOcean((class_6880<class_1959>)controller.getWorld().method_23753(pos)) && pos.method_10264() < 64 && WorldHelper.getGroundHeight(controller, pos.method_10263(), pos.method_10260(), class_2246.field_10382) > pos.method_10264() ? false : !controller.getBlockScanner().isUnreachable(pos);
    }

    public static boolean isOcean(class_6880<class_1959> b) {
        return WorldVer.isBiome(b, (class_5321<class_1959>)class_1972.field_9423) || WorldVer.isBiome(b, (class_5321<class_1959>)class_1972.field_9467) || WorldVer.isBiome(b, (class_5321<class_1959>)class_1972.field_9470) || WorldVer.isBiome(b, (class_5321<class_1959>)class_1972.field_9446) || WorldVer.isBiome(b, (class_5321<class_1959>)class_1972.field_9418) || WorldVer.isBiome(b, (class_5321<class_1959>)class_1972.field_9439) || WorldVer.isBiome(b, (class_5321<class_1959>)class_1972.field_9441) || WorldVer.isBiome(b, (class_5321<class_1959>)class_1972.field_9408) || WorldVer.isBiome(b, (class_5321<class_1959>)class_1972.field_9435);
    }

    public static boolean isAir(PlayerEngineController controller, class_2338 pos) {
        return controller.getBlockScanner().isBlockAtPosition(pos, class_2246.field_10124, class_2246.field_10543, class_2246.field_10243);
    }

    public static boolean isAir(class_2248 block) {
        return block == class_2246.field_10124 || block == class_2246.field_10543 || block == class_2246.field_10243;
    }

    public static boolean isInteractableBlock(PlayerEngineController controller, class_2338 pos) {
        class_2248 block = controller.getWorld().method_8320(pos).method_26204();
        return block instanceof class_2281 || block instanceof class_2336 || block instanceof class_2304 || block instanceof class_2363 || block instanceof class_2406 || block instanceof class_3711 || block instanceof class_2331 || block instanceof class_2449 || block instanceof class_3708;
    }

    public static boolean isInsidePlayer(PlayerEngineController controller, class_2338 pos) {
        return pos.method_19769((class_2374)controller.getPlayer().method_19538(), 2.0);
    }

    public static Iterable<class_2338> getBlocksTouchingPlayer(class_1309 player) {
        return WorldHelper.getBlocksTouchingBox(player.method_5829());
    }

    public static Iterable<class_2338> getBlocksTouchingBox(class_238 box) {
        class_2338 min = new class_2338((int)box.field_1323, (int)box.field_1322, (int)box.field_1321);
        class_2338 max = new class_2338((int)box.field_1320, (int)box.field_1325, (int)box.field_1324);
        return WorldHelper.scanRegion(min, max);
    }

    public static Iterable<class_2338> scanRegion(final class_2338 start, final class_2338 end) {
        return () -> new Iterator<class_2338>(){
            int x;
            int y;
            int z;
            {
                this.x = start.method_10263();
                this.y = start.method_10264();
                this.z = start.method_10260();
            }

            @Override
            public boolean hasNext() {
                return this.y <= end.method_10264() && this.z <= end.method_10260() && this.x <= end.method_10263();
            }

            @Override
            public class_2338 next() {
                class_2338 result = new class_2338(this.x, this.y, this.z);
                ++this.x;
                if (this.x > end.method_10263()) {
                    this.x = start.method_10263();
                    ++this.z;
                    if (this.z > end.method_10260()) {
                        this.z = start.method_10260();
                        ++this.y;
                    }
                }
                return result;
            }
        };
    }

    public static boolean fallingBlockSafeToBreak(PlayerEngineController controller, class_2338 pos) {
        BlockStateInterface bsi = new BlockStateInterface(controller.getBaritone().getEntityContext());
        class_3218 clientWorld = controller.getWorld();
        if (clientWorld == null) {
            throw new AssertionError();
        }
        while (WorldHelper.isFallingBlock(controller, pos)) {
            if (MovementHelper.avoidBreaking(bsi, pos.method_10263(), pos.method_10264(), pos.method_10260(), clientWorld.method_8320(pos), controller.getBaritoneSettings())) {
                return false;
            }
            pos = pos.method_10084();
        }
        return true;
    }

    public static boolean isFallingBlock(PlayerEngineController controller, class_2338 pos) {
        class_3218 clientWorld = controller.getWorld();
        if (clientWorld == null) {
            throw new AssertionError();
        }
        return clientWorld.method_8320(pos).method_26204() instanceof class_2346;
    }

    public static class_1297 getSpawnerEntity(PlayerEngineController controller, class_2338 pos) {
        class_1297 class_12972;
        class_2586 class_25862;
        class_3218 world = controller.getWorld();
        class_2680 state = world.method_8320(pos);
        if (state.method_26204() instanceof class_2496 && (class_25862 = world.method_8321(pos)) instanceof class_2636) {
            class_2636 blockEntity = (class_2636)class_25862;
            class_12972 = MethodWrapper.getRenderedEntity(blockEntity.method_11390(), (class_1937)world, pos);
        } else {
            class_12972 = null;
        }
        return class_12972;
    }

    public static boolean isChest(PlayerEngineController controller, class_2338 block) {
        class_2248 b = controller.getWorld().method_8320(block).method_26204();
        return WorldHelper.isChest(b);
    }

    public static boolean isChest(class_2248 b) {
        return b instanceof class_2281 || b instanceof class_2336;
    }

    public static boolean isBlock(PlayerEngineController controller, class_2338 pos, class_2248 block) {
        return controller.getWorld().method_8320(pos).method_26204() == block;
    }

    public static boolean canSleep(PlayerEngineController controller) {
        class_3218 world = controller.getWorld();
        if (world != null) {
            if (world.method_8546() && world.method_8419()) {
                return true;
            }
            int time = WorldHelper.getTimeOfDay(controller);
            return 12542 <= time && time <= 23992;
        }
        return false;
    }

    public static int getTimeOfDay(PlayerEngineController controller) {
        class_3218 world = controller.getWorld();
        return world != null ? (int)(world.method_8532() % 24000L) : 0;
    }

    public static boolean isVulnerable(class_1309 player) {
        int armor = player.method_6096();
        float health = player.method_6032();
        if (armor <= 15 && health < 3.0f) {
            return true;
        }
        return armor < 10 && health < 10.0f ? true : armor < 5 && health < 18.0f;
    }

    public static boolean isSurroundedByHostiles(PlayerEngineController controller) {
        List<class_1309> hostiles = controller.getEntityTracker().getHostiles();
        return WorldHelper.isSurrounded(controller, hostiles);
    }

    public static boolean isSurrounded(PlayerEngineController controller, List<class_1309> entities) {
        class_1309 player = controller.getPlayer();
        class_2338 playerPos = player.method_24515();
        int MIN_SIDES_TO_SURROUND = 2;
        ArrayList<class_2350> uniqueSides = new ArrayList<class_2350>();
        for (class_1297 class_12972 : entities) {
            class_2338 entityPos;
            double angle;
            boolean isUnique;
            if (!class_12972.method_24516((class_1297)player, 8.0) || !(isUnique = !uniqueSides.contains(WorldHelper.getHorizontalDirectionFromYaw(angle = WorldHelper.calculateAngle(playerPos, entityPos = class_12972.method_24515()))))) continue;
            uniqueSides.add(WorldHelper.getHorizontalDirectionFromYaw(angle));
        }
        return uniqueSides.size() >= 2;
    }

    private static double calculateAngle(class_2338 origin, class_2338 target) {
        double translatedX = target.method_10263() - origin.method_10263();
        double translatedZ = target.method_10260() - origin.method_10260();
        double angleRad = Math.atan2(translatedZ, translatedX);
        double angleDeg = Math.toDegrees(angleRad);
        if ((angleDeg -= 90.0) < 0.0) {
            angleDeg += 360.0;
        }
        return angleDeg;
    }

    private static class_2350 getHorizontalDirectionFromYaw(double yaw) {
        if ((yaw %= 360.0) < 0.0) {
            yaw += 360.0;
        }
        if (!(yaw >= 45.0 && yaw < 135.0 || yaw >= -315.0 && yaw < -225.0)) {
            if (!(yaw >= 135.0 && yaw < 225.0 || yaw >= -225.0 && yaw < -135.0)) {
                return !(yaw >= 225.0 && yaw < 315.0 || yaw >= -135.0 && yaw < -45.0) ? class_2350.field_11035 : class_2350.field_11034;
            }
            return class_2350.field_11043;
        }
        return class_2350.field_11039;
    }
}

