/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.player2api.Player2APIService;
import com.player2.playerengine.player2api.auth.AuthenticationManager;
import dev.architectury.event.events.common.LifecycleEvent;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MCCommands {
    public static final Logger LOGGER = LogManager.getLogger((String)"PlayerEngine");

    public static void onInit() {
        LifecycleEvent.SERVER_STARTING.register(server -> {
            LOGGER.info("Server starting, registering MC commands");
            MCCommands.register(server);
        });
    }

    public static void register(MinecraftServer server) {
        CommandDispatcher dispatcher = server.method_3734().method_9235();
        MCCommands.registerFromDispatch((CommandDispatcher<class_2168>)dispatcher);
    }

    private static void registerFromDispatch(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"playerengine").then(MCCommands.registerRelog()));
    }

    private static LiteralArgumentBuilder<class_2168> registerRelog() {
        return (LiteralArgumentBuilder)class_2170.method_9247((String)"relog").executes(context -> {
            for (Player2APIService service : PlayerEngineController.staticAPIServices.values()) {
                LOGGER.info("relog command");
                String clientId = service.getClientId();
                class_3222 player = ((class_2168)context.getSource()).method_44023();
                AuthenticationManager.getInstance().invalidateToken((class_1657)player, clientId);
            }
            return 1;
        });
    }
}

