/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.behavior;

import com.player2.playerengine.automaton.api.behavior.IBehavior;
import com.player2.playerengine.automaton.api.pathing.calc.IPath;
import com.player2.playerengine.automaton.api.pathing.calc.IPathFinder;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.automaton.api.pathing.path.IPathExecutor;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import java.util.Optional;
import java.util.OptionalDouble;

public interface IPathingBehavior
extends IBehavior {
    default public OptionalDouble ticksRemainingInSegment() {
        return this.ticksRemainingInSegment(true);
    }

    default public OptionalDouble ticksRemainingInSegment(boolean includeCurrentMovement) {
        IPathExecutor current = this.getCurrent();
        if (current == null) {
            return OptionalDouble.empty();
        }
        int start = includeCurrentMovement ? current.getPosition() : current.getPosition() + 1;
        return OptionalDouble.of(current.getPath().ticksRemainingFrom(start));
    }

    public Optional<Double> estimatedTicksToGoal();

    public Goal getGoal();

    public boolean isPathing();

    default public boolean hasPath() {
        return this.getCurrent() != null;
    }

    public boolean cancelEverything();

    public void forceCancel();

    default public Optional<IPath> getPath() {
        return Optional.ofNullable(this.getCurrent()).map(IPathExecutor::getPath);
    }

    public Optional<? extends IPathFinder> getInProgress();

    public IPathExecutor getCurrent();

    public IPathExecutor getNext();

    public BetterBlockPos pathStart();

    public boolean isSafeToCancel();
}

