/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.entity;

import com.mojang.logging.LogUtils;
import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.utils.IBucketAccessor;
import com.player2.playerengine.util.EnchantmentUtils;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1292;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2402;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_2846;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_5552;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class LivingEntityInteractionManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected class_1937 world;
    protected final class_1309 livingEntity;
    private class_1934 gameMode = class_1934.field_9215;
    @Nullable
    private class_1934 previousGameMode;
    private boolean mining;
    private int startMiningTime;
    private class_2338 miningPos = class_2338.field_10980;
    private int tickCounter;
    private boolean failedToMine;
    private class_2338 failedMiningPos = class_2338.field_10980;
    private int failedStartMiningTime;
    private int blockBreakingProgress = -1;
    private boolean brokeBlock;

    public LivingEntityInteractionManager(class_1309 livingEntity) {
        this.livingEntity = livingEntity;
        this.world = livingEntity.method_37908();
    }

    public class_1934 getGameMode() {
        return this.gameMode;
    }

    @Nullable
    public class_1934 getPreviousGameMode() {
        return this.previousGameMode;
    }

    public boolean isSurvivalLike() {
        return this.gameMode.method_8388();
    }

    public boolean isCreative() {
        return this.gameMode.method_8386();
    }

    public void update() {
        ++this.tickCounter;
        if (this.failedToMine) {
            class_2680 blockState = this.world.method_8320(this.failedMiningPos);
            if (blockState.method_26215()) {
                this.failedToMine = false;
            } else {
                float f = this.continueMining(blockState, this.failedMiningPos, this.failedStartMiningTime);
                if (f >= 1.0f) {
                    this.failedToMine = false;
                    this.tryBreakBlock(this.failedMiningPos);
                }
            }
        } else if (this.mining) {
            class_2680 blockState = this.world.method_8320(this.miningPos);
            if (blockState.method_26215()) {
                this.world.method_8517(this.livingEntity.method_5628(), this.miningPos, -1);
                this.blockBreakingProgress = -1;
                this.mining = false;
            } else {
                this.continueMining(blockState, this.miningPos, this.startMiningTime);
            }
        }
    }

    private float continueMining(class_2680 state, class_2338 pos, int progress) {
        int i = this.tickCounter - progress;
        float f = this.calcBlockBreakingDelta(state, this.livingEntity, (class_1922)this.livingEntity.method_37908(), pos) * (float)(i + 1);
        int j = (int)(f * 10.0f);
        if (j != this.blockBreakingProgress) {
            this.world.method_8517(this.livingEntity.method_5628(), pos, j);
            this.blockBreakingProgress = j;
        }
        return f;
    }

    private void method_41250(class_2338 pos, boolean bl, int i, String string) {
    }

    public void processBlockBreakingAction(class_2338 pos, class_2846.class_2847 action, class_2350 direction, int worldHeight, int i) {
        if (this.livingEntity.method_33571().method_1025(class_243.method_24953((class_2382)pos)) > class_3532.method_33723((double)6.0)) {
            this.method_41250(pos, false, i, "too far");
        } else if (pos.method_10264() >= worldHeight) {
            this.method_41250(pos, false, i, "too high");
        } else if (action == class_2846.class_2847.field_12968) {
            if (this.isCreative()) {
                this.finishMining(pos, i, "creative destroy");
                return;
            }
            this.startMiningTime = this.tickCounter;
            float f = 1.0f;
            class_2680 blockState = this.world.method_8320(pos);
            if (!blockState.method_26215()) {
                f = this.calcBlockBreakingDelta(blockState, this.livingEntity, (class_1922)this.livingEntity.method_37908(), pos);
            }
            if (!blockState.method_26215() && f >= 1.0f) {
                this.finishMining(pos, i, "insta mine");
            } else {
                if (this.mining) {
                    this.method_41250(pos, false, i, "abort destroying since another started (client insta mine, server disagreed)");
                }
                this.mining = true;
                this.miningPos = pos.method_10062();
                this.brokeBlock = true;
                int j = (int)(f * 10.0f);
                this.world.method_8517(this.livingEntity.method_5628(), pos, j);
                this.method_41250(pos, true, i, "actual start of destroying");
                this.blockBreakingProgress = j;
            }
        } else if (action == class_2846.class_2847.field_12973) {
            if (pos.equals((Object)this.miningPos)) {
                int k = this.tickCounter - this.startMiningTime;
                class_2680 blockStatex = this.world.method_8320(pos);
                if (!blockStatex.method_26215()) {
                    float g = this.calcBlockBreakingDelta(blockStatex, this.livingEntity, (class_1922)this.livingEntity.method_37908(), pos) * (float)(k + 1);
                    if (g >= 0.7f) {
                        this.mining = false;
                        this.world.method_8517(this.livingEntity.method_5628(), pos, -1);
                        this.finishMining(pos, i, "destroyed");
                        return;
                    }
                    if (!this.failedToMine) {
                        this.mining = false;
                        this.failedToMine = true;
                        this.failedMiningPos = pos;
                        this.failedStartMiningTime = this.startMiningTime;
                    }
                }
            }
            this.method_41250(pos, true, i, "stopped destroying");
        } else if (action == class_2846.class_2847.field_12971) {
            this.mining = false;
            if (!Objects.equals(this.miningPos, pos)) {
                LOGGER.warn("Mismatch in destroy block pos: {} {}", (Object)this.miningPos, (Object)pos);
                this.world.method_8517(this.livingEntity.method_5628(), this.miningPos, -1);
                this.method_41250(pos, true, i, "aborted mismatched destroying");
            }
            this.world.method_8517(this.livingEntity.method_5628(), pos, -1);
            this.method_41250(pos, true, i, "aborted destroying");
        }
    }

    public float calcBlockBreakingDelta(class_2680 state, class_1309 player, class_1922 world, class_2338 pos) {
        float f = state.method_26214(world, pos);
        if (f == -1.0f) {
            return 0.0f;
        }
        int i = this.canHarvest(state, player.method_5998(class_1268.field_5808)) ? 30 : 100;
        return this.getBlockBreakingSpeed(player, state) / f / (float)i;
    }

    public boolean canHarvest(class_2680 state, class_1799 heldItem) {
        return !state.method_29291() || heldItem.method_7951(state);
    }

    public float getBlockBreakingSpeed(class_1309 entity, class_2680 block) {
        class_1799 itemStack;
        int i;
        float f = this.livingEntity.method_5998(class_1268.field_5808).method_7924(block);
        if (f > 1.0f && (i = EnchantmentUtils.getEnchantmentLevel(itemStack = this.livingEntity.method_5998(class_1268.field_5808), (class_5321<class_1887>)class_1893.field_9131)) > 0 && !itemStack.method_7960()) {
            f += (float)(i * i + 1);
        }
        if (class_1292.method_5576((class_1309)entity)) {
            f *= 1.0f + (float)(class_1292.method_5575((class_1309)entity) + 1) * 0.2f;
        }
        if (entity.method_6059(class_1294.field_5901)) {
            f *= (switch (entity.method_6112(class_1294.field_5901).method_5578()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            });
        }
        if (entity.method_5777(class_3486.field_15517) && EnchantmentUtils.getEnchantmentLevel(entity.method_6118(class_1304.field_6169), (class_5321<class_1887>)class_1893.field_9105) != 0) {
            f /= 5.0f;
        }
        if (!entity.method_24828()) {
            f /= 5.0f;
        }
        return f;
    }

    public void finishMining(class_2338 pos, int i, String reason) {
        if (this.tryBreakBlock(pos)) {
            this.method_41250(pos, true, i, reason);
        } else {
            this.method_41250(pos, false, i, reason);
        }
    }

    public boolean tryBreakBlock(class_2338 pos) {
        class_2680 blockState = this.world.method_8320(pos);
        class_2586 blockEntity = this.world.method_8321(pos);
        class_2248 block = blockState.method_26204();
        if (block instanceof class_5552) {
            this.world.method_8413(pos, blockState, blockState, 3);
            return false;
        }
        this.world.method_43276((class_6880)class_5712.field_28165, pos, class_5712.class_7397.method_43286((class_1297)this.livingEntity, (class_2680)blockState));
        boolean bl = this.world.method_8650(pos, false);
        if (bl) {
            block.method_9585((class_1936)this.world, pos, blockState);
        }
        if (this.isCreative()) {
            return true;
        }
        class_1799 itemStack = this.livingEntity.method_6047();
        class_1799 itemStack2 = itemStack.method_7972();
        boolean bl2 = true;
        itemStack.method_7909().method_7879(itemStack, this.world, blockState, pos, this.livingEntity);
        if (bl && bl2) {
            class_2248.method_9511((class_2680)blockState, (class_1937)this.world, (class_2338)pos, (class_2586)blockEntity, (class_1297)this.livingEntity, (class_1799)itemStack2);
        }
        return true;
    }

    public class_1269 interactItem(class_1309 player, class_1937 world, class_1799 stack, class_1268 hand) {
        if (this.gameMode == class_1934.field_9219) {
            return class_1269.field_5811;
        }
        int i = stack.method_7947();
        int j = stack.method_7919();
        try {
            class_1271<class_1799> typedActionResult;
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof class_1755) {
                class_1755 bucketItem = (class_1755)class_17922;
                typedActionResult = this.useBucket(bucketItem, world, player, hand);
            } else {
                typedActionResult = stack.method_7913(world, null, hand);
            }
            class_1799 itemStack = (class_1799)typedActionResult.method_5466();
            if (itemStack == stack && itemStack.method_7947() == i && itemStack.method_7935(player) <= 0 && itemStack.method_7919() == j) {
                return typedActionResult.method_5467();
            }
            if (typedActionResult.method_5467() == class_1269.field_5814 && itemStack.method_7935(player) > 0 && !player.method_6115()) {
                return typedActionResult.method_5467();
            }
            if (stack != itemStack) {
                player.method_6122(hand, itemStack);
            }
            if (this.isCreative() && itemStack != class_1799.field_8037) {
                itemStack.method_7939(i);
                if (itemStack.method_7963() && itemStack.method_7919() != j) {
                    itemStack.method_7974(j);
                }
            }
            if (itemStack.method_7960()) {
                player.method_6122(hand, class_1799.field_8037);
            }
            return typedActionResult.method_5467();
        }
        catch (Exception var10) {
            return class_1269.field_5811;
        }
    }

    public class_1271<class_1799> useBucket(class_1755 bucket, class_1937 world, class_1309 user, class_1268 hand) {
        class_2338 blockPos3;
        class_1799 itemStack = user.method_5998(hand);
        class_3965 blockHitResult = LivingEntityInteractionManager.raycast(world, user, ((IBucketAccessor)bucket).getFluid() == class_3612.field_15906 ? class_3959.class_242.field_1345 : class_3959.class_242.field_1348);
        if (blockHitResult.method_17783() == class_239.class_240.field_1333) {
            return class_1271.method_22430((Object)itemStack);
        }
        if (blockHitResult.method_17783() != class_239.class_240.field_1332) {
            return class_1271.method_22430((Object)itemStack);
        }
        class_2338 blockPos = blockHitResult.method_17777();
        class_2350 direction = blockHitResult.method_17780();
        class_2338 blockPos2 = blockPos.method_10093(direction);
        if (((IBucketAccessor)bucket).getFluid() == class_3612.field_15906) {
            class_2263 fluidDrainable;
            class_1799 itemStack2;
            class_2680 blockState = world.method_8320(blockPos);
            if (blockState.method_26204() instanceof class_2263 && !(itemStack2 = (fluidDrainable = (class_2263)blockState.method_26204()).method_9700(null, (class_1936)world, blockPos, blockState)).method_7960()) {
                fluidDrainable.method_32351().ifPresent(sound -> user.method_5783(sound, 1.0f, 1.0f));
                world.method_33596((class_1297)user, (class_6880)class_5712.field_28167, blockPos);
                class_1799 itemStack3 = LivingEntityInteractionManager.exchangeStack(itemStack, user, itemStack2);
                return class_1271.method_29237((Object)itemStack3, (boolean)world.method_8608());
            }
            return class_1271.method_22431((Object)itemStack);
        }
        class_2680 blockState = world.method_8320(blockPos);
        class_2338 class_23382 = blockPos3 = blockState.method_26204() instanceof class_2402 && ((IBucketAccessor)bucket).getFluid() == class_3612.field_15910 ? blockPos : blockPos2;
        if (bucket.method_7731(null, world, blockPos3, blockHitResult)) {
            bucket.method_7728(null, world, itemStack, blockPos3);
            return class_1271.method_29237((Object)new class_1799((class_1935)class_1802.field_8550), (boolean)world.method_8608());
        }
        return class_1271.method_22431((Object)itemStack);
    }

    public boolean canPlaceOn(class_1309 entity, class_2338 pos, class_2350 facing, class_1799 stack) {
        class_2338 blockPos = pos.method_10093(facing.method_10153());
        class_2694 cachedBlockPosition = new class_2694((class_4538)entity.method_37908(), blockPos, false);
        return stack.method_57357(cachedBlockPosition);
    }

    protected static class_3965 raycast(class_1937 world, class_1309 player, class_3959.class_242 fluidHandling) {
        float f = player.method_36455();
        float g = player.method_36454();
        class_243 vec3d = player.method_33571();
        float h = class_3532.method_15362((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float i = class_3532.method_15374((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float j = -class_3532.method_15362((float)(-f * ((float)Math.PI / 180)));
        float k = class_3532.method_15374((float)(-f * ((float)Math.PI / 180)));
        float l = i * j;
        float n = h * j;
        double d = 5.0;
        class_243 vec3d2 = vec3d.method_1031((double)l * 5.0, (double)k * 5.0, (double)n * 5.0);
        return world.method_17742(new class_3959(vec3d, vec3d2, class_3959.class_3960.field_17559, fluidHandling, (class_1297)player));
    }

    public static class_1799 exchangeStack(class_1799 inputStack, class_1309 player, class_1799 outputStack) {
        inputStack.method_7934(1);
        if (inputStack.method_7960()) {
            return outputStack;
        }
        if (!((IInventoryProvider)player).getLivingInventory().insertStack(outputStack)) {
            player.method_5775(outputStack);
        }
        return inputStack;
    }

    public boolean shouldCancelInteraction() {
        return false;
    }

    public class_1269 interactBlock(class_1309 player, class_1937 world, class_1799 stack, class_1268 hand, class_3965 hitResult) {
        class_2338 blockPos = hitResult.method_17777();
        class_2680 blockState = world.method_8320(blockPos);
        if (!blockState.method_26204().method_45382(world.method_45162())) {
            return class_1269.field_5814;
        }
        boolean bl = !player.method_6047().method_7960() || !player.method_6079().method_7960();
        boolean bl2 = this.shouldCancelInteraction() && bl;
        class_1799 itemStack = stack.method_7972();
        if (!bl2) {
            try {
                class_1269 actionResult = blockState.method_55780(stack, world, null, hand, hitResult).method_55645();
                if (actionResult.method_23665()) {
                    return actionResult;
                }
            }
            catch (NullPointerException actionResult) {
                // empty catch block
            }
        }
        if (!stack.method_7960()) {
            class_1269 actionResult2;
            class_1838 itemUsageContext = new class_1838(this, player.method_37908(), null, hand, player.method_5998(hand), hitResult){

                public boolean method_8046() {
                    return this.method_8046();
                }
            };
            if (this.isCreative()) {
                int i = stack.method_7947();
                actionResult2 = stack.method_7981(itemUsageContext);
                stack.method_7939(i);
            } else {
                actionResult2 = stack.method_7981(itemUsageContext);
            }
            return actionResult2;
        }
        return class_1269.field_5811;
    }

    public void setWorld(class_3218 world) {
        this.world = world;
    }

    public boolean isMining() {
        return this.mining;
    }

    public class_2338 getMiningPos() {
        return this.miningPos;
    }

    public int getBlockBreakingProgress() {
        return this.blockBreakingProgress;
    }

    public boolean hasBrokenBlock() {
        return this.brokeBlock;
    }
}

