/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.behavior;

import com.google.common.base.Preconditions;
import com.player2.playerengine.automaton.Baritone;
import com.player2.playerengine.automaton.api.behavior.ILookBehavior;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.behavior.Behavior;
import com.player2.playerengine.automaton.utils.InputOverrideHandler;
import net.minecraft.class_1309;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class LookBehavior
extends Behavior
implements ILookBehavior {
    private Rotation target;
    private Rotation secondaryTarget;
    private boolean force;

    public LookBehavior(Baritone baritone) {
        super(baritone);
    }

    @Override
    public void updateSecondaryTarget(Rotation target) {
        this.secondaryTarget = target;
    }

    @Override
    public void updateTarget(Rotation target, boolean force) {
        this.target = target;
        if (!force) {
            double rand = Math.random() - 0.5;
            if (Math.abs(rand) < 0.1) {
                rand *= 4.0;
            }
            this.target = new Rotation(this.target.getYaw() + (float)(rand * this.baritone.settings().randomLooking113.get()), this.target.getPitch());
        }
        this.force = force;
    }

    @Override
    public void onTickServer() {
        if (this.target != null || this.secondaryTarget != null) {
            this.updateLook(this.target, this.force, this.secondaryTarget);
        }
        this.target = null;
        this.secondaryTarget = null;
        this.force = false;
    }

    @Contract(value="null, true,  -> fail; null, , null -> fail")
    private void updateLook(@Nullable Rotation primaryTarget, boolean forcePrimary, @Nullable Rotation secondaryTarget) {
        Rotation actualTarget;
        Preconditions.checkArgument((primaryTarget != null || !forcePrimary ? 1 : 0) != 0);
        Preconditions.checkArgument((primaryTarget != null || secondaryTarget != null ? 1 : 0) != 0);
        if (!forcePrimary && !this.baritone.getInputOverrideHandler().isInputForcedDown(Input.SPRINT)) {
            actualTarget = this.getActualTarget(primaryTarget, secondaryTarget);
            if (actualTarget == null) {
                return;
            }
        } else {
            actualTarget = primaryTarget;
        }
        assert (actualTarget != null);
        class_1309 entity = this.ctx.entity();
        double lookScrambleFactor = this.baritone.settings().randomLooking.get();
        LookBehavior.updateLook(entity, actualTarget, lookScrambleFactor, this.baritone.settings().freeLook.get() == false);
    }

    private static void updateLook(class_1309 entity, Rotation target, double lookScrambleFactor, boolean nudgePitch) {
        entity.method_36456(target.getYaw());
        float oldPitch = entity.method_36455();
        float desiredPitch = target.getPitch();
        entity.method_36457(desiredPitch);
        entity.method_36456((float)((double)entity.method_36454() + (Math.random() - 0.5) * lookScrambleFactor));
        entity.method_36457((float)((double)entity.method_36455() + (Math.random() - 0.5) * lookScrambleFactor));
        if (desiredPitch == oldPitch && nudgePitch) {
            LookBehavior.nudgeToLevel(entity);
        }
    }

    @Nullable
    private Rotation getActualTarget(@Nullable Rotation primaryTarget, @Nullable Rotation secondaryTarget) {
        if (this.baritone.settings().freeLook.get().booleanValue()) {
            LookBehavior.updateControlsToMatch(this.baritone.getInputOverrideHandler(), primaryTarget, this.ctx.entity().method_36454());
            return null;
        }
        if (secondaryTarget != null) {
            LookBehavior.updateControlsToMatch(this.baritone.getInputOverrideHandler(), primaryTarget, secondaryTarget.getYaw());
            return secondaryTarget;
        }
        return primaryTarget;
    }

    public void pig() {
        if (this.target != null) {
            this.ctx.entity().method_36456(this.target.getYaw());
        }
    }

    private static void updateControlsToMatch(InputOverrideHandler inputs, Rotation target, float actualYaw) {
        if (target != null && inputs.isInputForcedDown(Input.MOVE_FORWARD)) {
            float desiredYaw = class_3532.method_15393((float)target.getYaw());
            float yawDifference = class_3532.method_15381((float)actualYaw, (float)desiredYaw);
            float absoluteDifference = Math.abs(yawDifference);
            if (absoluteDifference >= 89.0f) {
                inputs.setInputForceState(Input.MOVE_FORWARD, false);
                if (absoluteDifference >= 91.0f) {
                    inputs.setInputForceState(Input.MOVE_BACK, true);
                }
            }
            if (absoluteDifference >= 1.0f && absoluteDifference <= 179.0f) {
                if (yawDifference > 0.0f) {
                    inputs.setInputForceState(Input.MOVE_RIGHT, true);
                } else {
                    inputs.setInputForceState(Input.MOVE_LEFT, true);
                }
            }
        }
    }

    private static void nudgeToLevel(class_1309 entity) {
        if (entity.method_36455() < -20.0f) {
            entity.method_36457(entity.method_36455() + 1.0f);
        } else if (entity.method_36455() > 10.0f) {
            entity.method_36457(entity.method_36455() - 1.0f);
        }
    }
}

