/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.command.defaults;

import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.command.Command;
import com.player2.playerengine.automaton.api.command.argument.IArgConsumer;
import com.player2.playerengine.automaton.api.command.exception.CommandException;
import com.player2.playerengine.automaton.api.pathing.goals.GoalBlock;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.api.utils.IEntityContext;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_2168;
import net.minecraft.class_2189;
import net.minecraft.class_2338;

public class SurfaceCommand
extends Command {
    protected SurfaceCommand() {
        super("surface", "top");
    }

    @Override
    public void execute(class_2168 source, String label, IArgConsumer args, IBaritone baritone) throws CommandException {
        IEntityContext ctx = baritone.getEntityContext();
        BetterBlockPos playerPos = ctx.feetPos();
        int surfaceLevel = ctx.world().method_8615();
        int worldHeight = ctx.world().method_31605();
        if (playerPos.method_10264() > surfaceLevel && ctx.world().method_8320((class_2338)playerPos.up()).method_26204() instanceof class_2189) {
            this.logDirect(source, "Already at surface");
        } else {
            int startingYPos;
            for (int currentIteratedY = startingYPos = Math.max(playerPos.method_10264(), surfaceLevel); currentIteratedY < worldHeight; ++currentIteratedY) {
                BetterBlockPos newPos = new BetterBlockPos(playerPos.method_10263(), currentIteratedY, playerPos.method_10260());
                if (ctx.world().method_8320((class_2338)newPos).method_26204() instanceof class_2189 || newPos.method_10264() <= playerPos.method_10264()) continue;
                GoalBlock goal = new GoalBlock(newPos.up());
                this.logDirect(source, String.format("Going to: %s", ((Object)goal).toString()));
                baritone.getCustomGoalProcess().setGoalAndPath(goal);
                return;
            }
            this.logDirect(source, "No higher location found");
        }
    }

    @Override
    public Stream<String> tabComplete(String label, IArgConsumer args) {
        return Stream.empty();
    }

    @Override
    public String getShortDesc() {
        return "Used to get out of caves, mines, ...";
    }

    @Override
    public List<String> getLongDesc() {
        return Arrays.asList("The surface/top command makes an entity head towards the closest surface-like area.", "", "This can be the surface or the highest available air space, depending on circumstances.", "", "Usage:", "> surface - Used to get out of caves, mines, ...", "> top - Used to get out of caves, mines, ...");
    }
}

