/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.pathing.movement;

import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.pathing.movement.CalculationContext;
import com.player2.playerengine.automaton.pathing.movement.Movement;
import com.player2.playerengine.automaton.pathing.movement.movements.MovementAscend;
import com.player2.playerengine.automaton.pathing.movement.movements.MovementDescend;
import com.player2.playerengine.automaton.pathing.movement.movements.MovementDiagonal;
import com.player2.playerengine.automaton.pathing.movement.movements.MovementDownward;
import com.player2.playerengine.automaton.pathing.movement.movements.MovementFall;
import com.player2.playerengine.automaton.pathing.movement.movements.MovementParkour;
import com.player2.playerengine.automaton.pathing.movement.movements.MovementPillar;
import com.player2.playerengine.automaton.pathing.movement.movements.MovementTraverse;
import com.player2.playerengine.automaton.utils.pathing.MutableMoveResult;
import net.minecraft.class_2350;

public enum Moves {
    DOWNWARD(0, -1, 0){

        @Override
        public Movement apply0(CalculationContext context, BetterBlockPos src) {
            return new MovementDownward(context.getBaritone(), src, src.down());
        }

        @Override
        public void apply(CalculationContext context, int x, int y, int z, MutableMoveResult result) {
            this.applyOffset(x, y, z, result);
            MovementDownward.cost(context, x, y, z, result);
        }
    }
    ,
    PILLAR(0, 1, 0){

        @Override
        public Movement apply0(CalculationContext context, BetterBlockPos src) {
            return new MovementPillar(context.getBaritone(), src, src.up());
        }

        @Override
        public void apply(CalculationContext context, int x, int y, int z, MutableMoveResult result) {
            this.applyOffset(x, y, z, result);
            MovementPillar.cost(context, x, y, z, result);
        }
    }
    ,
    TRAVERSE_NORTH(0, 0, -1){

        @Override
        public Movement apply0(CalculationContext context, BetterBlockPos src) {
            return new MovementTraverse(context.getBaritone(), src, src.north());
        }

        @Override
        public void apply(CalculationContext context, int x, int y, int z, MutableMoveResult result) {
            this.applyOffset(x, y, z, result);
            MovementTraverse.cost(context, x, y, z, x, z - 1, result);
        }
    }
    ,
    TRAVERSE_SOUTH(0, 0, 1){

        @Override
        public Movement apply0(CalculationContext context, BetterBlockPos src) {
            return new MovementTraverse(context.getBaritone(), src, src.south());
        }

        @Override
        public void apply(CalculationContext context, int x, int y, int z, MutableMoveResult result) {
            this.applyOffset(x, y, z, result);
            MovementTraverse.cost(context, x, y, z, x, z + 1, result);
        }
    }
    ,
    TRAVERSE_EAST(1, 0, 0){

        @Override
        public Movement apply0(CalculationContext context, BetterBlockPos src) {
            return new MovementTraverse(context.getBaritone(), src, src.east());
        }

        @Override
        public void apply(CalculationContext context, int x, int y, int z, MutableMoveResult result) {
            this.applyOffset(x, y, z, result);
            MovementTraverse.cost(context, x, y, z, x + 1, z, result);
        }
    }
    ,
    TRAVERSE_WEST(-1, 0, 0){

        @Override
        public Movement apply0(CalculationContext context, BetterBlockPos src) {
            return new MovementTraverse(context.getBaritone(), src, src.west());
        }

        @Override
        public void apply(CalculationContext context, int x, int y, int z, MutableMoveResult result) {
            this.applyOffset(x, y, z, result);
            MovementTraverse.cost(context, x, y, z, x - 1, z, result);
        }
    }
    ,
    ASCEND_NORTH(0, 1, -1){

        @Override
        public Movement apply0(CalculationContext context, BetterBlockPos src) {
            return new MovementAscend(context.getBaritone(), src, new BetterBlockPos(src.x, src.y + 1, src.z - 1));
        }

        @Override
        public void apply(CalculationContext context, int x, int y, int z, MutableMoveResult result) {
            this.applyOffset(x, y, z, result);
            MovementAscend.cost(context, x, y, z, x, z - 1, result);
        }
    }
    ,
    ASCEND_SOUTH(0, 1, 1){

        @Override
        public Movement apply0(CalculationContext context, BetterBlockPos src) {
            return new MovementAscend(context.getBaritone(), src, new BetterBlockPos(src.x, src.y + 1, src.z + 1));
        }

        @Override
        public void apply(CalculationContext context, int x, int y, int z, MutableMoveResult result) {
            this.applyOffset(x, y, z, result);
            MovementAscend.cost(context, x, y, z, x, z + 1, result);
        }
    }
    ,
    ASCEND_EAST(1, 1, 0){

        @Override
        public Movement apply0(CalculationContext context, BetterBlockPos src) {
            return new MovementAscend(context.getBaritone(), src, new BetterBlockPos(src.x + 1, src.y + 1, src.z));
        }

        @Override
        public void apply(CalculationContext context, int x, int y, int z, MutableMoveResult result) {
            this.applyOffset(x, y, z, result);
            MovementAscend.cost(context, x, y, z, x + 1, z, result);
        }
    }
    ,
    ASCEND_WEST(-1, 1, 0){

        @Override
        public Movement apply0(CalculationContext context, BetterBlockPos src) {
            return new MovementAscend(context.getBaritone(), src, new BetterBlockPos(src.x - 1, src.y + 1, src.z));
        }

        @Override
        public void apply(CalculationContext context, int x, int y, int z, MutableMoveResult result) {
            this.applyOffset(x, y, z, result);
            MovementAscend.cost(context, x, y, z, x - 1, z, result);
        }
    }
    ,
    DESCEND_EAST(1, -1, 0, false, true){

        @Override
        public Movement apply0(CalculationContext context, BetterBlockPos src) {
            MutableMoveResult res = new MutableMoveResult();
            this.apply(context, src.x, src.y, src.z, res);
            return res.y == src.y - 1 ? new MovementDescend(context.getBaritone(), src, new BetterBlockPos(res.x, res.y, res.z)) : new MovementFall(context.getBaritone(), src, new BetterBlockPos(res.x, res.y, res.z));
        }

        @Override
        public void apply(CalculationContext context, int x, int y, int z, MutableMoveResult result) {
            MovementDescend.cost(context, x, y, z, x + 1, z, result);
        }
    }
    ,
    DESCEND_WEST(-1, -1, 0, false, true){

        @Override
        public Movement apply0(CalculationContext context, BetterBlockPos src) {
            MutableMoveResult res = new MutableMoveResult();
            this.apply(context, src.x, src.y, src.z, res);
            return res.y == src.y - 1 ? new MovementDescend(context.getBaritone(), src, new BetterBlockPos(res.x, res.y, res.z)) : new MovementFall(context.getBaritone(), src, new BetterBlockPos(res.x, res.y, res.z));
        }

        @Override
        public void apply(CalculationContext context, int x, int y, int z, MutableMoveResult result) {
            MovementDescend.cost(context, x, y, z, x - 1, z, result);
        }
    }
    ,
    DESCEND_NORTH(0, -1, -1, false, true){

        @Override
        public Movement apply0(CalculationContext context, BetterBlockPos src) {
            MutableMoveResult res = new MutableMoveResult();
            this.apply(context, src.x, src.y, src.z, res);
            return res.y == src.y - 1 ? new MovementDescend(context.getBaritone(), src, new BetterBlockPos(res.x, res.y, res.z)) : new MovementFall(context.getBaritone(), src, new BetterBlockPos(res.x, res.y, res.z));
        }

        @Override
        public void apply(CalculationContext context, int x, int y, int z, MutableMoveResult result) {
            MovementDescend.cost(context, x, y, z, x, z - 1, result);
        }
    }
    ,
    DESCEND_SOUTH(0, -1, 1, false, true){

        @Override
        public Movement apply0(CalculationContext context, BetterBlockPos src) {
            MutableMoveResult res = new MutableMoveResult();
            this.apply(context, src.x, src.y, src.z, res);
            return res.y == src.y - 1 ? new MovementDescend(context.getBaritone(), src, new BetterBlockPos(res.x, res.y, res.z)) : new MovementFall(context.getBaritone(), src, new BetterBlockPos(res.x, res.y, res.z));
        }

        @Override
        public void apply(CalculationContext context, int x, int y, int z, MutableMoveResult result) {
            MovementDescend.cost(context, x, y, z, x, z + 1, result);
        }
    }
    ,
    DIAGONAL_NORTHEAST(1, 0, -1, false, true){

        @Override
        public Movement apply0(CalculationContext context, BetterBlockPos src) {
            MutableMoveResult res = new MutableMoveResult();
            this.apply(context, src.x, src.y, src.z, res);
            return new MovementDiagonal(context.getBaritone(), src, class_2350.field_11043, class_2350.field_11034, res.y - src.y);
        }

        @Override
        public void apply(CalculationContext context, int x, int y, int z, MutableMoveResult result) {
            MovementDiagonal.cost(context, x, y, z, x + 1, z - 1, result);
        }
    }
    ,
    DIAGONAL_NORTHWEST(-1, 0, -1, false, true){

        @Override
        public Movement apply0(CalculationContext context, BetterBlockPos src) {
            MutableMoveResult res = new MutableMoveResult();
            this.apply(context, src.x, src.y, src.z, res);
            return new MovementDiagonal(context.getBaritone(), src, class_2350.field_11043, class_2350.field_11039, res.y - src.y);
        }

        @Override
        public void apply(CalculationContext context, int x, int y, int z, MutableMoveResult result) {
            MovementDiagonal.cost(context, x, y, z, x - 1, z - 1, result);
        }
    }
    ,
    DIAGONAL_SOUTHEAST(1, 0, 1, false, true){

        @Override
        public Movement apply0(CalculationContext context, BetterBlockPos src) {
            MutableMoveResult res = new MutableMoveResult();
            this.apply(context, src.x, src.y, src.z, res);
            return new MovementDiagonal(context.getBaritone(), src, class_2350.field_11035, class_2350.field_11034, res.y - src.y);
        }

        @Override
        public void apply(CalculationContext context, int x, int y, int z, MutableMoveResult result) {
            MovementDiagonal.cost(context, x, y, z, x + 1, z + 1, result);
        }
    }
    ,
    DIAGONAL_SOUTHWEST(-1, 0, 1, false, true){

        @Override
        public Movement apply0(CalculationContext context, BetterBlockPos src) {
            MutableMoveResult res = new MutableMoveResult();
            this.apply(context, src.x, src.y, src.z, res);
            return new MovementDiagonal(context.getBaritone(), src, class_2350.field_11035, class_2350.field_11039, res.y - src.y);
        }

        @Override
        public void apply(CalculationContext context, int x, int y, int z, MutableMoveResult result) {
            MovementDiagonal.cost(context, x, y, z, x - 1, z + 1, result);
        }
    }
    ,
    PARKOUR_NORTH(0, 0, -4, true, true){

        @Override
        public Movement apply0(CalculationContext context, BetterBlockPos src) {
            return MovementParkour.cost(context, src, class_2350.field_11043);
        }

        @Override
        public void apply(CalculationContext context, int x, int y, int z, MutableMoveResult result) {
            MovementParkour.cost(context, x, y, z, class_2350.field_11043, result);
        }
    }
    ,
    PARKOUR_SOUTH(0, 0, 4, true, true){

        @Override
        public Movement apply0(CalculationContext context, BetterBlockPos src) {
            return MovementParkour.cost(context, src, class_2350.field_11035);
        }

        @Override
        public void apply(CalculationContext context, int x, int y, int z, MutableMoveResult result) {
            MovementParkour.cost(context, x, y, z, class_2350.field_11035, result);
        }
    }
    ,
    PARKOUR_EAST(4, 0, 0, true, true){

        @Override
        public Movement apply0(CalculationContext context, BetterBlockPos src) {
            return MovementParkour.cost(context, src, class_2350.field_11034);
        }

        @Override
        public void apply(CalculationContext context, int x, int y, int z, MutableMoveResult result) {
            MovementParkour.cost(context, x, y, z, class_2350.field_11034, result);
        }
    }
    ,
    PARKOUR_WEST(-4, 0, 0, true, true){

        @Override
        public Movement apply0(CalculationContext context, BetterBlockPos src) {
            return MovementParkour.cost(context, src, class_2350.field_11039);
        }

        @Override
        public void apply(CalculationContext context, int x, int y, int z, MutableMoveResult result) {
            MovementParkour.cost(context, x, y, z, class_2350.field_11039, result);
        }
    };

    public final boolean dynamicXZ;
    public final boolean dynamicY;
    public final int xOffset;
    public final int yOffset;
    public final int zOffset;

    private Moves(int x, int y, int z, boolean dynamicXZ, boolean dynamicY) {
        this.xOffset = x;
        this.yOffset = y;
        this.zOffset = z;
        this.dynamicXZ = dynamicXZ;
        this.dynamicY = dynamicY;
    }

    private Moves(int x, int y, int z) {
        this(x, y, z, false, false);
    }

    public abstract Movement apply0(CalculationContext var1, BetterBlockPos var2);

    public abstract void apply(CalculationContext var1, int var2, int var3, int var4, MutableMoveResult var5);

    protected void applyOffset(int x, int y, int z, MutableMoveResult result) {
        if (this.dynamicXZ || this.dynamicY) {
            throw new UnsupportedOperationException();
        }
        result.x = x + this.xOffset;
        result.y = y + this.yOffset;
        result.z = z + this.zOffset;
    }
}

