/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.process;

import com.player2.playerengine.automaton.Baritone;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.automaton.api.pathing.goals.GoalBlock;
import com.player2.playerengine.automaton.api.process.IBaritoneProcess;
import com.player2.playerengine.automaton.api.process.PathingCommand;
import com.player2.playerengine.automaton.api.process.PathingCommandType;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.RotationUtils;
import com.player2.playerengine.automaton.entity.CustomFishingBobberEntity;
import com.player2.playerengine.automaton.pathing.movement.MovementHelper;
import com.player2.playerengine.automaton.utils.BaritoneProcessHelper;
import java.util.Optional;
import java.util.stream.StreamSupport;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1787;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public final class FishingProcess
extends BaritoneProcessHelper
implements IBaritoneProcess {
    private boolean active = false;
    private State currentState = State.IDLE;
    private class_2338 fishingSpot = null;
    private CustomFishingBobberEntity bobber = null;
    private int timeoutTicks = 0;

    public FishingProcess(Baritone baritone) {
        super(baritone);
    }

    public void fish() {
        this.active = true;
        this.currentState = State.IDLE;
        this.fishingSpot = null;
        this.bobber = null;
        this.timeoutTicks = 0;
        this.logDirect("Fishing process started.");
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void onLostControl() {
        this.active = false;
        this.bobber = null;
    }

    @Override
    public String displayName0() {
        return "Fishing: " + this.currentState.toString();
    }

    @Override
    public PathingCommand onTick(boolean calcFailed, boolean isSafeToCancel) {
        if (this.findFishingRodSlot() == -1) {
            this.onLostControl();
            return null;
        }
        if (calcFailed) {
            this.onLostControl();
            return null;
        }
        switch (this.currentState.ordinal()) {
            case 0: {
                return this.handleIdleState();
            }
            case 1: {
                return this.handleWalkingState();
            }
            case 2: {
                this.handlePreparingToCastState();
                break;
            }
            case 3: {
                this.handleCastingState();
                break;
            }
            case 4: {
                this.handleWaitingForBiteState();
                break;
            }
            case 5: {
                this.handleReelingInState();
                break;
            }
            case 6: 
            case 7: {
                this.handleDelayStates();
            }
        }
        return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
    }

    private PathingCommand handleIdleState() {
        Optional<class_2338> spot = this.findWaterSpot();
        if (spot.isPresent()) {
            this.fishingSpot = spot.get().method_10084();
            this.currentState = State.WALKING_TO_WATER;
            return new PathingCommand(new GoalBlock(this.fishingSpot), PathingCommandType.SET_GOAL_AND_PATH);
        }
        this.onLostControl();
        return null;
    }

    private PathingCommand handleWalkingState() {
        GoalBlock goal = new GoalBlock(this.fishingSpot);
        if (goal.isInGoal(this.ctx.feetPos())) {
            this.currentState = State.PREPARING_TO_CAST;
            this.timeoutTicks = 0;
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        return new PathingCommand(goal, PathingCommandType.SET_GOAL_AND_PATH);
    }

    private void handlePreparingToCastState() {
        class_2338 waterBlock = this.findAdjacentWater(this.fishingSpot.method_10074());
        if (waterBlock == null) {
            this.onLostControl();
        } else {
            Rotation rotation = RotationUtils.calcRotationFromVec3d(this.ctx.headPos(), class_243.method_24953((class_2382)waterBlock));
            this.baritone.getLookBehavior().updateTarget(rotation, true);
            if (this.ctx.entityRotations().isReallyCloseTo(rotation)) {
                this.currentState = State.CASTING;
            }
        }
    }

    private void handleCastingState() {
        this.equipFishingRod();
        this.useFishingRod((class_1937)this.ctx.world(), this.ctx.entity(), class_1268.field_5808);
        this.currentState = State.WAITING_FOR_BITE;
        this.timeoutTicks = 0;
    }

    private void handleWaitingForBiteState() {
        if (this.bobber == null || !this.bobber.method_5805() || this.timeoutTicks < 60) {
            this.bobber = this.findOurBobber();
            if (this.bobber == null || this.timeoutTicks < 60) {
                ++this.timeoutTicks;
                if (this.timeoutTicks > 70) {
                    this.currentState = State.RECAST_DELAY;
                }
                return;
            }
        }
        if (this.bobber.method_18798().field_1351 < -0.04) {
            this.currentState = State.REELING_IN;
        } else {
            ++this.timeoutTicks;
            if (this.timeoutTicks > 1200) {
                this.currentState = State.RECAST_DELAY;
            }
        }
    }

    private void handleReelingInState() {
        this.equipFishingRod();
        this.useFishingRod((class_1937)this.ctx.world(), this.ctx.entity(), class_1268.field_5808);
        this.bobber = null;
        this.currentState = State.WAITING_FOR_ITEMS;
        this.timeoutTicks = 20;
    }

    private void handleDelayStates() {
        --this.timeoutTicks;
        if (this.timeoutTicks <= 0) {
            if (this.currentState == State.WAITING_FOR_ITEMS) {
                this.currentState = State.RECAST_DELAY;
                this.timeoutTicks = 10;
            } else {
                this.currentState = State.PREPARING_TO_CAST;
            }
        }
    }

    private Optional<class_2338> findWaterSpot() {
        BetterBlockPos center = this.ctx.feetPos();
        for (class_2338 pos : class_2338.method_10097((class_2338)center.method_10069(-8, -3, -8), (class_2338)center.method_10069(8, 3, 8))) {
            if (!this.ctx.world().method_8320(pos).method_27852(class_2246.field_10382) || !this.ctx.world().method_8320(pos.method_10084()).method_26215() || !this.ctx.world().method_8320(pos.method_10086(2)).method_26215()) continue;
            for (class_2350 dir : class_2350.class_2353.field_11062) {
                class_2338 standPos = pos.method_10093(dir);
                if (!MovementHelper.canWalkOn(this.ctx, standPos) || !this.ctx.world().method_8320(standPos.method_10084()).method_26215() || !this.ctx.world().method_8320(standPos.method_10086(2)).method_26215()) continue;
                return Optional.of(standPos.method_10062());
            }
        }
        return Optional.empty();
    }

    private class_2338 findAdjacentWater(class_2338 position) {
        for (class_2350 dir : class_2350.class_2353.field_11062) {
            if (!this.ctx.world().method_8320(position.method_10093(dir)).method_27852(class_2246.field_10382)) continue;
            return position.method_10093(dir);
        }
        return null;
    }

    private int findFishingRodSlot() {
        LivingEntityInventory inv = this.ctx.inventory();
        for (int i = 0; i < 9; ++i) {
            if (!(inv.method_5438(i).method_7909() instanceof class_1787)) continue;
            return i;
        }
        return -1;
    }

    private void equipFishingRod() {
        int slot = this.findFishingRodSlot();
        if (slot != -1) {
            this.ctx.inventory().selectedSlot = slot;
        }
    }

    @Nullable
    private CustomFishingBobberEntity findOurBobber() {
        return StreamSupport.stream(this.ctx.world().method_27909().spliterator(), false).filter(e -> e instanceof CustomFishingBobberEntity).filter(e -> ((CustomFishingBobberEntity)((Object)e)).getPlayerOwner() == this.ctx.entity()).findFirst().orElse(null);
    }

    public class_1271<class_1799> useFishingRod(class_1937 world, class_1309 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        CustomFishingBobberEntity bobber = this.findOurBobber();
        if (bobber != null) {
            if (!world.field_9236) {
                int i = bobber.use(itemStack);
                itemStack.method_7970(i, user, class_1304.field_6173);
            }
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_15093, class_3419.field_15254, 1.0f, 0.4f / (world.method_8409().method_43057() * 0.4f + 0.8f));
            user.method_32876((class_6880)class_5712.field_28146);
        } else {
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14596, class_3419.field_15254, 0.5f, 0.4f / (world.method_8409().method_43057() * 0.4f + 0.8f));
            if (!world.field_9236) {
                int i = (int)(class_1890.method_60158((class_3218)((class_3218)world), (class_1799)itemStack, (class_1297)user) * 20.0f);
                int j = class_1890.method_8223((class_3218)((class_3218)world), (class_1799)itemStack, (class_1297)user);
                world.method_8649((class_1297)new CustomFishingBobberEntity(user, world, j, i));
            }
            user.method_32876((class_6880)class_5712.field_28145);
        }
        return class_1271.method_29237((Object)itemStack, (boolean)world.method_8608());
    }

    private static enum State {
        IDLE,
        WALKING_TO_WATER,
        PREPARING_TO_CAST,
        CASTING,
        WAITING_FOR_BITE,
        REELING_IN,
        WAITING_FOR_ITEMS,
        RECAST_DELAY;

    }
}

