/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.chains;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.chains.FoodChain;
import com.player2.playerengine.chains.SingleTaskChain;
import com.player2.playerengine.tasks.base.TaskRunner;
import com.player2.playerengine.tasks.construction.DestroyBlockTask;
import com.player2.playerengine.tasks.movement.GetOutOfWaterTask;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.tasks.movement.SafeRandomShimmyTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.time.TimerGame;
import java.util.LinkedList;
import net.minecraft.class_1309;
import net.minecraft.class_2246;
import net.minecraft.class_2333;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;

public class UnstuckChain
extends SingleTaskChain {
    private final LinkedList<class_243> posHistory = new LinkedList();
    private final TimerGame shimmyTimer = new TimerGame(5.0);
    private final TimerGame placeBlockGoToBlockTimeout = new TimerGame(5.0);
    private boolean isProbablyStuck = false;
    private int eatingTicks = 0;
    private boolean interruptedEating = false;
    private boolean startedShimmying = false;
    private class_2338 placeBlockGoToBlock = null;

    public UnstuckChain(TaskRunner runner) {
        super(runner);
    }

    @Override
    public float getPriority() {
        if (this.controller != null && this.controller.getTaskRunner().isActive()) {
            this.isProbablyStuck = false;
            class_1309 player = this.controller.getEntity();
            this.posHistory.addFirst(player.method_19538());
            if (this.posHistory.size() > 500) {
                this.posHistory.removeLast();
            }
            this.checkStuckInWater();
            this.checkStuckInPowderSnow();
            this.checkEatingGlitch();
            this.checkStuckOnEndPortalFrame();
            if (this.isProbablyStuck) {
                return 65.0f;
            }
            if (this.startedShimmying && !this.shimmyTimer.elapsed()) {
                this.setTask(new SafeRandomShimmyTask());
                return 65.0f;
            }
            this.startedShimmying = false;
            if (this.placeBlockGoToBlockTimeout.elapsed()) {
                this.placeBlockGoToBlock = null;
            }
            if (this.placeBlockGoToBlock != null) {
                this.setTask(new GetToBlockTask(this.placeBlockGoToBlock, false));
                return 65.0f;
            }
            return Float.NEGATIVE_INFINITY;
        }
        return Float.NEGATIVE_INFINITY;
    }

    private void checkStuckInWater() {
        if (this.posHistory.size() >= 100) {
            class_1309 player = this.controller.getEntity();
            class_3218 world = this.controller.getWorld();
            if (world.method_8320(player.method_24515()).method_27852(class_2246.field_10382)) {
                if (!player.method_24828() && player.method_5669() >= player.method_5748()) {
                    class_243 firstPos = this.posHistory.get(0);
                    for (int i = 1; i < 100; ++i) {
                        class_243 nextPos = this.posHistory.get(i);
                        if (!(Math.abs(firstPos.method_10216() - nextPos.method_10216()) > 0.75) && !(Math.abs(firstPos.method_10215() - nextPos.method_10215()) > 0.75)) continue;
                        return;
                    }
                    this.posHistory.clear();
                    this.setTask(new GetOutOfWaterTask());
                    this.isProbablyStuck = true;
                } else {
                    this.posHistory.clear();
                }
            }
        }
    }

    private void checkStuckInPowderSnow() {
        class_1309 player = this.controller.getEntity();
        if (player.field_27857) {
            this.isProbablyStuck = true;
            class_2338 playerPos = player.method_24515();
            class_2338 toBreak = null;
            if (player.method_37908().method_8320(playerPos).method_27852(class_2246.field_27879)) {
                toBreak = playerPos;
            } else if (player.method_37908().method_8320(playerPos.method_10084()).method_27852(class_2246.field_27879)) {
                toBreak = playerPos.method_10084();
            }
            if (toBreak != null) {
                this.setTask(new DestroyBlockTask(toBreak));
            } else {
                this.setTask(new SafeRandomShimmyTask());
            }
        }
    }

    private void checkStuckOnEndPortalFrame() {
        class_2680 standingOn = this.controller.getWorld().method_8320(this.controller.getEntity().method_23312());
        if (standingOn.method_27852(class_2246.field_10398) && !((Boolean)standingOn.method_11654((class_2769)class_2333.field_10958)).booleanValue() && !this.controller.getFoodChain().isTryingToEat()) {
            this.isProbablyStuck = true;
            this.controller.getBaritone().getInputOverrideHandler().setInputForceState(Input.MOVE_FORWARD, true);
        }
    }

    private void checkEatingGlitch() {
        FoodChain foodChain = this.controller.getFoodChain();
        if (this.interruptedEating) {
            foodChain.shouldStop(false);
            this.interruptedEating = false;
        }
        this.eatingTicks = foodChain.isTryingToEat() ? ++this.eatingTicks : 0;
        if (this.eatingTicks > 140) {
            Debug.logMessage("Bot is probably stuck trying to eat. Resetting action.");
            foodChain.shouldStop(true);
            this.eatingTicks = 0;
            this.interruptedEating = true;
            this.isProbablyStuck = true;
        }
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    protected void onTaskFinish(PlayerEngineController controller) {
    }

    @Override
    public String getName() {
        return "Unstuck Chain";
    }
}

