/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.commands;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.eventbus.EventBus;
import com.player2.playerengine.eventbus.events.BlockPlaceEvent;
import com.player2.playerengine.multiversion.blockpos.BlockPosVer;
import com.player2.playerengine.trackers.blacklisting.WorldLocateBlacklist;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.helpers.BaritoneHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.function.Predicate;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3218;

public class BlockScanner {
    private static final boolean LOG = false;
    private static final int RESCAN_TICK_DELAY = 80;
    private static final int CACHED_POSITIONS_PER_BLOCK = 40;
    private final PlayerEngineController mod;
    private final TimerGame rescanTimer = new TimerGame(1.0);
    private final HashMap<class_2248, HashSet<class_2338>> trackedBlocks = new HashMap();
    private final HashMap<class_2248, HashSet<class_2338>> scannedBlocks = new HashMap();
    private final HashMap<class_1923, Long> scannedChunks = new HashMap();
    private final WorldLocateBlacklist blacklist = new WorldLocateBlacklist();
    private HashMap<class_2248, HashSet<class_2338>> cachedScannedBlocks = new HashMap();
    private Dimension scanDimension = Dimension.OVERWORLD;
    private class_1937 scanWorld = null;
    private boolean scanning = false;
    private boolean forceStop = false;

    public BlockScanner(PlayerEngineController mod) {
        this.mod = mod;
        EventBus.subscribe(BlockPlaceEvent.class, evt -> this.addBlock(evt.blockState.method_26204(), evt.blockPos));
    }

    public void addBlock(class_2248 block, class_2338 pos) {
        if (!this.isBlockAtPosition(pos, block)) {
            Debug.logInternal("INVALID SET: " + String.valueOf(block) + " " + String.valueOf(pos));
        } else if (this.trackedBlocks.containsKey(block)) {
            this.trackedBlocks.get(block).add(pos);
        } else {
            HashSet<class_2338> set = new HashSet<class_2338>();
            set.add(pos);
            this.trackedBlocks.put(block, set);
        }
    }

    public void requestBlockUnreachable(class_2338 pos, int allowedFailures) {
        this.blacklist.blackListItem(this.mod, pos, allowedFailures);
    }

    public void requestBlockUnreachable(class_2338 pos) {
        this.blacklist.blackListItem(this.mod, pos, 4);
    }

    public boolean isUnreachable(class_2338 pos) {
        return this.blacklist.unreachable(pos);
    }

    public List<class_2338> getKnownLocationsIncludeUnreachable(class_2248 ... blocks) {
        LinkedList<class_2338> locations = new LinkedList<class_2338>();
        for (class_2248 block : blocks) {
            if (!this.trackedBlocks.containsKey(block)) continue;
            locations.addAll((Collection<class_2338>)this.trackedBlocks.get(block));
        }
        return locations;
    }

    public List<class_2338> getKnownLocations(class_2248 ... blocks) {
        List<class_2338> locations = this.getKnownLocationsIncludeUnreachable(blocks);
        locations.removeIf(this::isUnreachable);
        return locations;
    }

    public Optional<class_2338> getNearestWithinRange(class_243 pos, double range, class_2248 ... blocks) {
        Optional<class_2338> nearest = this.getNearestBlock(pos, blocks);
        return !nearest.isEmpty() && !nearest.get().method_19771(new class_2382((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350), range) ? Optional.empty() : nearest;
    }

    public Optional<class_2338> getNearestWithinRange(class_2338 pos, double range, class_2248 ... blocks) {
        return this.getNearestWithinRange(new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()), range, blocks);
    }

    public boolean anyFound(class_2248 ... blocks) {
        return this.anyFound((class_2338 block) -> true, blocks);
    }

    public boolean anyFound(Predicate<class_2338> isValidTest, class_2248 ... blocks) {
        for (class_2248 block : blocks) {
            if (!this.trackedBlocks.containsKey(block)) continue;
            for (class_2338 pos : this.trackedBlocks.get(block)) {
                if (!isValidTest.test(pos) || !this.mod.getWorld().method_8320(pos).method_26204().equals(block) || this.isUnreachable(pos)) continue;
                return true;
            }
        }
        return false;
    }

    public Optional<class_2338> getNearestBlock(class_2248 ... blocks) {
        return this.getNearestBlock(this.mod.getPlayer().method_19538().method_1031(0.0, (double)0.6f, 0.0), blocks);
    }

    public Optional<class_2338> getNearestBlock(class_243 pos, class_2248 ... blocks) {
        return this.getNearestBlock(pos, (class_2338 p) -> true, blocks);
    }

    public Optional<class_2338> getNearestBlock(Predicate<class_2338> isValidTest, class_2248 ... blocks) {
        return this.getNearestBlock(this.mod.getPlayer().method_19538().method_1031(0.0, (double)0.6f, 0.0), isValidTest, blocks);
    }

    public Optional<class_2338> getNearestBlock(class_243 pos, Predicate<class_2338> isValidTest, class_2248 ... blocks) {
        Optional<class_2338> closest = Optional.empty();
        for (class_2248 block : blocks) {
            Optional<class_2338> p = this.getNearestBlock(block, isValidTest, pos);
            if (!p.isPresent()) continue;
            if (closest.isEmpty()) {
                closest = p;
                continue;
            }
            if (!(BaritoneHelper.calculateGenericHeuristic(pos, WorldHelper.toVec3d(closest.get())) > BaritoneHelper.calculateGenericHeuristic(pos, WorldHelper.toVec3d(p.get())))) continue;
            closest = p;
        }
        return closest;
    }

    public Optional<class_2338> getNearestBlock(class_2248 block, class_243 fromPos) {
        return this.getNearestBlock(block, (class_2338 pos) -> true, fromPos);
    }

    public Optional<class_2338> getNearestBlock(class_2248 block, Predicate<class_2338> isValidTest, class_243 fromPos) {
        class_2338 pos = null;
        double nearest = Double.POSITIVE_INFINITY;
        if (!this.trackedBlocks.containsKey(block)) {
            return Optional.empty();
        }
        for (class_2338 p : this.trackedBlocks.get(block)) {
            double dist;
            if (!this.mod.getWorld().method_8320(p).method_26204().equals(block) || !isValidTest.test(p) || this.isUnreachable(p) || !((dist = BaritoneHelper.calculateGenericHeuristic(fromPos, WorldHelper.toVec3d(p))) < nearest)) continue;
            nearest = dist;
            pos = p;
        }
        return pos != null ? Optional.of(pos) : Optional.empty();
    }

    public boolean anyFoundWithinDistance(double distance, class_2248 ... blocks) {
        return this.anyFoundWithinDistance(this.mod.getPlayer().method_19538().method_1031(0.0, (double)0.6f, 0.0), distance, blocks);
    }

    public boolean anyFoundWithinDistance(class_243 pos, double distance, class_2248 ... blocks) {
        Optional<class_2338> blockPos = this.getNearestBlock(blocks);
        return blockPos.map(value -> value.method_19771(new class_2382((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350), distance)).orElse(false);
    }

    public double distanceToClosest(class_2248 ... blocks) {
        return this.distanceToClosest(this.mod.getPlayer().method_19538().method_1031(0.0, (double)0.6f, 0.0), blocks);
    }

    public double distanceToClosest(class_243 pos, class_2248 ... blocks) {
        Optional<class_2338> blockPos = this.getNearestBlock(blocks);
        return blockPos.map(value -> Math.sqrt(BlockPosVer.getSquaredDistance(value, (class_2374)pos))).orElse(Double.POSITIVE_INFINITY);
    }

    public boolean isBlockAtPosition(class_2338 pos, class_2248 ... blocks) {
        if (this.isUnreachable(pos)) {
            return false;
        }
        if (!this.mod.getChunkTracker().isChunkLoaded(pos)) {
            return false;
        }
        class_3218 world = this.mod.getWorld();
        if (world == null) {
            return false;
        }
        try {
            for (class_2248 block : blocks) {
                if (world.method_22347(pos) && WorldHelper.isAir(block)) {
                    return true;
                }
                class_2680 state = world.method_8320(pos);
                if (state.method_26204() != block) continue;
                return true;
            }
            return false;
        }
        catch (NullPointerException var9) {
            return false;
        }
    }

    public void reset() {
        this.trackedBlocks.clear();
        this.scannedBlocks.clear();
        this.scannedChunks.clear();
        this.rescanTimer.forceElapse();
        this.blacklist.clear();
        this.forceStop = true;
    }

    public void tick() {
        if (this.mod.getWorld() != null && this.mod.getPlayer() != null) {
            this.scanCloseBlocks();
            if (this.rescanTimer.elapsed() && !this.scanning) {
                if (this.scanDimension == WorldHelper.getCurrentDimension(this.mod) && this.mod.getWorld() == this.scanWorld) {
                    this.cachedScannedBlocks = new HashMap(this.scannedBlocks.size());
                    for (Map.Entry<class_2248, HashSet<class_2338>> entry : this.scannedBlocks.entrySet()) {
                        this.cachedScannedBlocks.put(entry.getKey(), (HashSet)entry.getValue().clone());
                    }
                    this.scanning = true;
                    this.forceStop = false;
                    new Thread(() -> {
                        try {
                            this.rescan(Integer.MAX_VALUE, Integer.MAX_VALUE);
                        }
                        catch (Exception var5) {
                            var5.printStackTrace();
                        }
                        finally {
                            this.rescanTimer.reset();
                            this.scanning = false;
                        }
                    }).start();
                } else {
                    this.reset();
                    this.scanWorld = this.mod.getWorld();
                    this.scanDimension = WorldHelper.getCurrentDimension(this.mod);
                }
            }
        }
    }

    private void scanCloseBlocks() {
        for (Map.Entry<class_2248, HashSet<class_2338>> entry : this.cachedScannedBlocks.entrySet()) {
            if (!this.trackedBlocks.containsKey(entry.getKey())) {
                this.trackedBlocks.put(entry.getKey(), new HashSet());
            }
            this.trackedBlocks.get(entry.getKey()).clear();
            this.trackedBlocks.get(entry.getKey()).addAll((Collection<class_2338>)entry.getValue());
        }
        HashMap map = new HashMap();
        class_2338 pos = this.mod.getPlayer().method_24515();
        class_1937 world = this.mod.getPlayer().method_37908();
        for (int x = pos.method_10263() - 8; x <= pos.method_10263() + 8; ++x) {
            for (int y = pos.method_10264() - 8; y < pos.method_10264() + 8; ++y) {
                for (int z = pos.method_10260() - 8; z <= pos.method_10260() + 8; ++z) {
                    class_2338 p = new class_2338(x, y, z);
                    class_2680 state = world.method_8320(p);
                    if (world.method_8320(p).method_26215()) continue;
                    class_2248 block = state.method_26204();
                    if (map.containsKey(block)) {
                        ((HashSet)map.get(block)).add(p);
                        continue;
                    }
                    HashSet<class_2338> set = new HashSet<class_2338>();
                    set.add(p);
                    map.put(block, set);
                }
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            this.getFirstFewPositions((HashSet)entry.getValue(), this.mod.getPlayer().method_19538());
            if (!this.trackedBlocks.containsKey(entry.getKey())) {
                this.trackedBlocks.put((class_2248)entry.getKey(), new HashSet());
            }
            this.trackedBlocks.get(entry.getKey()).addAll((Collection)entry.getValue());
        }
    }

    private void rescan(int maxCount, int cutOffRadius) {
        long ms = System.currentTimeMillis();
        class_1923 playerChunkPos = this.mod.getPlayer().method_31476();
        class_243 playerPos = this.mod.getPlayer().method_19538();
        HashSet<class_1923> visited = new HashSet<class_1923>();
        ArrayDeque<Node> queue = new ArrayDeque<Node>();
        queue.add(new Node(playerChunkPos, 0));
        while (!queue.isEmpty() && visited.size() < maxCount && !this.forceStop) {
            boolean isPriorityChunk;
            Node node = (Node)queue.poll();
            if (node.distance > cutOffRadius || visited.contains(node.pos) || !this.mod.getWorld().method_14178().method_12123(node.pos.field_9181, node.pos.field_9180)) continue;
            boolean bl = isPriorityChunk = this.getChunkDist(node.pos, playerChunkPos) <= 2;
            if (!isPriorityChunk && this.scannedChunks.containsKey(node.pos) && this.mod.getWorld().method_8510() - this.scannedChunks.get(node.pos) < 80L) continue;
            visited.add(node.pos);
            this.scanChunk(node.pos, playerChunkPos);
            queue.add(new Node(new class_1923(node.pos.field_9181 + 1, node.pos.field_9180 + 1), node.distance + 1));
            queue.add(new Node(new class_1923(node.pos.field_9181 - 1, node.pos.field_9180 + 1), node.distance + 1));
            queue.add(new Node(new class_1923(node.pos.field_9181 - 1, node.pos.field_9180 - 1), node.distance + 1));
            queue.add(new Node(new class_1923(node.pos.field_9181 + 1, node.pos.field_9180 - 1), node.distance + 1));
        }
        if (this.forceStop) {
            this.reset();
            this.forceStop = false;
        } else {
            Iterator<class_1923> iterator = this.scannedChunks.keySet().iterator();
            while (iterator.hasNext()) {
                class_1923 pos = iterator.next();
                int distance = this.getChunkDist(pos, playerChunkPos);
                if (distance <= cutOffRadius) continue;
                iterator.remove();
            }
            for (HashSet<class_2338> set : this.scannedBlocks.values()) {
                if (set.size() < 40) continue;
                this.getFirstFewPositions(set, playerPos);
            }
        }
    }

    private int getChunkDist(class_1923 pos1, class_1923 pos2) {
        return Math.abs(pos1.field_9181 - pos2.field_9181) + Math.abs(pos1.field_9180 - pos2.field_9180);
    }

    private void getFirstFewPositions(HashSet<class_2338> set, class_243 playerPos) {
        PriorityQueue<class_2338> queue = new PriorityQueue<class_2338>(Comparator.comparingDouble(posx -> -BaritoneHelper.calculateGenericHeuristic(playerPos, WorldHelper.toVec3d(posx))));
        for (class_2338 pos : set) {
            queue.add(pos);
            if (queue.size() <= 40) continue;
            queue.poll();
        }
        set.clear();
        for (int i = 0; i < 40 && !queue.isEmpty(); ++i) {
            set.add((class_2338)queue.poll());
        }
    }

    private void scanChunk(class_1923 chunkPos, class_1923 playerChunkPos) {
        class_3218 world = this.mod.getWorld();
        class_2818 chunk = this.mod.getWorld().method_8497(chunkPos.field_9181, chunkPos.field_9180);
        this.scannedChunks.put(chunkPos, world.method_8510());
        boolean isPriorityChunk = this.getChunkDist(chunkPos, playerChunkPos) <= 2;
        for (int x = chunkPos.method_8326(); x <= chunkPos.method_8327(); ++x) {
            for (int y = world.method_31607(); y < world.method_31600(); ++y) {
                for (int z = chunkPos.method_8328(); z <= chunkPos.method_8329(); ++z) {
                    HashSet<Object> set;
                    class_2680 state;
                    class_2338 p = new class_2338(x, y, z);
                    if (this.isUnreachable(p) || world.method_31606(p) || (state = chunk.method_8320(p)).method_26215()) continue;
                    class_2248 block = state.method_26204();
                    if (this.scannedBlocks.containsKey(block)) {
                        set = this.scannedBlocks.get(block);
                        if (set.size() > 30000 && !isPriorityChunk) continue;
                        set.add(p);
                        continue;
                    }
                    set = new HashSet<class_2338>();
                    set.add(p);
                    this.scannedBlocks.put(block, set);
                }
            }
        }
    }

    private record Node(class_1923 pos, int distance) {
    }
}

