/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.commands.base;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.commands.base.ArgBase;
import com.player2.playerengine.commands.base.ArgParser;
import com.player2.playerengine.commands.base.CommandException;
import com.player2.playerengine.util.Debug;

public abstract class Command {
    private final ArgParser parser;
    private final String name;
    private final String description;
    private PlayerEngineController mod;
    private Runnable onFinish = null;

    public Command(String name, String description, ArgBase ... args) {
        this.name = name;
        this.description = description;
        this.parser = new ArgParser(args);
    }

    public void run(PlayerEngineController mod, String line, Runnable onFinish) throws CommandException {
        this.onFinish = onFinish;
        this.mod = mod;
        this.parser.loadArgs(line, true);
        this.call(mod, this.parser);
    }

    protected void finish() {
        if (this.onFinish != null) {
            this.onFinish.run();
        }
    }

    public String getHelpRepresentation() {
        StringBuilder sb = new StringBuilder(this.name);
        for (ArgBase arg : this.parser.getArgs()) {
            sb.append(" ");
            sb.append(arg.getHelpRepresentation());
        }
        return sb.toString();
    }

    protected void log(Object message) {
        Debug.logMessage(message.toString());
    }

    protected void logError(Object message) {
        Debug.logError(message.toString());
    }

    protected abstract void call(PlayerEngineController var1, ArgParser var2) throws CommandException;

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }
}

