/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.control;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.slots.PlayerSlot;
import com.player2.playerengine.util.slots.Slot;
import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1713;
import net.minecraft.class_1738;
import net.minecraft.class_1755;
import net.minecraft.class_1758;
import net.minecraft.class_1773;
import net.minecraft.class_1777;
import net.minecraft.class_1781;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1826;
import net.minecraft.class_1831;
import net.minecraft.class_2371;

public class SlotHandler {
    private final PlayerEngineController controller;
    private class_1799 cursorStack = class_1799.field_8037;

    public SlotHandler(PlayerEngineController controller) {
        this.controller = controller;
    }

    public class_1799 getCursorStack() {
        return this.cursorStack;
    }

    public void setCursorStack(class_1799 stack) {
        this.cursorStack = stack != null && !stack.method_7960() ? stack : class_1799.field_8037;
    }

    public boolean canDoSlotAction() {
        return true;
    }

    public void registerSlotAction() {
        this.controller.getItemStorage().registerSlotAction();
    }

    public void clickSlot(Slot slot, int mouseButton, class_1713 type) {
        if (slot != null && !slot.equals(Slot.UNDEFINED)) {
            class_2371<class_1799> inventory = slot.getInventory();
            int index = slot.getIndex();
            if (inventory == null) {
                Debug.logWarning("Attempt to click a slot without an inventory: " + String.valueOf(slot));
            } else {
                class_1799 slotStack = (class_1799)inventory.get(index);
                switch (type) {
                    case field_7790: {
                        class_1799 temp = this.cursorStack;
                        this.setCursorStack(slotStack);
                        inventory.set(index, (Object)temp);
                        break;
                    }
                    case field_7794: {
                        Debug.logError("QUICK_MOVE is NYI.");
                        break;
                    }
                    default: {
                        Debug.logWarning("Unsupported SlotActionType: " + String.valueOf(type));
                    }
                }
                this.registerSlotAction();
            }
        } else if (!this.cursorStack.method_7960()) {
            this.controller.getEntity().method_5775(this.cursorStack.method_7972());
            this.setCursorStack(class_1799.field_8037);
            this.registerSlotAction();
        }
    }

    public void forceEquipItemToOffhand(class_1792 toEquip) {
        class_1309 entity = this.controller.getEntity();
        class_1799 offhand = entity.method_6118(class_1304.field_6171);
        LivingEntityInventory inv = ((IInventoryProvider)this.controller.getEntity()).getLivingInventory();
        for (int i = 0; i < inv.main.size(); ++i) {
            class_1799 potential = (class_1799)inv.main.get(i);
            if (potential.method_7960() || !potential.method_31574(toEquip)) continue;
            inv.main.set(i, (Object)offhand);
            entity.method_5673(class_1304.field_6171, potential);
            this.registerSlotAction();
            return;
        }
    }

    public boolean forceEquipItem(class_1792[] toEquip) {
        int finalI;
        LivingEntityInventory inventory = ((IInventoryProvider)this.controller.getEntity()).getLivingInventory();
        if (Arrays.stream(toEquip).allMatch(ix -> ix == inventory.getMainHandStack().method_7909())) {
            return true;
        }
        int i = 0;
        while (i < 9) {
            finalI = i++;
            if (!Arrays.stream(toEquip).allMatch(it -> it == inventory.method_5438(finalI).method_7909())) continue;
            inventory.selectedSlot = i;
            this.registerSlotAction();
            return true;
        }
        int ix2 = 9;
        while (ix2 < inventory.main.size()) {
            finalI = ix2++;
            if (!Arrays.stream(toEquip).allMatch(it -> it == inventory.method_5438(finalI).method_7909())) continue;
            class_1799 handStack = inventory.getMainHandStack();
            inventory.method_5447(inventory.selectedSlot, inventory.method_5438(ix2));
            inventory.method_5447(ix2, handStack);
            this.registerSlotAction();
            return true;
        }
        return false;
    }

    public boolean forceEquipItem(class_1792 toEquip) {
        LivingEntityInventory inventory = ((IInventoryProvider)this.controller.getEntity()).getLivingInventory();
        if (inventory.getMainHandStack().method_31574(toEquip)) {
            return true;
        }
        for (int i = 0; i < 9; ++i) {
            if (!inventory.method_5438(i).method_31574(toEquip)) continue;
            inventory.selectedSlot = i;
            this.registerSlotAction();
            return true;
        }
        for (int ix = 9; ix < inventory.main.size(); ++ix) {
            if (!inventory.method_5438(ix).method_31574(toEquip)) continue;
            class_1799 handStack = inventory.getMainHandStack();
            inventory.method_5447(inventory.selectedSlot, inventory.method_5438(ix));
            inventory.method_5447(ix, handStack);
            this.registerSlotAction();
            return true;
        }
        return false;
    }

    public boolean forceDeequip(Predicate<class_1799> isBad) {
        LivingEntityInventory inventory = ((IInventoryProvider)this.controller.getEntity()).getLivingInventory();
        class_1799 equip = inventory.getMainHandStack();
        if (isBad.test(equip)) {
            int emptySlot = inventory.getEmptySlot();
            if (emptySlot != -1) {
                if (LivingEntityInventory.isValidHotbarIndex(emptySlot)) {
                    inventory.selectedSlot = emptySlot;
                } else {
                    inventory.method_5447(emptySlot, equip);
                    inventory.method_5447(inventory.selectedSlot, class_1799.field_8037);
                }
                this.registerSlotAction();
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean forceDeequipHitTool() {
        return this.forceDeequip(stack -> stack.method_7909() instanceof class_1831);
    }

    public boolean forceEquipItem(ItemTarget toEquip, boolean unInterruptable) {
        if (toEquip != null && !toEquip.isEmpty()) {
            if (this.controller.getFoodChain().needsToEat() && !unInterruptable) {
                return false;
            }
            for (class_1792 item : toEquip.getMatches()) {
                if (!this.forceEquipItem(item)) continue;
                return true;
            }
            return false;
        }
        return this.forceDeequip(stack -> !stack.method_7960());
    }

    public void refreshInventory() {
    }

    public void forceDeequipRightClickableItem() {
        this.forceDeequip(stack -> {
            class_1792 item = stack.method_7909();
            return item instanceof class_1755 || item instanceof class_1777 || item == class_1802.field_8102 || item == class_1802.field_8399 || item == class_1802.field_8884 || item == class_1802.field_8814 || item == class_1802.field_8634 || item instanceof class_1781 || item instanceof class_1826 || item == class_1802.field_8301 || item == class_1802.field_8287 || item instanceof class_1812 || item == class_1802.field_8547 || item == class_1802.field_8674 || item == class_1802.field_8360 || item instanceof class_1787 || item instanceof class_1758 || item == class_1802.field_8251 || item instanceof class_1773 || item instanceof class_1738 || item == class_1802.field_8719 || item == class_1802.field_8255;
        });
    }

    private void swapSlots(Slot slot, Slot target) {
        class_1799 stack = slot.getStack();
        class_1799 targetStack = target.getStack();
        target.getInventory().set(target.getIndex(), (Object)stack);
        slot.getInventory().set(slot.getIndex(), (Object)targetStack);
    }

    public void forceEquipSlot(PlayerEngineController controller, Slot slot) {
        Slot target = PlayerSlot.getEquipSlot(controller.getInventory());
        this.swapSlots(slot, target);
    }

    public void forceEquipArmor(PlayerEngineController controller, ItemTarget target) {
        LivingEntityInventory inventory = ((IInventoryProvider)controller.getEntity()).getLivingInventory();
        block0: for (class_1792 item : target.getMatches()) {
            if (!(item instanceof class_1738)) continue;
            class_1738 armorItem = (class_1738)item;
            class_1304 slotType = armorItem.method_48398().method_48399();
            if (controller.getEntity().method_6118(slotType).method_31574(item)) continue;
            for (int i = 0; i < inventory.method_5439(); ++i) {
                class_1799 stackInSlot = inventory.method_5438(i);
                if (!stackInSlot.method_31574(item)) continue;
                class_1799 currentlyEquipped = controller.getEntity().method_6118(slotType).method_7972();
                controller.getEntity().method_5673(slotType, stackInSlot.method_7972());
                inventory.method_5447(i, currentlyEquipped);
                this.registerSlotAction();
                continue block0;
            }
        }
    }
}

