/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks;

import com.player2.playerengine.BotBehaviour;
import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.multiversion.blockpos.BlockPosVer;
import com.player2.playerengine.tasks.base.ITaskCanForce;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.container.PickupFromContainerTask;
import com.player2.playerengine.tasks.movement.DefaultGoToDimensionTask;
import com.player2.playerengine.tasks.movement.PickupDroppedItemTask;
import com.player2.playerengine.tasks.resources.MineAndCollectTask;
import com.player2.playerengine.trackers.storage.ContainerCache;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.helpers.StlHelper;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import org.apache.commons.lang3.ArrayUtils;

public abstract class ResourceTask
extends Task
implements ITaskCanForce {
    protected final ItemTarget[] itemTargets;
    private final PickupDroppedItemTask pickupTask;
    private class_2248[] mineIfPresent = null;
    private class_2338 mineLastClosest = null;
    private boolean forceDimension = false;
    private Dimension targetDimension;
    private ContainerCache currentContainer;
    protected boolean allowContainers = false;

    public ResourceTask(ItemTarget ... itemTargets) {
        this.itemTargets = itemTargets;
        this.pickupTask = new PickupDroppedItemTask(this.itemTargets, true);
    }

    public ResourceTask(class_1792 item, int targetCount) {
        this(new ItemTarget(item, targetCount));
    }

    @Override
    public boolean isFinished() {
        return StorageHelper.itemTargetsMet(this.controller, this.itemTargets);
    }

    @Override
    public boolean shouldForce(Task interruptingCandidate) {
        if (StorageHelper.itemTargetsMet(this.controller, this.itemTargets) && !this.isFinished()) {
            class_1799 cursorStack = this.controller.getSlotHandler().getCursorStack();
            return Arrays.stream(this.itemTargets).anyMatch(target -> target.matches(cursorStack.method_7909()));
        }
        return false;
    }

    @Override
    protected void onStart() {
        BotBehaviour botBehaviour = this.controller.getBehaviour();
        botBehaviour.push();
        botBehaviour.addProtectedItems(ItemTarget.getMatches(this.itemTargets));
        this.onResourceStart(this.controller);
    }

    @Override
    protected Task onTick() {
        Optional<class_2338> closest;
        List<ContainerCache> containersWithItem;
        PlayerEngineController mod = this.controller;
        if (this.isFinished()) {
            return null;
        }
        if (!this.shouldAvoidPickingUp(mod) && mod.getEntityTracker().itemDropped(this.itemTargets)) {
            if (PickupDroppedItemTask.isIsGettingPickaxeFirst(mod)) {
                if (this.pickupTask.isCollectingPickaxeForThis()) {
                    this.setDebugState("Picking up (pickaxe first!)");
                    return this.pickupTask;
                }
                Optional<class_1542> closest2 = mod.getEntityTracker().getClosestItemDrop(mod.getPlayer().method_19538(), this.itemTargets);
                if (closest2.isPresent() && !closest2.get().method_24516((class_1297)mod.getPlayer(), 10.0)) {
                    return this.onResourceTick(mod);
                }
            }
            double range = this.getPickupRange(mod);
            Optional<class_1542> closest3 = mod.getEntityTracker().getClosestItemDrop(mod.getPlayer().method_19538(), this.itemTargets);
            if (range < 0.0 || closest3.isPresent() && closest3.get().method_24516((class_1297)mod.getPlayer(), range) || this.pickupTask.isActive() && !this.pickupTask.isFinished()) {
                this.setDebugState("Picking up");
                return this.pickupTask;
            }
        }
        if (this.currentContainer == null && this.allowContainers && !(containersWithItem = mod.getItemStorage().getContainersWithItem(Arrays.stream(this.itemTargets).reduce(new class_1792[0], (items, target) -> (class_1792[])ArrayUtils.addAll((Object[])items, (Object[])target.getMatches()), ArrayUtils::addAll))).isEmpty() && ((ContainerCache)((Object)(closest = containersWithItem.stream().min(StlHelper.compareValues(container -> BlockPosVer.getSquaredDistance(container.getBlockPos(), (class_2374)mod.getPlayer().method_19538()))).get()))).getBlockPos().method_19771(new class_2382((int)mod.getPlayer().method_19538().field_1352, (int)mod.getPlayer().method_19538().field_1351, (int)mod.getPlayer().method_19538().field_1350), (double)mod.getModSettings().getResourceChestLocateRange())) {
            this.currentContainer = closest;
        }
        if (this.currentContainer != null) {
            Optional<ContainerCache> container2 = mod.getItemStorage().getContainerAtPosition(this.currentContainer.getBlockPos());
            if (container2.isPresent()) {
                if (!Arrays.stream(this.itemTargets).noneMatch(target -> ((ContainerCache)container2.get()).hasItem(target.getMatches()))) {
                    this.setDebugState("Picking up from container");
                    return new PickupFromContainerTask(this.currentContainer.getBlockPos(), this.itemTargets);
                }
                this.currentContainer = null;
            } else {
                this.currentContainer = null;
            }
        }
        if (this.mineIfPresent != null) {
            ArrayList<class_2248> satisfiedReqs = new ArrayList<class_2248>(Arrays.asList(this.mineIfPresent));
            satisfiedReqs.removeIf(block -> !StorageHelper.miningRequirementMet(mod, MiningRequirement.getMinimumRequirementForBlock(block)));
            if (!satisfiedReqs.isEmpty() && mod.getBlockScanner().anyFound((class_2248[])satisfiedReqs.toArray(class_2248[]::new))) {
                closest = mod.getBlockScanner().getNearestBlock(this.mineIfPresent);
                if (closest.isPresent() && ((class_2338)closest.get()).method_19771(new class_2382((int)mod.getPlayer().method_19538().field_1352, (int)mod.getPlayer().method_19538().field_1351, (int)mod.getPlayer().method_19538().field_1350), (double)mod.getModSettings().getResourceMineRange())) {
                    this.mineLastClosest = (class_2338)closest.get();
                }
                if (this.mineLastClosest != null && this.mineLastClosest.method_19771(new class_2382((int)mod.getPlayer().method_19538().field_1352, (int)mod.getPlayer().method_19538().field_1351, (int)mod.getPlayer().method_19538().field_1350), (double)mod.getModSettings().getResourceMineRange() * 1.5 + 20.0)) {
                    return new MineAndCollectTask(this.itemTargets, this.mineIfPresent, MiningRequirement.HAND);
                }
            }
        }
        if (this.isInWrongDimension(this.controller)) {
            this.setDebugState("Traveling to correct dimension");
            return this.getToCorrectDimensionTask(this.controller);
        }
        return this.onResourceTick(this.controller);
    }

    private boolean isPickupTaskValid(PlayerEngineController controller) {
        double range = this.getPickupRange(controller);
        return range < 0.0 ? true : controller.getEntityTracker().getClosestItemDrop(controller.getEntity().method_19538(), this.itemTargets).map(itemEntity -> itemEntity.method_24516((class_1297)controller.getEntity(), range) || this.pickupTask.isActive() && !this.pickupTask.isFinished()).orElse(false);
    }

    protected double getPickupRange(PlayerEngineController controller) {
        return controller.getModSettings().getResourcePickupRange();
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBehaviour().pop();
        this.onResourceStop(this.controller, interruptTask);
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (!(other instanceof ResourceTask)) {
            bl = false;
        } else {
            ResourceTask task = (ResourceTask)other;
            bl = Arrays.equals(task.itemTargets, this.itemTargets) && this.isEqualResource(task);
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return this.toDebugStringName() + ": " + Arrays.toString(this.itemTargets);
    }

    protected boolean isInWrongDimension(PlayerEngineController controller) {
        return this.forceDimension ? WorldHelper.getCurrentDimension(controller) != this.targetDimension : false;
    }

    protected Task getToCorrectDimensionTask(PlayerEngineController controller) {
        return new DefaultGoToDimensionTask(this.targetDimension);
    }

    public ResourceTask forceDimension(Dimension dimension) {
        this.forceDimension = true;
        this.targetDimension = dimension;
        return this;
    }

    public ItemTarget[] getItemTargets() {
        return this.itemTargets;
    }

    public ResourceTask mineIfPresent(class_2248[] toMine) {
        this.mineIfPresent = toMine;
        return this;
    }

    protected abstract boolean shouldAvoidPickingUp(PlayerEngineController var1);

    protected abstract void onResourceStart(PlayerEngineController var1);

    protected abstract Task onResourceTick(PlayerEngineController var1);

    protected abstract void onResourceStop(PlayerEngineController var1, Task var2);

    protected abstract boolean isEqualResource(ResourceTask var1);

    protected abstract String toDebugStringName();
}

