/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.construction.compound;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.DestroyBlockTask;
import com.player2.playerengine.tasks.construction.PlaceBlockTask;
import com.player2.playerengine.tasks.squashed.CataloguedResourceTask;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1439;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;

public class ConstructIronGolemTask
extends Task {
    private class_2338 position;
    private boolean canBeFinished = false;

    public ConstructIronGolemTask() {
    }

    public ConstructIronGolemTask(class_2338 pos) {
        this.position = pos;
    }

    @Override
    protected void onStart() {
        this.controller.getBehaviour().push();
        this.controller.getBehaviour().addProtectedItems(class_1802.field_8773, class_1802.field_17519);
        this.controller.getBaritoneSettings().blocksToAvoidBreaking.get().add(class_2246.field_10085);
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        if (!StorageHelper.itemTargetsMetInventory(mod, this.golemMaterials(mod))) {
            this.setDebugState("Getting materials for the iron golem");
            return new CataloguedResourceTask(this.golemMaterials(mod));
        }
        if (this.position == null) {
            for (class_2338 pos : WorldHelper.scanRegion(new class_2338(mod.getPlayer().method_31477(), 64, mod.getPlayer().method_31479()), new class_2338(mod.getPlayer().method_31477(), 128, mod.getPlayer().method_31479()))) {
                if (mod.getWorld().method_8320(pos).method_26204() != class_2246.field_10124) continue;
                this.position = pos;
                break;
            }
            if (this.position == null) {
                this.position = mod.getPlayer().method_24515();
            }
        }
        if (!WorldHelper.isBlock(this.controller, this.position, class_2246.field_10085)) {
            if (!WorldHelper.isBlock(this.controller, this.position, class_2246.field_10124)) {
                this.setDebugState("Destroying block in way of base iron block");
                return new DestroyBlockTask(this.position);
            }
            this.setDebugState("Placing the base iron block");
            return new PlaceBlockTask(this.position, class_2246.field_10085);
        }
        if (!WorldHelper.isBlock(this.controller, this.position.method_10084(), class_2246.field_10085)) {
            if (!WorldHelper.isBlock(this.controller, this.position.method_10084(), class_2246.field_10124)) {
                this.setDebugState("Destroying block in way of center iron block");
                return new DestroyBlockTask(this.position.method_10084());
            }
            this.setDebugState("Placing the center iron block");
            return new PlaceBlockTask(this.position.method_10084(), class_2246.field_10085);
        }
        if (!WorldHelper.isBlock(this.controller, this.position.method_10084().method_10078(), class_2246.field_10085)) {
            if (!WorldHelper.isBlock(this.controller, this.position.method_10084().method_10078(), class_2246.field_10124)) {
                this.setDebugState("Destroying block in way of east iron block");
                return new DestroyBlockTask(this.position.method_10084().method_10078());
            }
            this.setDebugState("Placing the east iron block");
            return new PlaceBlockTask(this.position.method_10084().method_10078(), class_2246.field_10085);
        }
        if (!WorldHelper.isBlock(this.controller, this.position.method_10084().method_10067(), class_2246.field_10085)) {
            if (!WorldHelper.isBlock(this.controller, this.position.method_10084().method_10067(), class_2246.field_10124)) {
                this.setDebugState("Destroying block in way of west iron block");
                return new DestroyBlockTask(this.position.method_10084().method_10067());
            }
            this.setDebugState("Placing the west iron block");
            return new PlaceBlockTask(this.position.method_10084().method_10067(), class_2246.field_10085);
        }
        if (!WorldHelper.isBlock(this.controller, this.position.method_10078(), class_2246.field_10124)) {
            this.setDebugState("Clearing area on east side...");
            return new DestroyBlockTask(this.position.method_10078());
        }
        if (!WorldHelper.isBlock(this.controller, this.position.method_10067(), class_2246.field_10124)) {
            this.setDebugState("Clearing area on west side...");
            return new DestroyBlockTask(this.position.method_10067());
        }
        if (!WorldHelper.isBlock(this.controller, this.position.method_10086(2), class_2246.field_10124)) {
            this.setDebugState("Destroying block in way of pumpkin");
            return new DestroyBlockTask(this.position.method_10086(2));
        }
        this.canBeFinished = true;
        this.setDebugState("Placing the pumpkin (I think)");
        return new PlaceBlockTask(this.position.method_10086(2), class_2246.field_10147);
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBaritoneSettings().blocksToAvoidBreaking.get().remove(class_2246.field_10085);
        this.controller.getBehaviour().pop();
    }

    @Override
    protected boolean isEqual(Task other) {
        return other instanceof ConstructIronGolemTask;
    }

    @Override
    public boolean isFinished() {
        if (this.position == null) {
            return false;
        }
        Optional<class_1297> closestIronGolem = this.controller.getEntityTracker().getClosestEntity(new class_243((double)this.position.method_10263(), (double)this.position.method_10264(), (double)this.position.method_10260()), class_1439.class);
        return closestIronGolem.isPresent() && closestIronGolem.get().method_24515().method_19771((class_2382)this.position, 2.0) && this.canBeFinished;
    }

    @Override
    protected String toDebugString() {
        return "Construct Iron Golem";
    }

    private int ironBlocksNeeded(PlayerEngineController mod) {
        if (this.position == null) {
            return 4;
        }
        int needed = 0;
        if (mod.getWorld().method_8320(this.position).method_26204() != class_2246.field_10085) {
            ++needed;
        }
        if (mod.getWorld().method_8320(this.position.method_10084().method_10067()).method_26204() != class_2246.field_10085) {
            ++needed;
        }
        if (mod.getWorld().method_8320(this.position.method_10084().method_10078()).method_26204() != class_2246.field_10085) {
            ++needed;
        }
        if (mod.getWorld().method_8320(this.position.method_10084()).method_26204() != class_2246.field_10085) {
            ++needed;
        }
        return needed;
    }

    private ItemTarget[] golemMaterials(PlayerEngineController mod) {
        ItemTarget[] itemTargetArray;
        if (this.position != null && mod.getWorld().method_8320(this.position.method_10086(2)).method_26204() == class_2246.field_10147) {
            ItemTarget[] itemTargetArray2 = new ItemTarget[1];
            itemTargetArray = itemTargetArray2;
            itemTargetArray2[0] = new ItemTarget(class_1802.field_8773, this.ironBlocksNeeded(mod));
        } else {
            ItemTarget[] itemTargetArray3 = new ItemTarget[2];
            itemTargetArray3[0] = new ItemTarget(class_1802.field_8773, this.ironBlocksNeeded(mod));
            itemTargetArray = itemTargetArray3;
            itemTargetArray3[1] = new ItemTarget(class_1802.field_17519, 1);
        }
        return itemTargetArray;
    }
}

