/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.construction.compound;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.tasks.InteractWithBlockTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.DestroyBlockTask;
import com.player2.playerengine.tasks.construction.PlaceBlockTask;
import com.player2.playerengine.tasks.construction.PlaceStructureBlockTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.LinkedList;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class ConstructNetherPortalObsidianTask
extends Task {
    private static final class_2382[] PORTAL_FRAME = new class_2382[]{new class_2382(0, 0, -1), new class_2382(0, 1, -1), new class_2382(0, 2, -1), new class_2382(0, 0, 2), new class_2382(0, 1, 2), new class_2382(0, 2, 2), new class_2382(0, 3, 0), new class_2382(0, 3, 1), new class_2382(0, -1, 0), new class_2382(0, -1, 1)};
    private static final class_2382[] PORTAL_INTERIOR = new class_2382[]{new class_2382(0, 0, 0), new class_2382(0, 1, 0), new class_2382(0, 2, 0), new class_2382(0, 0, 1), new class_2382(0, 1, 1), new class_2382(0, 2, 1), new class_2382(1, 0, 0), new class_2382(1, 1, 0), new class_2382(1, 2, 0), new class_2382(1, 0, 1), new class_2382(1, 1, 1), new class_2382(1, 2, 1), new class_2382(-1, 0, 0), new class_2382(-1, 1, 0), new class_2382(-1, 2, 0), new class_2382(-1, 0, 1), new class_2382(-1, 1, 1), new class_2382(-1, 2, 1)};
    private static final class_2382 PORTALABLE_REGION_SIZE = new class_2382(3, 6, 6);
    private final TimerGame areaSearchTimer = new TimerGame(5.0);
    private class_2338 origin;
    private class_2338 destroyTarget;

    private class_2338 getBuildableAreaNearby(PlayerEngineController mod) {
        class_2338 checkOrigin = mod.getPlayer().method_24515();
        for (class_2338 toCheck : WorldHelper.scanRegion(checkOrigin, checkOrigin.method_10081(PORTALABLE_REGION_SIZE))) {
            boolean validToWorld;
            if (this.controller.getWorld() == null) {
                return null;
            }
            class_2680 state = this.controller.getWorld().method_8320(toCheck);
            boolean bl = validToWorld = WorldHelper.canPlace(this.controller, toCheck) || WorldHelper.canBreak(this.controller, toCheck);
            if (validToWorld && state.method_26204() != class_2246.field_10164 && state.method_26204() != class_2246.field_10382 && state.method_26204() != class_2246.field_9987) continue;
            return null;
        }
        return checkOrigin;
    }

    @Override
    protected void onStart() {
        PlayerEngineController mod = this.controller;
        mod.getBehaviour().push();
        mod.getBehaviour().avoidBlockBreaking(block -> {
            if (this.origin != null) {
                for (class_2382 framePosRelative : PORTAL_FRAME) {
                    class_2338 framePos = this.origin.method_10081(framePosRelative);
                    if (!block.equals((Object)framePos)) continue;
                    return mod.getWorld().method_8320(framePos).method_26204() == class_2246.field_10540;
                }
            }
            return false;
        });
        mod.getBehaviour().addProtectedItems(class_1802.field_8884);
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        if (this.origin != null && mod.getWorld().method_8320(this.origin.method_10084()).method_26204() == class_2246.field_10316) {
            this.setDebugState("Done constructing nether portal.");
            mod.getBlockScanner().addBlock(class_2246.field_10316, this.origin.method_10084());
            return null;
        }
        int neededObsidian = 10;
        class_2338 placeTarget = null;
        if (this.origin != null) {
            for (class_2382 frameOffs : PORTAL_FRAME) {
                class_2338 framePos = this.origin.method_10081(frameOffs);
                if (!mod.getBlockScanner().isBlockAtPosition(framePos, class_2246.field_10540)) {
                    placeTarget = framePos;
                    break;
                }
                --neededObsidian;
            }
        }
        if (mod.getItemStorage().getItemCount(class_1802.field_8281) < neededObsidian) {
            this.setDebugState("Getting obsidian");
            return TaskCatalogue.getItemTask(class_1802.field_8281, neededObsidian);
        }
        if (this.origin == null) {
            if (this.areaSearchTimer.elapsed()) {
                this.areaSearchTimer.reset();
                Debug.logMessage("(Searching for area to build portal nearby...)");
                this.origin = this.getBuildableAreaNearby(mod);
            }
            this.setDebugState("Looking for portalable area...");
            return new TimeoutWanderTask();
        }
        if (!mod.getItemStorage().hasItem(class_1802.field_8884)) {
            this.setDebugState("Getting flint and steel");
            return TaskCatalogue.getItemTask(class_1802.field_8884, 1);
        }
        if (placeTarget == null) {
            if (this.destroyTarget != null && !WorldHelper.isAir(this.controller.getWorld().method_8320(this.destroyTarget).method_26204())) {
                return new DestroyBlockTask(this.destroyTarget);
            }
            for (class_2382 middleOffs : PORTAL_INTERIOR) {
                class_2338 middlePos = this.origin.method_10081(middleOffs);
                if (WorldHelper.isAir(this.controller.getWorld().method_8320(middlePos).method_26204())) continue;
                this.destroyTarget = middlePos;
                return new DestroyBlockTask(this.destroyTarget);
            }
            return new InteractWithBlockTask(new ItemTarget(class_1802.field_8884, 1), class_2350.field_11036, this.origin.method_10074(), true);
        }
        class_3218 clientWorld = mod.getWorld();
        if (this.surroundedByAir((class_1937)clientWorld, placeTarget)) {
            LinkedList<class_2338> queue = new LinkedList<class_2338>();
            queue.add(placeTarget);
            while (this.surroundedByAir((class_1937)clientWorld, placeTarget)) {
                class_2338 pos = (class_2338)queue.removeFirst();
                if (!this.surroundedByAir((class_1937)clientWorld, pos)) {
                    return new PlaceStructureBlockTask(pos);
                }
                queue.add(pos.method_10084());
                queue.add(pos.method_10074());
                queue.add(pos.method_10078());
                queue.add(pos.method_10067());
                queue.add(pos.method_10095());
                queue.add(pos.method_10072());
            }
            mod.logWarning("Did not find any block to place obsidian on");
        }
        if (!clientWorld.method_8320(placeTarget).method_26215() && !clientWorld.method_8320(placeTarget).method_26204().equals(class_2246.field_10540)) {
            return new DestroyBlockTask(placeTarget);
        }
        this.setDebugState("Placing frame...");
        return new PlaceBlockTask(placeTarget, class_2246.field_10540);
    }

    private boolean surroundedByAir(class_1937 world, class_2338 pos) {
        return world.method_8320(pos.method_10067()).method_26215() && world.method_8320(pos.method_10072()).method_26215() && world.method_8320(pos.method_10078()).method_26215() && world.method_8320(pos.method_10084()).method_26215() && world.method_8320(pos.method_10074()).method_26215() && world.method_8320(pos.method_10095()).method_26215();
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBehaviour().pop();
    }

    @Override
    protected boolean isEqual(Task other) {
        return other instanceof ConstructNetherPortalObsidianTask;
    }

    @Override
    protected String toDebugString() {
        return "Building nether portal with obsidian";
    }
}

