/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.container;

import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.tasks.slot.EnsureFreeInventorySlotTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2621;

public class PickupFromContainerTask
extends Task {
    private final class_2338 containerPos;
    private final ItemTarget[] targets;

    public PickupFromContainerTask(class_2338 targetContainer, ItemTarget ... targets) {
        this.containerPos = targetContainer;
        this.targets = targets;
    }

    @Override
    protected void onStart() {
    }

    @Override
    protected Task onTick() {
        if (this.isFinished()) {
            return null;
        }
        if (!this.containerPos.method_19771(new class_2382((int)this.controller.getEntity().method_19538().field_1352, (int)this.controller.getEntity().method_19538().field_1351, (int)this.controller.getEntity().method_19538().field_1350), 4.5)) {
            return new GetToBlockTask(this.containerPos);
        }
        class_2586 class_25862 = this.controller.getWorld().method_8321(this.containerPos);
        if (!(class_25862 instanceof class_2621)) {
            Debug.logWarning("Block at " + String.valueOf(this.containerPos) + " is not a lootable container. Stopping.");
            return null;
        }
        class_2621 container = (class_2621)class_25862;
        class_2621 containerInventory = container;
        LivingEntityInventory playerInventory = ((IInventoryProvider)this.controller.getEntity()).getLivingInventory();
        for (ItemTarget target : this.targets) {
            int needed = target.getTargetCount() - this.controller.getItemStorage().getItemCount(target);
            if (needed <= 0) continue;
            for (int i = 0; i < containerInventory.method_5439(); ++i) {
                class_1799 stack = containerInventory.method_5438(i);
                if (!target.matches(stack.method_7909())) continue;
                this.setDebugState("Looting " + String.valueOf(target));
                if (!playerInventory.insertStack(new class_1799((class_1935)stack.method_7909()))) {
                    return new EnsureFreeInventorySlotTask();
                }
                class_1799 toMove = stack.method_7972();
                int moveAmount = Math.min(toMove.method_7947(), needed);
                toMove.method_7939(moveAmount);
                if (playerInventory.insertStack(toMove)) {
                    stack.method_7934(moveAmount);
                    containerInventory.method_5447(i, stack);
                    container.method_5431();
                    this.controller.getItemStorage().registerSlotAction();
                }
                return null;
            }
        }
        this.setDebugState("Waiting for items to appear in container or finishing.");
        return null;
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    public boolean isFinished() {
        return Arrays.stream(this.targets).allMatch(target -> this.controller.getItemStorage().getItemCount((ItemTarget)target) >= target.getTargetCount());
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (!(other instanceof PickupFromContainerTask)) {
            bl = false;
        } else {
            PickupFromContainerTask task = (PickupFromContainerTask)other;
            bl = Objects.equals(task.containerPos, this.containerPos) && Arrays.equals(task.targets, this.targets);
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Picking up from container at (" + this.containerPos.method_23854() + "): " + Arrays.toString(this.targets);
    }
}

