/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.pathing.movement.MovementHelper;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.CustomBaritoneGoalTask;
import com.player2.playerengine.tasks.movement.SafeRandomShimmyTask;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.time.TimerGame;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2338;

public class GetOutOfWaterTask
extends CustomBaritoneGoalTask {
    private boolean startedShimmying = false;
    private final TimerGame shimmyTaskTimer = new TimerGame(5.0);

    @Override
    protected void onStart() {
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        if (mod.getPlayer().method_5669() >= mod.getPlayer().method_5748() && !mod.getPlayer().method_5869()) {
            boolean hasBlockBelow = false;
            for (int i = 0; i < 3; ++i) {
                if (mod.getWorld().method_8320(mod.getPlayer().method_23312().method_10087(i)).method_26204() == class_2246.field_10382) continue;
                hasBlockBelow = true;
            }
            boolean hasAirAbove = mod.getWorld().method_8320(mod.getPlayer().method_24515().method_10086(2)).method_26204().equals(class_2246.field_10124);
            if (hasAirAbove && hasBlockBelow && StorageHelper.getNumberOfThrowawayBlocks(mod) > 0) {
                mod.getInputControls().tryPress(Input.JUMP);
                if (mod.getPlayer().method_24828()) {
                    if (!this.startedShimmying) {
                        this.startedShimmying = true;
                        this.shimmyTaskTimer.reset();
                    }
                    return new SafeRandomShimmyTask();
                }
                mod.getSlotHandler().forceEquipItem(mod.getBaritoneSettings().acceptableThrowawayItems.get().toArray(new class_1792[0]));
                LookHelper.lookAt(mod, mod.getPlayer().method_23312().method_10074());
                mod.getInputControls().tryPress(Input.CLICK_RIGHT);
            }
            return super.onTick();
        }
        return super.onTick();
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    protected Goal newGoal(PlayerEngineController mod) {
        return new EscapeFromWaterGoal(this, mod);
    }

    @Override
    protected boolean isEqual(Task other) {
        return false;
    }

    @Override
    protected String toDebugString() {
        return "";
    }

    @Override
    public boolean isFinished() {
        return !this.controller.getPlayer().method_5799() && this.controller.getPlayer().method_24828();
    }

    private class EscapeFromWaterGoal
    implements Goal {
        private PlayerEngineController mod;

        private EscapeFromWaterGoal(GetOutOfWaterTask getOutOfWaterTask, PlayerEngineController mod) {
            this.mod = mod;
        }

        private boolean isWater(int x, int y, int z) {
            return this.mod.getWorld() == null ? false : MovementHelper.isWater(this.mod.getWorld().method_8320(new class_2338(x, y, z)));
        }

        private boolean isWaterAdjacent(int x, int y, int z) {
            return this.isWater(x + 1, y, z) || this.isWater(x - 1, y, z) || this.isWater(x, y, z + 1) || this.isWater(x, y, z - 1) || this.isWater(x + 1, y, z - 1) || this.isWater(x + 1, y, z + 1) || this.isWater(x - 1, y, z - 1) || this.isWater(x - 1, y, z + 1);
        }

        @Override
        public boolean isInGoal(int x, int y, int z) {
            return !this.isWater(x, y, z) && !this.isWaterAdjacent(x, y, z);
        }

        @Override
        public double heuristic(int x, int y, int z) {
            if (this.isWater(x, y, z)) {
                return 1.0;
            }
            return this.isWaterAdjacent(x, y, z) ? 0.5 : 0.0;
        }
    }
}

