/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.FastTravelTask;
import com.player2.playerengine.tasks.movement.LocateStrongholdCoordinatesTask;
import com.player2.playerengine.tasks.movement.PickupDroppedItemTask;
import com.player2.playerengine.util.helpers.WorldHelper;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;

public class GoToStrongholdPortalTask
extends Task {
    private LocateStrongholdCoordinatesTask locateCoordsTask;
    private final int targetEyes;
    private final int MINIMUM_EYES = 12;
    private class_2338 strongholdCoordinates;

    public GoToStrongholdPortalTask(int targetEyes) {
        this.targetEyes = targetEyes;
        this.strongholdCoordinates = null;
        this.locateCoordsTask = new LocateStrongholdCoordinatesTask(targetEyes);
    }

    @Override
    protected void onStart() {
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        if (this.strongholdCoordinates == null) {
            this.strongholdCoordinates = this.locateCoordsTask.getStrongholdCoordinates().orElse(null);
            if (this.strongholdCoordinates == null) {
                if (mod.getItemStorage().getItemCount(class_1802.field_8449) < 12 && mod.getEntityTracker().itemDropped(class_1802.field_8449)) {
                    this.setDebugState("Picking up dropped eye");
                    return new PickupDroppedItemTask(class_1802.field_8449, 12);
                }
                this.setDebugState("Triangulating stronghold...");
                return this.locateCoordsTask;
            }
        }
        if (mod.getPlayer().method_19538().method_1022(WorldHelper.toVec3d(this.strongholdCoordinates)) < 10.0 && !mod.getBlockScanner().anyFound(class_2246.field_10398)) {
            mod.log("Something went wrong whilst triangulating the stronghold... either the action got disrupted or the second eye went to a different stronghold");
            mod.log("We will try to triangulate again now...");
            this.strongholdCoordinates = null;
            this.locateCoordsTask = new LocateStrongholdCoordinatesTask(this.targetEyes);
            return null;
        }
        this.setDebugState("Searching for Stronghold...");
        return new FastTravelTask(this.strongholdCoordinates, 300, true);
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    protected boolean isEqual(Task other) {
        return other instanceof GoToStrongholdPortalTask;
    }

    @Override
    protected String toDebugString() {
        return "Locating Stronghold";
    }
}

