/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.utils.IEntityContext;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.RotationUtils;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.control.InputControls;
import com.player2.playerengine.multiversion.DamageSourceVer;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.helpers.ConfigHelper;
import com.player2.playerengine.util.helpers.EntityHelper;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.helpers.MathsHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class MLGBucketTask
extends Task {
    private static MLGClutchConfig config;
    private class_2338 placedPos;
    private class_2338 movingTorwards;

    private static boolean isLava(PlayerEngineController controller, class_2338 pos) {
        assert (controller.getWorld() != null);
        return controller.getWorld().method_8320(pos).method_26204() == class_2246.field_10164;
    }

    private static boolean lavaWillProtect(PlayerEngineController controller, class_2338 pos) {
        assert (controller.getWorld() != null);
        class_2680 state = controller.getWorld().method_8320(pos);
        if (state.method_26204() != class_2246.field_10164) {
            return false;
        }
        int level = state.method_26227().method_15761();
        return level == 0 || level >= MLGBucketTask.config.lavaLevelOrGreaterWillCancelFallDamage;
    }

    private static boolean isWater(PlayerEngineController controller, class_2338 pos) {
        assert (controller.getWorld() != null);
        return controller.getWorld().method_8320(pos).method_26204() == class_2246.field_10382;
    }

    private static boolean canTravelToInAir(PlayerEngineController controller, class_2338 pos) {
        class_1309 clientPlayerEntity = controller.getPlayer();
        assert (clientPlayerEntity != null);
        double verticalDist = clientPlayerEntity.method_19538().method_10214() - (double)pos.method_10264() - 1.0;
        double verticalVelocity = -1.0 * clientPlayerEntity.method_18798().field_1351;
        double grav = 0.08;
        double movementSpeedPerTick = MLGBucketTask.config.averageHorizontalMovementSpeedPerTick;
        double ticksToTravelSq = (-verticalVelocity + Math.sqrt(verticalVelocity * verticalVelocity + 2.0 * grav * verticalDist)) / grav;
        double maxMoveDistanceSq = movementSpeedPerTick * movementSpeedPerTick * ticksToTravelSq * ticksToTravelSq;
        double horizontalDistance = WorldHelper.distanceXZ(clientPlayerEntity.method_19538(), WorldHelper.toVec3d(pos)) - 0.8;
        if (horizontalDistance < 0.0) {
            horizontalDistance = 0.0;
        }
        return maxMoveDistanceSq > horizontalDistance * horizontalDistance;
    }

    private static boolean isFallDeadly(PlayerEngineController controller, class_2338 pos) {
        class_1309 clientPlayerEntity = controller.getPlayer();
        double damage = MLGBucketTask.calculateFallDamageToLandOn(controller, pos);
        assert (controller.getWorld() != null);
        class_2248 b = controller.getWorld().method_8320(pos).method_26204();
        if (b == class_2246.field_10359) {
            damage *= (double)0.2f;
        }
        assert (clientPlayerEntity != null);
        double resultingHealth = clientPlayerEntity.method_6032() - (float)damage;
        return resultingHealth < (double)MLGBucketTask.config.preferLavaWhenFallDropsHealthBelowThreshold;
    }

    private static double calculateFallDamageToLandOn(PlayerEngineController controller, class_2338 pos) {
        class_3218 world = controller.getWorld();
        class_1309 clientPlayerEntity = controller.getPlayer();
        assert (clientPlayerEntity != null);
        double totalFallDistance = (double)clientPlayerEntity.field_6017 + clientPlayerEntity.method_23318() - (double)pos.method_10264() - 1.0;
        double baseFallDamage = class_3532.method_15384((double)(totalFallDistance - 3.0));
        assert (world != null);
        return EntityHelper.calculateResultingPlayerDamage(clientPlayerEntity, DamageSourceVer.getFallDamageSource((class_1937)world), baseFallDamage);
    }

    private static void moveLeftRight(PlayerEngineController controller, int delta) {
        InputControls controls = controller.getInputControls();
        if (delta == 0) {
            controls.release(Input.MOVE_LEFT);
            controls.release(Input.MOVE_RIGHT);
        } else if (delta > 0) {
            controls.release(Input.MOVE_LEFT);
            controls.hold(Input.MOVE_RIGHT);
        } else {
            controls.hold(Input.MOVE_LEFT);
            controls.release(Input.MOVE_RIGHT);
        }
    }

    private static void moveForwardBack(PlayerEngineController controller, int delta) {
        InputControls controls = controller.getInputControls();
        if (delta == 0) {
            controls.release(Input.MOVE_FORWARD);
            controls.release(Input.MOVE_BACK);
        } else if (delta > 0) {
            controls.hold(Input.MOVE_FORWARD);
            controls.release(Input.MOVE_BACK);
        } else {
            controls.release(Input.MOVE_FORWARD);
            controls.hold(Input.MOVE_BACK);
        }
    }

    private Task onTickInternal(PlayerEngineController mod, class_2338 oldMovingTorwards) {
        Optional<class_2338> willLandOn = this.getBlockWeWillLandOn(mod);
        Optional<class_2338> bestClutchPos = this.getBestConeClutchBlock(mod, oldMovingTorwards);
        if (bestClutchPos.isPresent()) {
            this.movingTorwards = bestClutchPos.get().method_25503();
            if (!this.movingTorwards.equals((Object)oldMovingTorwards)) {
                if (oldMovingTorwards == null) {
                    Debug.logMessage("(NEW clutch target: " + String.valueOf(this.movingTorwards) + ")");
                } else {
                    Debug.logMessage("(changed clutch target: " + String.valueOf(this.movingTorwards) + ")");
                }
            }
        } else if (oldMovingTorwards != null) {
            Debug.logMessage("(LOST clutch position!)");
        }
        if (willLandOn.isPresent()) {
            this.handleJumpForLand(mod, willLandOn.get());
            return this.placeMLGBucketTask(mod, willLandOn.get());
        }
        this.setDebugState("Wait for it...");
        mod.getInputControls().release(Input.JUMP);
        return null;
    }

    private Task placeMLGBucketTask(PlayerEngineController mod, class_2338 toPlaceOn) {
        if (!this.hasClutchItem(mod)) {
            this.setDebugState("No clutch item");
            return null;
        }
        if (!WorldHelper.isSolidBlock(this.controller, toPlaceOn)) {
            toPlaceOn = toPlaceOn.method_10074();
        }
        class_2338 willLandIn = toPlaceOn.method_10084();
        class_2680 willLandInState = mod.getWorld().method_8320(willLandIn);
        if (willLandInState.method_26204() == class_2246.field_10382) {
            this.setDebugState("Waiting to fall into water");
            mod.getBaritone().getInputOverrideHandler().setInputForceState(Input.CLICK_RIGHT, false);
            return null;
        }
        IEntityContext ctx = mod.getBaritone().getEntityContext();
        Optional<Rotation> reachable = RotationUtils.reachableCenter((class_1297)ctx.entity(), toPlaceOn, ctx.playerController().getBlockReachDistance(), false);
        if (reachable.isPresent()) {
            boolean hasClutch;
            this.setDebugState("Performing MLG");
            LookHelper.lookAt(this.controller, reachable.get());
            boolean bl = hasClutch = !mod.getWorld().method_8597().comp_644() && mod.getSlotHandler().forceEquipItem(class_1802.field_8705);
            if (!hasClutch && !MLGBucketTask.config.clutchItems.isEmpty()) {
                for (class_1792 tryEquip : MLGBucketTask.config.clutchItems) {
                    if (!mod.getSlotHandler().forceEquipItem(tryEquip)) continue;
                    hasClutch = true;
                    break;
                }
            }
            class_2338[] toCheckLook = new class_2338[]{toPlaceOn, toPlaceOn.method_10084(), toPlaceOn.method_10086(2)};
            if (hasClutch && Arrays.stream(toCheckLook).anyMatch(check -> mod.getBaritone().getEntityContext().isLookingAt((class_2338)check))) {
                Debug.logMessage("HIT: " + String.valueOf(willLandIn));
                this.placedPos = willLandIn;
                mod.getInputControls().tryPress(Input.CLICK_RIGHT);
            } else {
                this.setDebugState("NOT LOOKING CORRECTLY!");
            }
        } else {
            this.setDebugState("Waiting to reach target block...");
        }
        return null;
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        mod.getInputControls().hold(Input.SPRINT);
        class_2338.class_2339 mutable = this.movingTorwards != null ? this.movingTorwards.method_25503() : null;
        this.movingTorwards = null;
        Task result = this.onTickInternal(mod, (class_2338)mutable);
        this.handleForwardVelocity(mod, !Objects.equals(mutable, this.movingTorwards));
        this.handleCancellingSidewaysVelocity(mod);
        return result;
    }

    private void handleForwardVelocity(PlayerEngineController mod, boolean newForwardTarget) {
        if (!mod.getPlayer().method_24828() && this.movingTorwards != null && !WorldHelper.inRangeXZ((class_1297)mod.getPlayer(), this.movingTorwards, (double)0.05f)) {
            Rotation look = LookHelper.getLookRotation(this.controller);
            look = new Rotation(look.getYaw(), 0.0f);
            class_243 forwardFacing = LookHelper.toVec3d(look).method_18805(1.0, 0.0, 1.0).method_1029();
            class_243 delta = WorldHelper.toVec3d(this.movingTorwards).method_1020(mod.getPlayer().method_19538()).method_18805(1.0, 0.0, 1.0);
            class_243 velocity = mod.getPlayer().method_18798().method_18805(1.0, 0.0, 1.0);
            class_243 pd = delta.method_1020(velocity.method_1021(3.0));
            double forwardStrength = pd.method_1026(forwardFacing);
            if (newForwardTarget) {
                LookHelper.lookAt(mod, this.movingTorwards);
            }
            Debug.logInternal("F:" + forwardStrength);
            MLGBucketTask.moveForwardBack(mod, (int)Math.signum(forwardStrength));
        } else {
            MLGBucketTask.moveForwardBack(mod, 0);
        }
    }

    @Override
    protected void onStart() {
        this.controller.getBaritone().getPathingBehavior().forceCancel();
        this.placedPos = null;
        this.controller.getPlayer().method_36457(90.0f);
    }

    private void handleJumpForLand(PlayerEngineController mod, class_2338 willLandOn) {
        class_2338 willLandIn = WorldHelper.isSolidBlock(this.controller, willLandOn) ? willLandOn.method_10084() : willLandOn;
        class_2680 s = mod.getWorld().method_8320(willLandIn);
        if (s.method_26204() == class_2246.field_10164) {
            mod.getInputControls().hold(Input.JUMP);
        } else {
            class_238 blockBounds;
            try {
                blockBounds = s.method_26220((class_1922)mod.getWorld(), willLandIn).method_1107();
            }
            catch (UnsupportedOperationException var7) {
                blockBounds = class_238.method_30048((class_243)WorldHelper.toVec3d(willLandIn), (double)1.0, (double)1.0, (double)1.0);
            }
            boolean inside = mod.getPlayer().method_5829().method_994(blockBounds);
            if (inside) {
                mod.getInputControls().hold(Input.JUMP);
            } else {
                mod.getInputControls().release(Input.JUMP);
            }
        }
    }

    private Optional<class_2338> getBlockWeWillLandOn(PlayerEngineController mod) {
        class_243 velCheck = mod.getPlayer().method_18798();
        velCheck.method_18805(10.0, 0.0, 10.0);
        class_238 b = mod.getPlayer().method_5829().method_997(velCheck);
        class_243 c = b.method_1005();
        class_243[] coords = new class_243[]{c, new class_243(b.field_1323, c.field_1351, b.field_1321), new class_243(b.field_1320, c.field_1351, b.field_1321), new class_243(b.field_1323, c.field_1351, b.field_1324), new class_243(b.field_1320, c.field_1351, b.field_1324)};
        class_3965 result = null;
        double bestSqDist = Double.POSITIVE_INFINITY;
        for (class_243 rayOrigin : coords) {
            double curDis;
            class_3959 rctx = this.castDown(rayOrigin);
            class_3965 hit = mod.getWorld().method_17742(rctx);
            if (hit.method_17783() != class_239.class_240.field_1332 || !((curDis = hit.method_17784().method_1025(rayOrigin)) < bestSqDist)) continue;
            result = hit;
            bestSqDist = curDis;
        }
        return result != null && result.method_17783() == class_239.class_240.field_1332 ? Optional.ofNullable(result.method_17777()) : Optional.empty();
    }

    private void handleCancellingSidewaysVelocity(PlayerEngineController mod) {
        if (this.movingTorwards == null) {
            MLGBucketTask.moveLeftRight(mod, 0);
        } else {
            class_243 faceRight;
            boolean moveRight;
            class_243 velocity = mod.getPlayer().method_18798();
            class_243 deltaTarget = WorldHelper.toVec3d(this.movingTorwards).method_1020(mod.getPlayer().method_19538());
            Rotation look = LookHelper.getLookRotation(this.controller);
            class_243 forwardFacing = LookHelper.toVec3d(look).method_18805(1.0, 0.0, 1.0).method_1029();
            class_243 rightVelocity = MathsHelper.projectOntoPlane(velocity, forwardFacing).method_18805(1.0, 0.0, 1.0);
            class_243 rightDelta = MathsHelper.projectOntoPlane(deltaTarget, forwardFacing).method_18805(1.0, 0.0, 1.0);
            class_243 pd = rightDelta.method_1020(rightVelocity.method_1021(2.0));
            boolean bl = moveRight = pd.method_1026(faceRight = forwardFacing.method_1036(new class_243(0.0, 1.0, 0.0))) > 0.0;
            if (moveRight) {
                MLGBucketTask.moveLeftRight(mod, 1);
            } else {
                MLGBucketTask.moveLeftRight(mod, -1);
            }
        }
    }

    private Optional<class_2338> getBestConeClutchBlock(PlayerEngineController mod, class_2338 oldClutchTarget) {
        double pitchHalfWidth = MLGBucketTask.config.epicClutchConePitchAngle;
        double dpitchStart = pitchHalfWidth / (double)MLGBucketTask.config.epicClutchConePitchResolution;
        ConeClutchContext cctx = new ConeClutchContext(mod);
        if (oldClutchTarget != null) {
            cctx.checkBlock(mod, oldClutchTarget);
        }
        for (double pitch = dpitchStart; pitch <= pitchHalfWidth; pitch += pitchHalfWidth / (double)MLGBucketTask.config.epicClutchConePitchResolution) {
            double pitchProgress = (pitch - dpitchStart) / (pitchHalfWidth - dpitchStart);
            double yawResolution = (double)MLGBucketTask.config.epicClutchConeYawDivisionStart + pitchProgress * (double)(MLGBucketTask.config.epicClutchConeYawDivisionEnd - MLGBucketTask.config.epicClutchConeYawDivisionStart);
            for (double yaw = 0.0; yaw < 360.0; yaw += 360.0 / yawResolution) {
                class_3959 rctx = this.castCone(yaw, pitch);
                cctx.checkRay(mod, rctx);
            }
        }
        class_243 center = mod.getPlayer().method_19538();
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                class_3959 ctx = this.castDown(center.method_1031((double)dx, 0.0, (double)dz));
                cctx.checkRay(mod, ctx);
            }
        }
        return Optional.ofNullable(cctx.bestBlock);
    }

    private class_3959 castDown(class_243 origin) {
        class_1309 clientPlayerEntity = this.controller.getPlayer();
        assert (clientPlayerEntity != null);
        return new class_3959(origin, origin.method_1031(0.0, -1.0 * MLGBucketTask.config.castDownDistance, 0.0), class_3959.class_3960.field_17558, class_3959.class_242.field_1347, (class_1297)clientPlayerEntity);
    }

    private class_3959 castCone(double yaw, double pitch) {
        class_1309 clientPlayerEntity = this.controller.getPlayer();
        assert (clientPlayerEntity != null);
        class_243 origin = clientPlayerEntity.method_19538();
        double dy = MLGBucketTask.config.epicClutchConeCastHeight;
        double dH = dy * Math.sin(Math.toRadians(pitch));
        double yawRad = Math.toRadians(yaw);
        double dx = dH * Math.cos(yawRad);
        double dz = dH * Math.sin(yawRad);
        class_243 end = origin.method_1031(dx, -1.0 * dy, dz);
        return new class_3959(origin, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1347, (class_1297)clientPlayerEntity);
    }

    @Override
    protected void onStop(Task interruptTask) {
        IBaritone baritone = this.controller.getBaritone();
        InputControls controls = this.controller.getInputControls();
        baritone.getPathingBehavior().forceCancel();
        this.movingTorwards = null;
        baritone.getInputOverrideHandler().setInputForceState(Input.CLICK_RIGHT, false);
        MLGBucketTask.moveLeftRight(this.controller, 0);
        MLGBucketTask.moveForwardBack(this.controller, 0);
        controls.release(Input.SPRINT);
        controls.release(Input.JUMP);
    }

    private boolean hasClutchItem(PlayerEngineController mod) {
        return !mod.getWorld().method_8597().comp_644() && mod.getItemStorage().hasItem(class_1802.field_8705) ? true : MLGBucketTask.config.clutchItems.stream().anyMatch(item -> mod.getItemStorage().hasItem((class_1792)item));
    }

    @Override
    public boolean isFinished() {
        class_1309 player = this.controller.getPlayer();
        return player.method_5681() || player.method_5799() || player.method_24828() || player.method_6101();
    }

    @Override
    protected boolean isEqual(Task other) {
        return other instanceof MLGBucketTask;
    }

    @Override
    protected String toDebugString() {
        Object result = "Epic gaemer moment";
        if (this.movingTorwards != null) {
            result = (String)result + " (CLUTCH AT: " + (String)result + ")";
        }
        return result;
    }

    public class_2338 getWaterPlacedPos() {
        return this.placedPos;
    }

    static {
        ConfigHelper.loadConfig("configs/mlg_clutch_settings.json", MLGClutchConfig::new, MLGClutchConfig.class, newConfig -> {
            config = newConfig;
        });
    }

    private static class MLGClutchConfig {
        public double castDownDistance = 40.0;
        public double averageHorizontalMovementSpeedPerTick = 0.25;
        public double epicClutchConeCastHeight = 40.0;
        public double epicClutchConePitchAngle = 25.0;
        public int epicClutchConePitchResolution = 8;
        public int epicClutchConeYawDivisionStart = 6;
        public int epicClutchConeYawDivisionEnd = 20;
        public int preferLavaWhenFallDropsHealthBelowThreshold = 3;
        public int lavaLevelOrGreaterWillCancelFallDamage = 5;
        public List<class_1792> clutchItems = List.of(class_1802.field_17528, class_1802.field_23070);

        private MLGClutchConfig() {
        }
    }

    class ConeClutchContext {
        private final boolean hasClutchItem;
        public class_2338 bestBlock = null;
        private double highestY = Double.NEGATIVE_INFINITY;
        private double closestXZ = Double.POSITIVE_INFINITY;
        private boolean bestBlockIsSafe = false;
        private boolean bestBlockIsDeadlyFall = false;
        private boolean bestBlockIsLava = false;

        public ConeClutchContext(PlayerEngineController mod) {
            this.hasClutchItem = MLGBucketTask.this.hasClutchItem(mod);
        }

        public void checkBlock(PlayerEngineController mod, class_2338 check) {
            if (!Objects.equals(this.bestBlock, check)) {
                if (WorldHelper.isAir(mod.getWorld().method_8320(check).method_26204())) {
                    Debug.logMessage("(MLG Air block checked for landing, the block broke. We'll try another): " + String.valueOf(check));
                } else {
                    boolean isDeadlyFall;
                    boolean lava = MLGBucketTask.isLava(MLGBucketTask.this.controller, check);
                    boolean lavaWillProtect = lava && MLGBucketTask.lavaWillProtect(MLGBucketTask.this.controller, check);
                    boolean water = MLGBucketTask.isWater(MLGBucketTask.this.controller, check);
                    boolean bl = isDeadlyFall = !this.hasClutchItem && MLGBucketTask.isFallDeadly(MLGBucketTask.this.controller, check);
                    if (!this.bestBlockIsSafe || water) {
                        boolean closestSoFar;
                        double height = check.method_10264();
                        double distSqXZ = WorldHelper.distanceXZSquared(WorldHelper.toVec3d(check), mod.getPlayer().method_19538());
                        boolean highestSoFar = height > this.highestY;
                        boolean bl2 = closestSoFar = distSqXZ < this.closestXZ;
                        if ((this.bestBlock == null || water && !this.bestBlockIsSafe || lava && lavaWillProtect && this.bestBlockIsDeadlyFall && !this.hasClutchItem || !lava && !isDeadlyFall && (closestSoFar && this.hasClutchItem && highestSoFar || this.bestBlockIsLava)) && MLGBucketTask.canTravelToInAir(MLGBucketTask.this.controller, !lava && !water ? check : check.method_10074())) {
                            if (highestSoFar) {
                                this.highestY = height;
                            }
                            if (closestSoFar) {
                                this.closestXZ = distSqXZ;
                            }
                            this.bestBlockIsSafe = water;
                            this.bestBlockIsDeadlyFall = isDeadlyFall;
                            this.bestBlockIsLava = lava;
                            this.bestBlock = check;
                        }
                    }
                }
            }
        }

        public void checkRay(PlayerEngineController mod, class_3959 rctx) {
            class_3965 hit = mod.getWorld().method_17742(rctx);
            if (hit.method_17783() == class_239.class_240.field_1332) {
                class_2338 check = hit.method_17777();
                if (hit.method_17780().method_10164() <= 0) {
                    return;
                }
                this.checkBlock(mod, check);
            }
        }
    }
}

