/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.ChunkSearchTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.util.Debug;
import dev.architectury.event.events.common.ChunkEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1923;

public abstract class SearchChunksExploreTask
extends Task {
    private final Object searcherMutex = new Object();
    private final Set<class_1923> alreadyExplored = new HashSet<class_1923>();
    private ChunkSearchTask searcher;

    protected class_1923 getBestChunkOverride(PlayerEngineController mod, List<class_1923> chunks) {
        return null;
    }

    @Override
    protected void onStart() {
        ChunkEvent.LOAD_DATA.register((chunk, level, data) -> this.onChunkLoad(chunk.method_12004()));
        this.resetSearch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Task onTick() {
        Object object = this.searcherMutex;
        synchronized (object) {
            if (this.searcher == null) {
                this.setDebugState("Exploring/Searching for valid chunk");
                return this.getWanderTask();
            }
            if (this.searcher.isActive() && this.searcher.isFinished()) {
                Debug.logWarning("Target object search failed.");
                this.alreadyExplored.addAll(this.searcher.getSearchedChunks());
                this.searcher = null;
            } else if (this.searcher.finished()) {
                this.setDebugState("Searching for target object...");
                Debug.logMessage("Search finished.");
                this.alreadyExplored.addAll(this.searcher.getSearchedChunks());
                this.searcher = null;
            }
            this.setDebugState("Searching within chunks...");
            return this.searcher;
        }
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onChunkLoad(class_1923 pos) {
        if (this.searcher == null && this.isActive() && this.isChunkWithinSearchSpace(this.controller, pos)) {
            Object object = this.searcherMutex;
            synchronized (object) {
                if (!this.alreadyExplored.contains(pos)) {
                    Debug.logMessage("New searcher: " + String.valueOf(pos));
                    this.searcher = new SearchSubTask(pos);
                }
            }
        }
    }

    protected Task getWanderTask() {
        return new TimeoutWanderTask(true);
    }

    public boolean failedSearch() {
        return this.searcher == null;
    }

    public void resetSearch() {
        this.searcher = null;
        this.alreadyExplored.clear();
        for (class_1923 start : this.controller.getChunkTracker().getLoadedChunks()) {
            this.onChunkLoad(start);
        }
    }

    protected abstract boolean isChunkWithinSearchSpace(PlayerEngineController var1, class_1923 var2);

    class SearchSubTask
    extends ChunkSearchTask {
        public SearchSubTask(class_1923 start) {
            super(start);
        }

        @Override
        protected boolean isChunkPartOfSearchSpace(PlayerEngineController mod, class_1923 pos) {
            return SearchChunksExploreTask.this.isChunkWithinSearchSpace(mod, pos);
        }

        @Override
        public class_1923 getBestChunk(PlayerEngineController mod, List<class_1923> chunks) {
            class_1923 override = SearchChunksExploreTask.this.getBestChunkOverride(mod, chunks);
            return override != null ? override : super.getBestChunk(mod, chunks);
        }

        @Override
        protected boolean isChunkSearchEqual(ChunkSearchTask other) {
            return other == this;
        }

        @Override
        protected String toDebugString() {
            return "Searching chunks...";
        }
    }
}

