/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.helpers.ProjectileHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.time.TimerGame;
import net.minecraft.class_1297;
import net.minecraft.class_1684;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_243;

public class ThrowEnderPearlSimpleProjectileTask
extends Task {
    private final TimerGame thrownTimer = new TimerGame(5.0);
    private final class_2338 target;
    private boolean thrown = false;

    public ThrowEnderPearlSimpleProjectileTask(class_2338 target) {
        this.target = target;
    }

    private static boolean cleanThrow(PlayerEngineController mod, float yaw, float pitch) {
        Rotation rotation = new Rotation(yaw, -1.0f * pitch);
        float range = 3.0f;
        class_243 delta = LookHelper.toVec3d(rotation).method_1021((double)range);
        class_243 start = LookHelper.getCameraPos(mod);
        return LookHelper.cleanLineOfSight(mod, start.method_1019(delta), (double)range);
    }

    private static Rotation calculateThrowLook(PlayerEngineController mod, class_2338 end) {
        double flatDistance;
        double[] pitches;
        class_243 start = ProjectileHelper.getThrowOrigin((class_1297)mod.getPlayer());
        class_243 endCenter = WorldHelper.toVec3d(end);
        double gravity = 0.03;
        double speed = 1.5;
        float yaw = LookHelper.getLookRotation(mod, end).getYaw();
        double pitch = ThrowEnderPearlSimpleProjectileTask.cleanThrow(mod, yaw, (float)(pitches = ProjectileHelper.calculateAnglesForSimpleProjectileMotion(start.field_1351 - endCenter.field_1351, flatDistance = WorldHelper.distanceXZ(start, endCenter), speed, gravity))[0]) ? pitches[0] : pitches[1];
        return new Rotation(yaw, -1.0f * (float)pitch);
    }

    @Override
    protected void onStart() {
        this.thrownTimer.forceElapse();
        this.thrown = false;
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        if (mod.getEntityTracker().entityFound(class_1684.class)) {
            this.thrownTimer.reset();
        }
        if (this.thrownTimer.elapsed() && mod.getSlotHandler().forceEquipItem(class_1802.field_8634)) {
            Rotation lookTarget = ThrowEnderPearlSimpleProjectileTask.calculateThrowLook(mod, this.target);
            LookHelper.lookAt(this.controller, lookTarget);
            if (LookHelper.isLookingAt(mod, lookTarget)) {
                mod.getInputControls().tryPress(Input.CLICK_RIGHT);
                this.thrown = true;
                this.thrownTimer.reset();
            }
        }
        return null;
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    public boolean isFinished() {
        return this.thrown && this.thrownTimer.elapsed() || !this.thrown && !this.controller.getItemStorage().hasItem(class_1802.field_8634);
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (other instanceof ThrowEnderPearlSimpleProjectileTask) {
            ThrowEnderPearlSimpleProjectileTask task = (ThrowEnderPearlSimpleProjectileTask)other;
            bl = task.target.equals((Object)this.target);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Simple Ender Pearling to " + String.valueOf(this.target);
    }
}

