/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.CraftInInventoryTask;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.resources.MineAndCollectTask;
import com.player2.playerengine.util.CraftingRecipe;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.RecipeTarget;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;

public class CollectCoarseDirtTask
extends ResourceTask {
    private static final float CLOSE_ENOUGH_COARSE_DIRT = 128.0f;
    private final int count;

    public CollectCoarseDirtTask(int targetCount) {
        super(class_1802.field_8460, targetCount);
        this.count = targetCount;
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        block5: {
            Optional<class_2338> closest;
            block4: {
                double c = Math.ceil((double)(this.count - mod.getItemStorage().getItemCount(class_1802.field_8460)) / 4.0) * 2.0;
                closest = mod.getBlockScanner().getNearestBlock(class_2246.field_10253);
                if ((double)mod.getItemStorage().getItemCount(class_1802.field_8831) < c) break block4;
                class_1792[] class_1792Array = new class_1792[]{class_1802.field_8110};
                if (!((double)mod.getItemStorage().getItemCount(class_1792Array) < c)) break block5;
            }
            if (closest.isPresent() && closest.get().method_19769((class_2374)mod.getPlayer().method_19538(), 128.0)) {
                return new MineAndCollectTask(new ItemTarget(class_1802.field_8460), new class_2248[]{class_2246.field_10253}, MiningRequirement.HAND).forceDimension(Dimension.OVERWORLD);
            }
        }
        int target = this.count;
        ItemTarget d = new ItemTarget(class_1802.field_8831, 1);
        ItemTarget g = new ItemTarget(class_1802.field_8110, 1);
        return new CraftInInventoryTask(new RecipeTarget(class_1802.field_8460, target, CraftingRecipe.newShapedRecipe("coarse_dirt", new ItemTarget[]{d, g, g, d}, 4)));
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        return other instanceof CollectCoarseDirtTask;
    }

    @Override
    protected String toDebugStringName() {
        return "Collecting " + this.count + " Coarse Dirt.";
    }
}

