/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.multiversion.item.ItemVer;
import com.player2.playerengine.tasks.CraftInInventoryTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.container.CraftInTableTask;
import com.player2.playerengine.tasks.container.SmeltInSmokerTask;
import com.player2.playerengine.tasks.movement.PickupDroppedItemTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.tasks.resources.CollectCropTask;
import com.player2.playerengine.tasks.resources.CollectMeatTask;
import com.player2.playerengine.tasks.resources.KillAndLootTask;
import com.player2.playerengine.tasks.resources.MineAndCollectTask;
import com.player2.playerengine.util.CraftingRecipe;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.RecipeTarget;
import com.player2.playerengine.util.SmeltTarget;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1428;
import net.minecraft.class_1430;
import net.minecraft.class_1452;
import net.minecraft.class_1463;
import net.minecraft.class_1472;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;

public class CollectFoodTask
extends Task {
    public static final CookableFoodTarget[] COOKABLE_FOODS = new CookableFoodTarget[]{new CookableFoodTarget("beef", class_1430.class), new CookableFoodTarget("porkchop", class_1452.class), new CookableFoodTarget("chicken", class_1428.class), new CookableFoodTarget("mutton", class_1472.class), new CookableFoodTarget("rabbit", class_1463.class)};
    public static final class_1792[] ITEMS_TO_PICK_UP = new class_1792[]{class_1802.field_8367, class_1802.field_8463, class_1802.field_8071, class_1802.field_8229, class_1802.field_8512};
    public static final CropTarget[] CROPS = new CropTarget[]{new CropTarget(class_1802.field_8861, class_2246.field_10293), new CropTarget(class_1802.field_8179, class_2246.field_10609)};
    private final double unitsNeeded;
    private final TimerGame checkNewOptionsTimer = new TimerGame(10.0);
    private Task currentResourceTask = null;

    public CollectFoodTask(double unitsNeeded) {
        this.unitsNeeded = unitsNeeded;
    }

    @Override
    protected void onStart() {
        this.controller.getBehaviour().push();
        this.controller.getBehaviour().addProtectedItems(ITEMS_TO_PICK_UP);
        this.controller.getBehaviour().addProtectedItems(class_1802.field_17528, class_1802.field_16998);
    }

    @Override
    protected Task onTick() {
        CollectFoodTask.blackListChickenJockeys(this.controller);
        CollectFoodTask.blacklistPillagerHayBales(this.controller);
        SmeltTarget toSmelt = this.getBestSmeltTarget(this.controller);
        if (toSmelt != null) {
            this.setDebugState("Smelting food");
            return new SmeltInSmokerTask(toSmelt);
        }
        if (this.checkNewOptionsTimer.elapsed()) {
            this.checkNewOptionsTimer.reset();
            this.currentResourceTask = null;
        }
        if (this.currentResourceTask != null && this.currentResourceTask.isActive() && !this.currentResourceTask.isFinished() && !this.currentResourceTask.thisOrChildAreTimedOut()) {
            return this.currentResourceTask;
        }
        double potentialFood = StorageHelper.calculateInventoryFoodScore(this.controller);
        if (potentialFood >= this.unitsNeeded) {
            if (this.controller.getItemStorage().getItemCount(class_1802.field_17528) >= 1) {
                this.setDebugState("Crafting wheat from hay");
                this.currentResourceTask = new CraftInInventoryTask(new RecipeTarget(class_1802.field_8861, 9, CraftingRecipe.newShapedRecipe("wheat", new ItemTarget[]{new ItemTarget(class_1802.field_17528, 1)}, 9)));
                return this.currentResourceTask;
            }
            if (this.controller.getItemStorage().getItemCount(class_1802.field_8861) >= 3) {
                this.setDebugState("Crafting bread");
                this.currentResourceTask = new CraftInTableTask(new RecipeTarget(class_1802.field_8229, 1, CraftingRecipe.newShapedRecipe("bread", new ItemTarget[]{new ItemTarget(class_1802.field_8861, 3)}, 1)));
                return this.currentResourceTask;
            }
        }
        for (class_1792 class_17922 : ITEMS_TO_PICK_UP) {
            if (!this.controller.getEntityTracker().itemDropped(class_17922)) continue;
            this.setDebugState("Picking up high-value food: " + class_17922.method_7848().getString());
            this.currentResourceTask = new PickupDroppedItemTask(new ItemTarget(class_17922), true);
            return this.currentResourceTask;
        }
        for (CookableFoodTarget cookableFoodTarget : COOKABLE_FOODS) {
            if (!this.controller.getEntityTracker().itemDropped(cookableFoodTarget.getRaw(), cookableFoodTarget.getCooked())) continue;
            this.setDebugState("Picking up dropped meat");
            this.currentResourceTask = new PickupDroppedItemTask(new ItemTarget(cookableFoodTarget.getRaw(), cookableFoodTarget.getCooked()), true);
            return this.currentResourceTask;
        }
        if (this.controller.getBlockScanner().anyFound(class_2246.field_10359)) {
            this.setDebugState("Collecting hay bales");
            this.currentResourceTask = new MineAndCollectTask(new ItemTarget(class_1802.field_17528, 9999), new class_2248[]{class_2246.field_10359}, MiningRequirement.HAND);
            return this.currentResourceTask;
        }
        for (CropTarget cropTarget : CROPS) {
            if (!this.controller.getBlockScanner().anyFound(pos -> CollectFoodTask.isCropMature(this.controller, pos, crop.cropBlock), cropTarget.cropBlock)) continue;
            this.setDebugState("Harvesting " + cropTarget.cropItem.method_7848().getString());
            this.currentResourceTask = new CollectCropTask(new ItemTarget(cropTarget.cropItem, 9999), new class_2248[]{cropTarget.cropBlock}, cropTarget.cropItem);
            return this.currentResourceTask;
        }
        class_1297 class_12972 = this.getBestAnimalToKill(this.controller);
        if (class_12972 != null) {
            this.setDebugState("Killing " + class_12972.method_5864().method_5897().getString());
            class_1792 rawFood = Arrays.stream(COOKABLE_FOODS).filter(c -> c.mobToKill == bestEntityToKill.getClass()).findFirst().get().getRaw();
            this.currentResourceTask = new KillAndLootTask(class_12972.getClass(), new ItemTarget(rawFood, 1));
            return this.currentResourceTask;
        }
        if (this.controller.getBlockScanner().anyFound(class_2246.field_16999)) {
            this.setDebugState("Collecting sweet berries");
            this.currentResourceTask = new MineAndCollectTask(new ItemTarget(class_1802.field_16998, 9999), new class_2248[]{class_2246.field_16999}, MiningRequirement.HAND);
            return this.currentResourceTask;
        }
        this.setDebugState("Searching for food source...");
        return new TimeoutWanderTask();
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBehaviour().pop();
    }

    @Override
    public boolean isFinished() {
        return (double)StorageHelper.calculateInventoryFoodScore(this.controller) >= this.unitsNeeded;
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (other instanceof CollectFoodTask) {
            CollectFoodTask task = (CollectFoodTask)other;
            bl = task.unitsNeeded == this.unitsNeeded;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Collecting " + this.unitsNeeded + " food units.";
    }

    private SmeltTarget getBestSmeltTarget(PlayerEngineController controller) {
        for (CookableFoodTarget cookable : COOKABLE_FOODS) {
            int rawCount = controller.getItemStorage().getItemCount(cookable.getRaw());
            if (rawCount <= 0) continue;
            return new SmeltTarget(new ItemTarget(cookable.getCooked(), rawCount), new ItemTarget(cookable.getRaw(), rawCount), new class_1792[0]);
        }
        return null;
    }

    private class_1297 getBestAnimalToKill(PlayerEngineController controller) {
        double bestScore = -1.0;
        class_1297 bestEntity = null;
        Predicate<class_1297> notBaby = entity -> entity instanceof class_1309 && !((class_1309)entity).method_6109();
        for (CookableFoodTarget cookable : COOKABLE_FOODS) {
            double score;
            double distanceSq;
            Optional<class_1297> nearest;
            if (!controller.getEntityTracker().entityFound(cookable.mobToKill) || !(nearest = controller.getEntityTracker().getClosestEntity(controller.getEntity().method_19538(), notBaby, cookable.mobToKill)).isPresent() || (distanceSq = nearest.get().method_19538().method_1025(controller.getEntity().method_19538())) == 0.0 || !((score = (double)cookable.getCookedUnits() / distanceSq) > bestScore)) continue;
            bestScore = score;
            bestEntity = nearest.get();
        }
        return bestEntity;
    }

    public static void blackListChickenJockeys(PlayerEngineController controller) {
        for (class_1428 chicken : controller.getEntityTracker().getTrackedEntities(class_1428.class)) {
            if (!chicken.method_5782()) continue;
            controller.getEntityTracker().requestEntityUnreachable((class_1297)chicken);
        }
    }

    private static void blacklistPillagerHayBales(PlayerEngineController controller) {
        for (class_2338 pos : controller.getBlockScanner().getKnownLocations(class_2246.field_10359)) {
            if (!controller.getWorld().method_8320(pos.method_10084()).method_27852(class_2246.field_10147)) continue;
            controller.getBlockScanner().requestBlockUnreachable(pos, 0);
        }
    }

    private static boolean isCropMature(PlayerEngineController controller, class_2338 pos, class_2248 block) {
        boolean bl;
        if (!controller.getChunkTracker().isChunkLoaded(pos)) {
            return false;
        }
        class_2248 class_22482 = controller.getWorld().method_8320(pos).method_26204();
        if (class_22482 instanceof class_2302) {
            class_2302 crop = (class_2302)class_22482;
            bl = crop.method_9825(controller.getWorld().method_8320(pos));
        } else {
            bl = true;
        }
        return bl;
    }

    public static double calculateFoodPotential(PlayerEngineController mod) {
        double potentialFood = 0.0;
        for (class_1799 food : mod.getItemStorage().getItemStacksPlayerInventory(true)) {
            potentialFood += CollectMeatTask.getFoodPotential(food);
        }
        int potentialBread = mod.getItemStorage().getItemCount(class_1802.field_8861) / 3 + mod.getItemStorage().getItemCount(class_1802.field_17528) * 3;
        return potentialFood + (double)(Objects.requireNonNull(ItemVer.getFoodComponent(class_1802.field_8229)).getHunger() * potentialBread);
    }

    public static class CookableFoodTarget {
        public final String rawFood;
        public final String cookedFood;
        public final Class<? extends class_1297> mobToKill;

        public CookableFoodTarget(String rawFood, Class<? extends class_1297> mobToKill) {
            this(rawFood, "cooked_" + rawFood, mobToKill);
        }

        public CookableFoodTarget(String rawFood, String cookedFood, Class<? extends class_1297> mobToKill) {
            this.rawFood = rawFood;
            this.cookedFood = cookedFood;
            this.mobToKill = mobToKill;
        }

        public class_1792 getRaw() {
            return TaskCatalogue.getItemMatches(this.rawFood)[0];
        }

        public class_1792 getCooked() {
            return TaskCatalogue.getItemMatches(this.cookedFood)[0];
        }

        public int getCookedUnits() {
            return ItemVer.getFoodComponent(this.getCooked()).getHunger();
        }
    }

    public static class CropTarget {
        public final class_1792 cropItem;
        public final class_2248 cropBlock;

        public CropTarget(class_1792 cropItem, class_2248 cropBlock) {
            this.cropItem = cropItem;
            this.cropBlock = cropBlock;
        }
    }
}

