/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.entity.AbstractDoToEntityTask;
import com.player2.playerengine.util.Debug;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1430;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;

public class CollectMilkTask
extends ResourceTask {
    private final int count;

    public CollectMilkTask(int targetCount) {
        super(class_1802.field_8103, targetCount);
        this.count = targetCount;
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        if (!mod.getItemStorage().hasItem(class_1802.field_8550)) {
            return TaskCatalogue.getItemTask(class_1802.field_8550, 1);
        }
        return !mod.getEntityTracker().entityFound(class_1430.class) && this.isInWrongDimension(mod) ? this.getToCorrectDimensionTask(mod) : new MilkCowTask();
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        return other instanceof CollectMilkTask;
    }

    @Override
    protected String toDebugStringName() {
        return "Collecting " + this.count + " milk buckets.";
    }

    static class MilkCowTask
    extends AbstractDoToEntityTask {
        public MilkCowTask() {
            super(0.0, -1.0, -1.0);
        }

        @Override
        protected boolean isSubEqual(AbstractDoToEntityTask other) {
            return other instanceof MilkCowTask;
        }

        @Override
        protected Task onEntityInteract(PlayerEngineController mod, class_1297 entity) {
            if (!mod.getItemStorage().hasItem(class_1802.field_8550)) {
                Debug.logWarning("Failed to milk cow because you have no bucket.");
                return null;
            }
            if (mod.getSlotHandler().forceEquipItem(class_1802.field_8550)) {
                mod.getInventory().method_5447(mod.getInventory().selectedSlot, new class_1799((class_1935)class_1802.field_8103));
            }
            return null;
        }

        @Override
        protected Optional<class_1297> getEntityTarget(PlayerEngineController mod) {
            return mod.getEntityTracker().getClosestEntity(mod.getPlayer().method_19538(), class_1430.class);
        }

        @Override
        protected String toDebugString() {
            return "Milking Cow";
        }
    }
}

