/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.CraftInInventoryTask;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.resources.MineAndCollectTask;
import com.player2.playerengine.trackers.storage.ItemStorageTracker;
import com.player2.playerengine.util.CraftingRecipe;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.RecipeTarget;
import com.player2.playerengine.util.helpers.ItemHelper;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.class_1792;

public class CollectPlanksTask
extends ResourceTask {
    private final class_1792[] planks;
    private final class_1792[] logs;
    private final int targetCount;
    private boolean logsInNether;

    public CollectPlanksTask(class_1792[] planks, class_1792[] logs, int count, boolean logsInNether) {
        super(new ItemTarget(planks, count));
        this.planks = planks;
        this.logs = logs;
        this.targetCount = count;
        this.logsInNether = logsInNether;
    }

    public CollectPlanksTask(int count) {
        this(ItemHelper.PLANKS, ItemHelper.LOG, count, false);
    }

    public CollectPlanksTask(class_1792 plank, class_1792 log, int count) {
        this(new class_1792[]{plank}, new class_1792[]{log}, count, false);
    }

    public CollectPlanksTask(class_1792 plank, int count) {
        this(plank, ItemHelper.planksToLog(plank), count);
    }

    private static CraftingRecipe generatePlankRecipe(class_1792[] logs) {
        return CraftingRecipe.newShapedRecipe("planks", new class_1792[][]{logs, null, null, null}, 4);
    }

    @Override
    protected double getPickupRange(PlayerEngineController mod) {
        ItemStorageTracker storage = mod.getItemStorage();
        return storage.getItemCount(ItemHelper.LOG) * 4 > this.targetCount ? 10.0 : 50.0;
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        int totalInventoryPlankCount = mod.getItemStorage().getItemCount(this.planks);
        int potentialPlanks = totalInventoryPlankCount + mod.getItemStorage().getItemCount(this.logs) * 4;
        if (potentialPlanks >= this.targetCount) {
            for (class_1792 logCheck : this.logs) {
                int count = mod.getItemStorage().getItemCount(logCheck);
                if (count <= 0) continue;
                class_1792 plankCheck = ItemHelper.logToPlanks(logCheck);
                if (plankCheck == null) {
                    Debug.logError("Invalid/Un-convertable log: " + String.valueOf(logCheck) + " (failed to find corresponding plank)");
                }
                int plankCount = mod.getItemStorage().getItemCount(plankCheck);
                int otherPlankCount = totalInventoryPlankCount - plankCount;
                int targetTotalPlanks = Math.min(count * 4 + plankCount, this.targetCount - otherPlankCount);
                this.setDebugState("We have " + String.valueOf(logCheck) + ", crafting " + targetTotalPlanks + " planks.");
                return new CraftInInventoryTask(new RecipeTarget(plankCheck, targetTotalPlanks, CollectPlanksTask.generatePlankRecipe(this.logs)));
            }
        }
        ArrayList<ItemTarget> blocksTomine = new ArrayList<ItemTarget>(2);
        blocksTomine.add(new ItemTarget(this.logs, mod.getItemStorage().getItemCount(this.logs) + 1));
        if (!mod.getBehaviour().exclusivelyMineLogs()) {
            // empty if block
        }
        MineAndCollectTask mineAndCollectTask = new MineAndCollectTask((ItemTarget[])blocksTomine.toArray(ItemTarget[]::new), MiningRequirement.HAND);
        if (this.logsInNether) {
            mineAndCollectTask.forceDimension(Dimension.NETHER);
        }
        return mineAndCollectTask;
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        return other instanceof CollectPlanksTask;
    }

    @Override
    protected String toDebugStringName() {
        return "Crafting " + this.targetCount + " planks " + Arrays.toString(this.planks);
    }

    public CollectPlanksTask logsInNether() {
        this.logsInNether = true;
        return this;
    }
}

