/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.speedrun;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.DestroyBlockTask;
import com.player2.playerengine.tasks.construction.PlaceBlockTask;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.tasks.movement.GetToXZTask;
import com.player2.playerengine.tasks.speedrun.WaitForDragonAndPearlTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.helpers.ItemHelper;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.Arrays;
import net.minecraft.class_1297;
import net.minecraft.class_1508;
import net.minecraft.class_1510;
import net.minecraft.class_1518;
import net.minecraft.class_1519;
import net.minecraft.class_1521;
import net.minecraft.class_1527;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;

public class KillEnderDragonWithBedsTask
extends Task {
    private final WaitForDragonAndPearlTask whenNotPerchingTask;
    TimerGame placeBedTimer = new TimerGame(0.6);
    TimerGame waiTimer = new TimerGame(0.3);
    TimerGame waitBeforePlaceTimer = new TimerGame(0.5);
    boolean waited = false;
    double prevDist = 100.0;
    private class_2338 endPortalTop;
    private Task freePortalTopTask = null;
    private Task placeObsidianTask = null;
    private boolean dragonDead = false;

    public KillEnderDragonWithBedsTask() {
        this.whenNotPerchingTask = new WaitForDragonAndPearlTask();
    }

    public static class_2338 locateExitPortalTop(PlayerEngineController mod) {
        if (!mod.getChunkTracker().isChunkLoaded(new class_2338(0, 64, 0))) {
            return null;
        }
        int height = WorldHelper.getGroundHeight(mod, 0, 0, class_2246.field_9987);
        return height != -1 ? new class_2338(0, height, 0) : null;
    }

    @Override
    protected void onStart() {
        this.controller.getBehaviour().avoidBlockPlacing(pos -> pos.method_10260() == 0 && Math.abs(pos.method_10263()) < 5);
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        if (this.endPortalTop == null) {
            this.endPortalTop = KillEnderDragonWithBedsTask.locateExitPortalTop(mod);
            if (this.endPortalTop != null) {
                this.whenNotPerchingTask.setExitPortalTop(this.endPortalTop);
            }
        }
        if (this.endPortalTop == null) {
            this.setDebugState("Searching for end portal top.");
            return new GetToXZTask(0, 0);
        }
        class_2338 obsidianTarget = this.endPortalTop.method_10084().method_10093(class_2350.field_11043);
        if (!mod.getWorld().method_8320(obsidianTarget).method_26204().equals(class_2246.field_10540)) {
            if (WorldHelper.inRangeXZ(mod.getPlayer().method_19538(), new class_243(0.0, 0.0, 0.0), 10.0)) {
                if (this.placeObsidianTask == null) {
                    this.placeObsidianTask = new PlaceBlockTask(obsidianTarget, class_2246.field_10540);
                }
                return this.placeObsidianTask;
            }
            return new GetToXZTask(0, 0);
        }
        class_2680 stateAtPortal = mod.getWorld().method_8320(this.endPortalTop.method_10084());
        if (!(stateAtPortal.method_26215() || stateAtPortal.method_26204().equals(class_2246.field_10036) || Arrays.stream(ItemHelper.itemsToBlocks(ItemHelper.BED)).toList().contains(stateAtPortal.method_26204()))) {
            if (this.freePortalTopTask == null) {
                this.freePortalTopTask = new DestroyBlockTask(this.endPortalTop.method_10084());
            }
            return this.freePortalTopTask;
        }
        if (this.dragonDead) {
            this.setDebugState("Waiting for overworld portal to spawn.");
            return new GetToBlockTask(this.endPortalTop.method_10087(4).method_10067());
        }
        if (!mod.getEntityTracker().entityFound(class_1510.class) || this.dragonDead) {
            this.setDebugState("No dragon found.");
            if (!WorldHelper.inRangeXZ((class_1297)mod.getPlayer(), this.endPortalTop, 1.0)) {
                this.setDebugState("Going to end portal top at" + this.endPortalTop.toString() + ".");
                return new GetToBlockTask(this.endPortalTop);
            }
        }
        for (class_1510 dragon : mod.getEntityTracker().getTrackedEntities(class_1510.class)) {
            boolean perching;
            class_1521 dragonPhase = dragon.method_6831().method_6864();
            if (dragonPhase.method_6849() == class_1527.field_7068) {
                Debug.logMessage("Dragon is dead.");
                if (mod.getPlayer().method_36455() != -90.0f) {
                    mod.getPlayer().method_36457(-90.0f);
                }
                this.dragonDead = true;
                return null;
            }
            boolean bl = perching = dragonPhase instanceof class_1518 || dragonPhase instanceof class_1519 || dragonPhase.method_6848();
            if (dragon.method_23318() < (double)(this.endPortalTop.method_10264() + 2)) {
                perching = false;
            }
            this.whenNotPerchingTask.setPerchState(perching);
            if (this.whenNotPerchingTask.isActive() && !this.whenNotPerchingTask.isFinished()) {
                this.setDebugState("Dragon not perching, performing special behavior...");
                return this.whenNotPerchingTask;
            }
            if (!perching) continue;
            return this.performOneCycle(mod, dragon);
        }
        mod.getFoodChain().shouldStop(false);
        return this.whenNotPerchingTask;
    }

    private Task performOneCycle(PlayerEngineController mod, class_1510 dragon) {
        mod.getFoodChain().shouldStop(true);
        if (mod.getInputControls().isHeldDown(Input.SNEAK)) {
            mod.getInputControls().release(Input.SNEAK);
        }
        mod.getSlotHandler().forceEquipItemToOffhand(class_1802.field_8162);
        class_2338 endPortalTop = KillEnderDragonWithBedsTask.locateExitPortalTop(mod).method_10084();
        class_2338 obsidian = null;
        class_2350 dir = null;
        for (class_2350 direction : new class_2350[]{class_2350.field_11034, class_2350.field_11039, class_2350.field_11043, class_2350.field_11035}) {
            if (!mod.getWorld().method_8320(endPortalTop.method_10093(direction)).method_26204().equals(class_2246.field_10540)) continue;
            obsidian = endPortalTop.method_10093(direction);
            dir = direction.method_10153();
            break;
        }
        if (dir == null) {
            mod.log("no obisidan? :(");
            return null;
        }
        class_2350 offsetDir = dir.method_10166() == class_2350.class_2351.field_11048 ? class_2350.field_11035 : class_2350.field_11039;
        class_2338 targetBlock = endPortalTop.method_10087(3).method_10079(offsetDir, 3).method_10093(dir);
        double d = this.distanceIgnoreY(WorldHelper.toVec3d(targetBlock), mod.getPlayer().method_19538());
        if (!(d > 0.7) && mod.getPlayer().method_24515().method_10074().method_10264() <= endPortalTop.method_10264() - 4) {
            if (!this.waited) {
                this.waited = true;
                this.waitBeforePlaceTimer.reset();
            }
            if (!this.waitBeforePlaceTimer.elapsed()) {
                mod.log(this.waitBeforePlaceTimer.getDuration() + " waiting...");
                return null;
            }
            LookHelper.lookAt(mod, obsidian, dir);
            class_2338 bedHead = WorldHelper.getBedHead(mod, endPortalTop);
            mod.getSlotHandler().forceEquipItem(ItemHelper.BED);
            if (bedHead == null) {
                if (this.placeBedTimer.elapsed() && Math.abs(dragon.method_23318() - (double)endPortalTop.method_10264()) < 10.0) {
                    mod.getInputControls().tryPress(Input.CLICK_RIGHT);
                    this.waiTimer.reset();
                }
                return null;
            }
            if (!this.waiTimer.elapsed()) {
                return null;
            }
            class_243 dragonHeadPos = dragon.field_7017.method_5829().method_1005();
            class_243 bedHeadPos = WorldHelper.toVec3d(bedHead);
            double dist = dragonHeadPos.method_1022(bedHeadPos);
            double distXZ = this.distanceIgnoreY(dragonHeadPos, bedHeadPos);
            class_1508 body = dragon.method_5690()[2];
            double destroyDistance = Math.abs(body.method_5829().method_1001(class_2350.class_2351.field_11052) - bedHeadPos.method_10214());
            boolean tooClose = destroyDistance < 1.1;
            boolean skip = destroyDistance > 3.0 && dist > 4.5 && distXZ > 2.5;
            mod.log(destroyDistance + " : " + destroyDistance + " : " + dist);
            if ((dist < 1.5 || this.prevDist < distXZ && destroyDistance < 4.0 && this.prevDist < 2.9 || destroyDistance < 2.0 && dist < 4.0 || destroyDistance < 1.7 && dist < 4.5 || tooClose || destroyDistance < 2.4 && distXZ < 3.7 || destroyDistance < 3.5 && distXZ < 2.4) && !skip) {
                mod.getInputControls().tryPress(Input.CLICK_RIGHT);
                this.placeBedTimer.reset();
            }
            this.prevDist = distXZ;
            return null;
        }
        mod.log("" + d);
        return new GetToBlockTask(targetBlock);
    }

    public double distanceIgnoreY(class_243 vec, class_243 vec1) {
        double d = vec.field_1352 - vec1.field_1352;
        double f = vec.field_1350 - vec1.field_1350;
        return Math.sqrt(d * d + f * f);
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getFoodChain().shouldStop(false);
    }

    @Override
    public boolean isFinished() {
        return super.isFinished();
    }

    @Override
    protected boolean isEqual(Task other) {
        return other instanceof KillEnderDragonWithBedsTask;
    }

    @Override
    protected String toDebugString() {
        return "Bedding the Ender Dragon";
    }
}

