/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.speedrun;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.entity.DoToClosestEntityTask;
import com.player2.playerengine.tasks.entity.KillEntitiesTask;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.tasks.movement.GetToXZTask;
import com.player2.playerengine.tasks.movement.GetToYTask;
import com.player2.playerengine.tasks.movement.ThrowEnderPearlSimpleProjectileTask;
import com.player2.playerengine.tasks.resources.GetBuildingMaterialsTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1510;
import net.minecraft.class_1511;
import net.minecraft.class_1560;
import net.minecraft.class_1670;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3965;

public class WaitForDragonAndPearlTask
extends Task {
    private static final double XZ_RADIUS = 30.0;
    private static final double XZ_RADIUS_TOO_FAR = 38.0;
    private static final int HEIGHT = 42;
    private static final int CLOSE_ENOUGH_DISTANCE = 15;
    private final int Y_COORDINATE = 75;
    private static final double DRAGON_FIREBALL_TOO_CLOSE_RANGE = 40.0;
    private final Task buildingMaterialsTask = new GetBuildingMaterialsTask(52);
    boolean inCenter;
    private Task heightPillarTask;
    private Task throwPearlTask;
    private class_2338 targetToPearl;
    private boolean dragonIsPerching;
    private Task pillarUpFurther;
    private boolean hasPillar = false;

    public void setExitPortalTop(class_2338 top) {
        class_2338 actualTarget = top.method_10074();
        if (!actualTarget.equals((Object)this.targetToPearl)) {
            this.targetToPearl = actualTarget;
            this.throwPearlTask = new ThrowEnderPearlSimpleProjectileTask(actualTarget);
        }
    }

    public void setPerchState(boolean perching) {
        this.dragonIsPerching = perching;
    }

    @Override
    protected void onStart() {
    }

    @Override
    protected Task onTick() {
        class_1560 endermanEntity;
        PlayerEngineController mod = this.controller;
        Optional<class_1297> enderMen = mod.getEntityTracker().getClosestEntity(class_1560.class);
        if (enderMen.isPresent() && (endermanEntity = (class_1560)enderMen.get()) instanceof class_1560 && endermanEntity.method_5968() == mod.getPlayer()) {
            this.setDebugState("Killing angry endermen");
            Predicate<class_1297> angry = entity -> endermanEntity.method_5968() == mod.getPlayer();
            return new KillEntitiesTask(angry, enderMen.get().getClass());
        }
        if (this.throwPearlTask != null && this.throwPearlTask.isActive() && !this.throwPearlTask.isFinished()) {
            this.setDebugState("Throwing pearl!");
            return this.throwPearlTask;
        }
        if (this.pillarUpFurther != null && this.pillarUpFurther.isActive() && !this.pillarUpFurther.isFinished() && mod.getEntityTracker().getClosestEntity(class_1295.class).isPresent()) {
            Optional<class_1297> cloud = mod.getEntityTracker().getClosestEntity(class_1295.class);
            if (cloud.isPresent() && cloud.get().method_24516((class_1297)mod.getPlayer(), 4.0)) {
                this.setDebugState("PILLAR UP FURTHER to avoid dragon's breath");
                return this.pillarUpFurther;
            }
            Optional<class_1297> fireball = mod.getEntityTracker().getClosestEntity(class_1670.class);
            if (this.isFireballDangerous(mod, fireball)) {
                this.setDebugState("PILLAR UP FURTHER to avoid dragon's breath");
                return this.pillarUpFurther;
            }
        }
        if (!mod.getItemStorage().hasItem(class_1802.field_8634) && this.inCenter) {
            this.setDebugState("First get ender pearls.");
            return TaskCatalogue.getItemTask(class_1802.field_8634, 1);
        }
        int minHeight = this.targetToPearl.method_10264() + 42 - 3;
        int deltaY = minHeight - mod.getPlayer().method_24515().method_10264();
        if (StorageHelper.getBuildingMaterialCount(this.controller) >= Math.min(deltaY - 10, 37) && (!this.buildingMaterialsTask.isActive() || this.buildingMaterialsTask.isFinished())) {
            if (this.dragonIsPerching && this.canThrowPearl(mod)) {
                Debug.logMessage("THROWING PEARL!!");
                return this.throwPearlTask;
            }
            if (mod.getPlayer().method_24515().method_10264() < minHeight) {
                if (mod.getEntityTracker().entityFound(entity -> mod.getPlayer().method_19538().method_24802((class_2374)entity.method_19538(), 4.0), class_1295.class)) {
                    if (mod.getEntityTracker().getClosestEntity(class_1510.class).isPresent() && !mod.getBaritone().getPathingBehavior().isPathing()) {
                        LookHelper.lookAt(mod, mod.getEntityTracker().getClosestEntity(class_1510.class).get().method_33571());
                    }
                    return null;
                }
                if (this.heightPillarTask != null && this.heightPillarTask.isActive() && !this.heightPillarTask.isFinished()) {
                    this.setDebugState("Pillaring up!");
                    this.inCenter = true;
                    return mod.getEntityTracker().entityFound(class_1511.class) ? new DoToClosestEntityTask(toDestroy -> {
                        if (toDestroy.method_24516((class_1297)mod.getPlayer(), 7.0)) {
                            mod.getControllerExtras().attack((class_1297)toDestroy);
                        }
                        if (mod.getPlayer().method_24515().method_10264() < minHeight) {
                            return this.heightPillarTask;
                        }
                        if (mod.getEntityTracker().getClosestEntity(class_1510.class).isPresent() && !mod.getBaritone().getPathingBehavior().isPathing()) {
                            LookHelper.lookAt(mod, mod.getEntityTracker().getClosestEntity(class_1510.class).get().method_33571());
                        }
                        return null;
                    }, class_1511.class) : this.heightPillarTask;
                }
                if (!WorldHelper.inRangeXZ((class_1297)mod.getPlayer(), this.targetToPearl, 38.0) && mod.getPlayer().method_19538().method_10214() < (double)minHeight && !this.hasPillar) {
                    if (mod.getEntityTracker().entityFound(entity -> mod.getPlayer().method_19538().method_24802((class_2374)entity.method_19538(), 4.0), class_1295.class)) {
                        if (mod.getEntityTracker().getClosestEntity(class_1510.class).isPresent() && !mod.getBaritone().getPathingBehavior().isPathing()) {
                            LookHelper.lookAt(mod, mod.getEntityTracker().getClosestEntity(class_1510.class).get().method_33571());
                        }
                        return null;
                    }
                    this.setDebugState("Moving in (too far, might hit pillars)");
                    return new GetToXZTask(0, 0);
                }
                if (!this.hasPillar) {
                    this.hasPillar = true;
                }
                this.heightPillarTask = new GetToBlockTask(new class_2338(0, minHeight, 75));
                return this.heightPillarTask;
            }
            this.setDebugState("We're high enough.");
            Optional<class_1297> dragonFireball = mod.getEntityTracker().getClosestEntity(class_1670.class);
            if (dragonFireball.isPresent() && dragonFireball.get().method_24516((class_1297)mod.getPlayer(), 40.0) && LookHelper.cleanLineOfSight((class_1297)mod.getPlayer(), dragonFireball.get().method_19538(), 40.0)) {
                this.pillarUpFurther = new GetToYTask(mod.getPlayer().method_31478() + 5);
                Debug.logMessage("HOLDUP");
                return this.pillarUpFurther;
            }
            if (mod.getEntityTracker().entityFound(class_1511.class)) {
                return new DoToClosestEntityTask(toDestroy -> {
                    if (toDestroy.method_24516((class_1297)mod.getPlayer(), 7.0)) {
                        mod.getControllerExtras().attack((class_1297)toDestroy);
                    }
                    if (mod.getPlayer().method_24515().method_10264() < minHeight) {
                        return this.heightPillarTask;
                    }
                    if (mod.getEntityTracker().getClosestEntity(class_1510.class).isPresent() && !mod.getBaritone().getPathingBehavior().isPathing()) {
                        LookHelper.lookAt(mod, mod.getEntityTracker().getClosestEntity(class_1510.class).get().method_33571());
                    }
                    return null;
                }, class_1511.class);
            }
            if (mod.getEntityTracker().getClosestEntity(class_1510.class).isPresent() && !mod.getBaritone().getPathingBehavior().isPathing()) {
                LookHelper.lookAt(mod, mod.getEntityTracker().getClosestEntity(class_1510.class).get().method_33571());
            }
            return null;
        }
        this.setDebugState("Collecting building materials...");
        return this.buildingMaterialsTask;
    }

    private boolean canThrowPearl(PlayerEngineController mod) {
        class_243 targetPosition = WorldHelper.toVec3d(this.targetToPearl.method_10084());
        class_3965 hitResult = LookHelper.raycast((class_1297)mod.getPlayer(), LookHelper.getCameraPos((class_1297)mod.getPlayer()), targetPosition, 300.0);
        if (hitResult == null) {
            return true;
        }
        return switch (hitResult.method_17783()) {
            case class_239.class_240.field_1333 -> true;
            case class_239.class_240.field_1332 -> hitResult.method_17777().method_19771((class_2382)this.targetToPearl.method_10084(), 10.0);
            case class_239.class_240.field_1331 -> false;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private boolean isFireballDangerous(PlayerEngineController mod, Optional<class_1297> fireball) {
        if (fireball.isEmpty()) {
            return false;
        }
        boolean fireballTooClose = fireball.get().method_24516((class_1297)mod.getPlayer(), 40.0);
        boolean fireballInSight = LookHelper.cleanLineOfSight((class_1297)mod.getPlayer(), fireball.get().method_19538(), 40.0);
        return fireballTooClose && fireballInSight;
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    protected boolean isEqual(Task other) {
        return other instanceof WaitForDragonAndPearlTask;
    }

    @Override
    public boolean isFinished() {
        return this.dragonIsPerching && (this.throwPearlTask == null || this.throwPearlTask.isActive() && this.throwPearlTask.isFinished() || WorldHelper.inRangeXZ((class_1297)this.controller.getPlayer(), this.targetToPearl, 15.0));
    }

    @Override
    protected String toDebugString() {
        return "Waiting for Dragon Perch + Pearling";
    }
}

