/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.trackers.storage;

import com.player2.playerengine.trackers.storage.ContainerType;
import com.player2.playerengine.util.Dimension;
import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_3858;

public class ContainerCache {
    private final class_2338 blockPos;
    private final Dimension dimension;
    private final ContainerType containerType;
    private final HashMap<class_1792, Integer> itemCounts = new HashMap();
    private int emptySlots;

    public ContainerCache(Dimension dimension, class_2338 blockPos, ContainerType containerType) {
        this.dimension = dimension;
        this.blockPos = blockPos;
        this.containerType = containerType;
    }

    public void update(class_1263 screenHandler, Consumer<class_1799> onStack) {
        this.itemCounts.clear();
        this.emptySlots = 0;
        int start = 0;
        int end = screenHandler.method_5439();
        boolean isFurnace = screenHandler instanceof class_3858;
        for (int i = start; i < end; ++i) {
            class_1799 stack = screenHandler.method_5438(i).method_7972();
            if (stack.method_7960()) {
                if (isFurnace && i == 2) continue;
                ++this.emptySlots;
                continue;
            }
            class_1792 item = stack.method_7909();
            int count = stack.method_7947();
            this.itemCounts.put(item, this.itemCounts.getOrDefault(item, 0) + count);
            onStack.accept(stack);
        }
    }

    public int getItemCount(class_1792 ... items) {
        int result = 0;
        for (class_1792 item : items) {
            result += this.itemCounts.getOrDefault(item, 0).intValue();
        }
        return result;
    }

    public boolean hasItem(class_1792 ... items) {
        for (class_1792 item : items) {
            if (!this.itemCounts.containsKey(item) || this.itemCounts.get(item) <= 0) continue;
            return true;
        }
        return false;
    }

    public int getEmptySlotCount() {
        return this.emptySlots;
    }

    public boolean isFull() {
        return this.emptySlots == 0;
    }

    public class_2338 getBlockPos() {
        return this.blockPos;
    }

    public ContainerType getContainerType() {
        return this.containerType;
    }

    public Dimension getDimension() {
        return this.dimension;
    }
}

