/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util.helpers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.serialization.IFailableConfigFile;
import com.player2.playerengine.util.serialization.IListConfigFile;
import com.player2.playerengine.util.serialization.gson.BlockPosTypeAdapter;
import com.player2.playerengine.util.serialization.gson.ChunkPosTypeAdapter;
import com.player2.playerengine.util.serialization.gson.ItemListTypeAdapter;
import com.player2.playerengine.util.serialization.gson.Vec3dTypeAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_243;

public class ConfigHelper {
    private static final HashMap<String, Runnable> loadedConfigs = new HashMap();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(class_2338.class, (Object)new BlockPosTypeAdapter()).registerTypeAdapter(class_1923.class, (Object)new ChunkPosTypeAdapter()).registerTypeAdapter(class_243.class, (Object)new Vec3dTypeAdapter()).registerTypeAdapter(new TypeToken<List<class_1792>>(){}.getType(), (Object)new ItemListTypeAdapter()).create();

    private static File getConfigFile(String path) {
        String fullPath = "playerengine" + File.separator + path;
        return new File(fullPath);
    }

    public static void reloadAllConfigs() {
        for (Runnable config : loadedConfigs.values()) {
            config.run();
        }
    }

    private static <T> T getConfig(String path, Supplier<T> getDefault, Class<T> classToLoad) {
        Object result = getDefault.get();
        File loadFrom = ConfigHelper.getConfigFile(path);
        if (!loadFrom.exists()) {
            ConfigHelper.saveConfig(path, result);
            return result;
        }
        try (FileReader reader = new FileReader(loadFrom);){
            result = GSON.fromJson((Reader)reader, classToLoad);
        }
        catch (JsonSyntaxException e) {
            Debug.logError("Failed to parse Config file of type " + classToLoad.getSimpleName() + " at " + path + ". JSON Error Message: " + e.getMessage());
            e.printStackTrace();
            if (result instanceof IFailableConfigFile) {
                IFailableConfigFile failable = (IFailableConfigFile)result;
                failable.onFailLoad();
            }
            return result;
        }
        catch (IOException e) {
            Debug.logError("Failed to read Config at " + path + ".");
            e.printStackTrace();
            if (result instanceof IFailableConfigFile) {
                IFailableConfigFile failable = (IFailableConfigFile)result;
                failable.onFailLoad();
            }
            return result;
        }
        ConfigHelper.saveConfig(path, result);
        return result;
    }

    public static <T> void saveConfig(String path, T config) {
        File configFile = ConfigHelper.getConfigFile(path);
        ConfigHelper.createParentDirectories(configFile);
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson(config, (Appendable)writer);
        }
        catch (IOException e) {
            ConfigHelper.handleIOException(e);
        }
    }

    public static <T> void loadConfig(String path, Supplier<T> getDefault, Class<T> classToLoad, Consumer<T> onReload) {
        Object config = ConfigHelper.getConfig(path, getDefault, classToLoad);
        loadedConfigs.put(path, () -> onReload.accept(config));
        onReload.accept(config);
    }

    private static void createParentDirectories(File file) {
        try {
            Path parentPath = file.getParentFile().toPath();
            Files.createDirectories(parentPath, new FileAttribute[0]);
        }
        catch (IOException var2) {
            System.err.println("Failed to create parent directories: " + var2.getMessage());
        }
    }

    private static void handleIOException(IOException exception) {
        String errorMessage = "An IOException occurred: " + exception.getMessage();
        System.err.println(errorMessage);
    }

    private static <T extends IListConfigFile> T getListConfig(String path, Supplier<T> getDefault) {
        IListConfigFile iListConfigFile = (IListConfigFile)getDefault.get();
        iListConfigFile.onLoadStart();
        File configFile = ConfigHelper.getConfigFile(path);
        if (!configFile.exists()) {
            return (T)iListConfigFile;
        }
        try {
            FileInputStream fis = new FileInputStream(configFile);
            try {
                try (Scanner scanner = new Scanner(fis);){
                    while (scanner.hasNextLine()) {
                        String line = ConfigHelper.trimComment(scanner.nextLine()).trim();
                        if (line.isEmpty()) continue;
                        iListConfigFile.addLine(line);
                    }
                    scanner.close();
                }
                return (T)iListConfigFile;
            }
            catch (Throwable var11) {
                try {
                    fis.close();
                }
                catch (Throwable var8) {
                    var11.addSuppressed(var8);
                }
                throw var11;
            }
        }
        catch (IOException var12) {
            var12.printStackTrace();
            return null;
        }
    }

    public static <T extends IListConfigFile> void loadListConfig(String path, Supplier<T> getDefault, Consumer<T> onReload) {
        Object result = ConfigHelper.getListConfig(path, getDefault);
        loadedConfigs.put(path, () -> onReload.accept(result));
        onReload.accept(result);
    }

    private static String trimComment(String line) {
        int poundIndex = line.indexOf(35);
        return poundIndex == -1 ? line : line.substring(0, poundIndex);
    }

    public static void ensureCommentedListFileExists(String path, String startingComment) {
        File configFile = ConfigHelper.getConfigFile(path);
        if (!configFile.exists()) {
            StringBuilder commentBuilder = new StringBuilder();
            for (String line : startingComment.split("\\r?\\n")) {
                if (line.isEmpty()) continue;
                commentBuilder.append("# ").append(line).append("\n");
            }
            try {
                Files.write(configFile.toPath(), commentBuilder.toString().getBytes(), new OpenOption[0]);
            }
            catch (IOException var8) {
                ConfigHelper.handleException(var8);
            }
        }
    }

    private static void handleException(IOException exception) {
        System.err.println("An error occurred: " + exception.getMessage());
    }
}

