/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util.helpers;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.multiversion.DamageSourceWrapper;
import com.player2.playerengine.multiversion.MethodWrapper;
import net.minecraft.class_1280;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1560;
import net.minecraft.class_1588;
import net.minecraft.class_1590;
import net.minecraft.class_1621;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_3218;
import net.minecraft.class_4836;
import net.minecraft.class_5134;

public class EntityHelper {
    public static final double ENTITY_GRAVITY = 0.08;

    public static boolean isAngryAtPlayer(PlayerEngineController mod, class_1297 mob) {
        boolean bl;
        boolean hostile = EntityHelper.isProbablyHostileToPlayer(mod, mob);
        if (!(mob instanceof class_1308)) {
            bl = hostile;
        } else {
            class_1308 entity = (class_1308)mob;
            bl = hostile && entity.method_5968() == mod.getPlayer();
        }
        return bl;
    }

    public static boolean isProbablyHostileToPlayer(PlayerEngineController mod, class_1297 entity) {
        if (entity instanceof class_1308) {
            boolean bl;
            class_1308 mob = (class_1308)entity;
            if (mob instanceof class_1621) {
                class_1621 slime = (class_1621)mob;
                return slime.method_45325(class_5134.field_23721) > 0.0;
            }
            if (mob instanceof class_4836) {
                class_4836 piglin = (class_4836)mob;
                return piglin.method_6510() && !EntityHelper.isTradingPiglin((class_1297)mob) && piglin.method_30236();
            }
            if (mob instanceof class_1560) {
                class_1560 enderman = (class_1560)mob;
                return enderman.method_7028();
            }
            if (mob instanceof class_1590) {
                class_1590 zombifiedPiglin = (class_1590)mob;
                bl = zombifiedPiglin.method_6510();
            } else {
                bl = mob.method_6510() || mob instanceof class_1588;
            }
            return bl;
        }
        return false;
    }

    public static boolean isTradingPiglin(class_1297 entity) {
        class_4836 pig;
        if (entity instanceof class_4836 && (pig = (class_4836)entity).method_5877() != null) {
            for (class_1799 stack : pig.method_5877()) {
                if (!stack.method_7909().equals(class_1802.field_8695)) continue;
                return true;
            }
        }
        return false;
    }

    public static double calculateResultingPlayerDamage(class_1309 player, class_1282 src, double damageAmount) {
        DamageSourceWrapper source = DamageSourceWrapper.of(src);
        if (player.method_5679(src)) {
            return 0.0;
        }
        if (!source.bypassesArmor()) {
            damageAmount = MethodWrapper.getDamageLeft(player, damageAmount, src, (double)player.method_6096(), player.method_45325(class_5134.field_23725));
        }
        if (!source.bypassesShield()) {
            float k;
            if (player.method_6059(class_1294.field_5907) && source.isOutOfWorld()) {
                k = (player.method_6112(class_1294.field_5907).method_5578() + 1) * 5;
                float j = 25.0f - k;
                double f = damageAmount * (double)j;
                damageAmount = Math.max(f / 25.0, 0.0);
            }
            if (damageAmount <= 0.0) {
                damageAmount = 0.0;
            } else {
                k = class_1890.method_8219((class_3218)((class_3218)player.method_37908()), (class_1309)player, (class_1282)src);
                if (k > 0.0f) {
                    damageAmount = class_1280.method_5497((float)((float)damageAmount), (float)k);
                }
            }
        }
        return Math.max(damageAmount - (double)player.method_6067(), 0.0);
    }
}

