/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util.helpers;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.utils.IEntityContext;
import com.player2.playerengine.automaton.api.utils.RayTraceUtils;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.RotationUtils;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1675;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public interface LookHelper {
    public static Optional<Rotation> getReach(PlayerEngineController controller, class_2338 target, class_2350 side) {
        Optional<Rotation> reachableRotation;
        IEntityContext context = controller.getBaritone().getEntityContext();
        if (side == null) {
            reachableRotation = RotationUtils.reachable(context.entity(), target, context.playerController().getBlockReachDistance());
        } else {
            class_243 cameraPos;
            class_243 vecToPlayerPos;
            double dotProduct;
            class_2382 sideVector = side.method_10163();
            class_243 centerOffset = new class_243(0.5 + (double)sideVector.method_10263() * 0.5, 0.5 + (double)sideVector.method_10264() * 0.5, 0.5 + (double)sideVector.method_10260() * 0.5);
            class_243 sidePoint = centerOffset.method_1031((double)target.method_10263(), (double)target.method_10264(), (double)target.method_10260());
            reachableRotation = RotationUtils.reachableOffset((class_1297)context.entity(), target, sidePoint, context.playerController().getBlockReachDistance(), false);
            if (reachableRotation.isPresent() && (dotProduct = (vecToPlayerPos = (cameraPos = context.entity().method_5836(1.0f)).method_1020(sidePoint)).method_1029().method_1026(new class_243((double)sideVector.method_10263(), (double)sideVector.method_10264(), (double)sideVector.method_10260()))) < 0.0) {
                return Optional.empty();
            }
        }
        return reachableRotation;
    }

    public static Optional<Rotation> getReach(PlayerEngineController controller, class_2338 target) {
        Debug.logInternal("Target: " + String.valueOf(target));
        return LookHelper.getReach(controller, target, null);
    }

    public static class_3966 raycast(class_1297 from, class_1297 to, double reachDistance) {
        class_243 start = LookHelper.getCameraPos(from);
        class_243 end = LookHelper.getCameraPos(to);
        class_243 direction = end.method_1020(start).method_1029().method_1021(reachDistance);
        class_238 box = to.method_5829();
        return class_1675.method_18075((class_1297)from, (class_243)start, (class_243)start.method_1019(direction), (class_238)box, entity -> entity.equals((Object)to), (double)0.0);
    }

    public static boolean seesPlayer(class_1297 entity, class_1297 player, double maxRange, class_243 entityOffset, class_243 playerOffset) {
        return LookHelper.seesPlayerOffset(entity, player, maxRange, entityOffset, playerOffset) || LookHelper.seesPlayerOffset(entity, player, maxRange, entityOffset, playerOffset.method_1031(0.0, -1.0, 0.0));
    }

    public static boolean seesPlayer(class_1297 entity, class_1297 player, double maxRange) {
        return LookHelper.seesPlayer(entity, player, maxRange, new class_243(0.0, 0.0, 0.0), new class_243(0.0, 0.0, 0.0));
    }

    public static boolean cleanLineOfSight(class_1297 entity, class_243 start, class_243 end, double maxRange) {
        class_3965 blockHitResult = LookHelper.raycast(entity, start, end, maxRange);
        return blockHitResult.method_17783() == class_239.class_240.field_1333;
    }

    public static boolean cleanLineOfSight(class_1297 entity, class_243 end, double maxRange) {
        class_243 start = LookHelper.getCameraPos(entity);
        return LookHelper.cleanLineOfSight(entity, start, end, maxRange);
    }

    public static boolean cleanLineOfSight(PlayerEngineController controller, class_243 end, double maxRange) {
        class_1309 clientPlayerEntity = controller.getPlayer();
        return LookHelper.cleanLineOfSight((class_1297)clientPlayerEntity, end, maxRange);
    }

    public static boolean cleanLineOfSight(class_1297 entity, class_2338 block, double maxRange) {
        class_243 targetPosition = WorldHelper.toVec3d(block);
        class_3965 hitResult = LookHelper.raycast(entity, LookHelper.getCameraPos(entity), targetPosition, maxRange);
        if (hitResult == null) {
            return true;
        }
        switch (hitResult.method_17783().ordinal()) {
            case 1: 
            case 2: 
            case 3: {
                return false;
            }
        }
        throw new IncompatibleClassChangeError();
    }

    public static class_243 toVec3d(Rotation rotation) throws NullPointerException {
        Objects.requireNonNull(rotation, "Rotation cannot be null");
        return LookHelper.calcLookDirectionFromRotation(rotation);
    }

    public static class_243 calcLookDirectionFromRotation(Rotation rotation) {
        float flatZ = class_3532.method_15362((float)(-rotation.getYaw() * ((float)Math.PI / 180) - (float)Math.PI));
        float flatX = class_3532.method_15374((float)(-rotation.getYaw() * ((float)Math.PI / 180) - (float)Math.PI));
        float pitchBase = -class_3532.method_15362((float)(-rotation.getPitch() * ((float)Math.PI / 180)));
        float pitchHeight = class_3532.method_15374((float)(-rotation.getPitch() * ((float)Math.PI / 180)));
        return new class_243((double)(flatX * pitchBase), (double)pitchHeight, (double)(flatZ * pitchBase));
    }

    public static class_3965 raycast(class_1297 entity, class_243 start, class_243 end, double maxRange) {
        class_243 direction = end.method_1020(start);
        if (direction.method_1027() > maxRange * maxRange) {
            direction = direction.method_1029().method_1021(maxRange);
            end = start.method_1019(direction);
        }
        class_1937 world = entity.method_37908();
        class_3959 context = new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, entity);
        return world.method_17742(context);
    }

    public static class_3965 raycast(class_1297 entity, class_243 end, double maxRange) {
        class_243 start = LookHelper.getCameraPos(entity);
        return LookHelper.raycast(entity, start, end, maxRange);
    }

    public static Rotation getLookRotation(class_1297 entity) {
        float pitch = entity.method_36455();
        float yaw = entity.method_36454();
        return new Rotation(yaw, pitch);
    }

    public static Rotation getLookRotation(PlayerEngineController mod) {
        class_1309 clientPlayerEntity = mod.getEntity();
        return clientPlayerEntity == null ? new Rotation(0.0f, 0.0f) : LookHelper.getLookRotation((class_1297)clientPlayerEntity);
    }

    public static class_243 getCameraPos(class_1297 entity) {
        boolean isPlayerSneaking = entity instanceof class_1309 && entity.method_5715();
        return isPlayerSneaking ? RayTraceUtils.inferSneakingEyePosition(entity) : entity.method_5836(1.0f);
    }

    public static class_243 getCameraPos(PlayerEngineController mod) {
        IEntityContext playerContext = mod.getBaritone().getEntityContext();
        return playerContext.entity().method_5836(1.0f);
    }

    public static double getLookCloseness(class_1297 entity, class_243 pos) {
        class_243 rotDirection = entity.method_5663();
        class_243 lookStart = LookHelper.getCameraPos(entity);
        class_243 deltaToPos = pos.method_1020(lookStart);
        class_243 deltaDirection = deltaToPos.method_1029();
        return rotDirection.method_1026(deltaDirection);
    }

    private static boolean seesPlayerOffset(class_1297 entity, class_1297 player, double maxRange, class_243 offsetEntity, class_243 offsetPlayer) {
        class_243 entityCameraPos = LookHelper.getCameraPos(entity).method_1019(offsetEntity);
        class_243 playerCameraPos = LookHelper.getCameraPos(player).method_1019(offsetPlayer);
        return LookHelper.cleanLineOfSight(entity, entityCameraPos, playerCameraPos, maxRange);
    }

    public static void randomOrientation(PlayerEngineController mod) {
        float randomRotationX = (float)(Math.random() * 360.0);
        float randomRotationY = -90.0f + (float)(Math.random() * 180.0);
        Rotation r = new Rotation(randomRotationX, randomRotationY);
        LookHelper.lookAt(mod, r);
    }

    public static boolean isLookingAt(PlayerEngineController mod, Rotation rotation) {
        return rotation.isReallyCloseTo(LookHelper.getLookRotation(mod));
    }

    public static boolean isLookingAt(PlayerEngineController mod, class_2338 pos) {
        return mod.getBaritone().getEntityContext().isLookingAt(pos);
    }

    public static boolean isLookingAt(class_1297 entity, class_243 toLookAt, double angleThreshold) {
        class_243 targetLook;
        class_243 head = entity.method_19538().method_1019(new class_243(0.0, (double)entity.method_5751(), 0.0));
        Rotation rotation = new Rotation(entity.method_36454(), entity.method_36455());
        class_243 look = LookHelper.calcLookDirectionFromRotation(rotation);
        double dot = look.method_1026(targetLook = toLookAt.method_1020(head).method_1029());
        double angle = Math.toDegrees(Math.acos(dot));
        return Math.abs(angle) < angleThreshold;
    }

    public static void lookAt(PlayerEngineController mod, Rotation rotation, boolean withBaritone) {
        if (withBaritone) {
            mod.getBaritone().getLookBehavior().updateTarget(rotation, true);
        }
        mod.getPlayer().method_36456(rotation.getYaw());
        mod.getPlayer().method_36457(rotation.getPitch());
    }

    public static void lookAt(PlayerEngineController mod, Rotation rotation) {
        mod.getBaritone().getLookBehavior().updateTarget(rotation, true);
        class_1309 player = mod.getBaritone().getEntityContext().entity();
        player.method_36456(rotation.getYaw());
        player.method_36457(rotation.getPitch());
    }

    public static void lookAt(PlayerEngineController mod, class_243 toLook, boolean withBaritone) {
        if (mod == null || toLook == null) {
            throw new IllegalArgumentException("mod and toLook cannot be null");
        }
        Rotation targetRotation = LookHelper.getLookRotation(mod, toLook);
        LookHelper.lookAt(mod, targetRotation, withBaritone);
    }

    public static void lookAt(PlayerEngineController mod, class_243 toLook) {
        if (mod == null || toLook == null) {
            throw new IllegalArgumentException("mod and toLook cannot be null");
        }
        Rotation targetRotation = LookHelper.getLookRotation(mod, toLook);
        LookHelper.lookAt(mod, targetRotation, true);
    }

    public static void lookAt(PlayerEngineController mod, class_2338 toLook, class_2350 side, boolean withBaritone) {
        double centerX = (double)toLook.method_10263() + 0.5;
        double centerY = (double)toLook.method_10264() + 0.5;
        double centerZ = (double)toLook.method_10260() + 0.5;
        if (side != null) {
            double offsetX = (double)side.method_10163().method_10263() * 0.5;
            double offsetY = (double)side.method_10163().method_10264() * 0.5;
            double offsetZ = (double)side.method_10163().method_10260() * 0.5;
            centerX += offsetX;
            centerY += offsetY;
            centerZ += offsetZ;
        }
        class_243 target = new class_243(centerX, centerY, centerZ);
        LookHelper.lookAt(mod, target, withBaritone);
    }

    public static void lookAt(PlayerEngineController mod, class_2338 toLook, class_2350 side) {
        double centerX = (double)toLook.method_10263() + 0.5;
        double centerY = (double)toLook.method_10264() + 0.5;
        double centerZ = (double)toLook.method_10260() + 0.5;
        if (side != null) {
            double offsetX = (double)side.method_10163().method_10263() * 0.5;
            double offsetY = (double)side.method_10163().method_10264() * 0.5;
            double offsetZ = (double)side.method_10163().method_10260() * 0.5;
            centerX += offsetX;
            centerY += offsetY;
            centerZ += offsetZ;
        }
        class_243 target = new class_243(centerX, centerY, centerZ);
        LookHelper.lookAt(mod, target, true);
    }

    public static void lookAt(PlayerEngineController mod, class_2338 toLook, boolean withBaritone) {
        LookHelper.lookAt(mod, toLook, null, withBaritone);
    }

    public static void lookAt(PlayerEngineController mod, class_2338 toLook) {
        LookHelper.lookAt(mod, toLook, null, true);
    }

    public static Rotation getLookRotation(PlayerEngineController mod, class_243 toLook) {
        class_243 playerHead = mod.getBaritone().getEntityContext().headPos();
        Rotation playerRotations = mod.getBaritone().getEntityContext().entityRotations();
        return RotationUtils.calcRotationFromVec3d(playerHead, toLook, playerRotations);
    }

    public static Rotation getLookRotation(PlayerEngineController mod, class_2338 toLook) {
        class_243 targetPosition = WorldHelper.toVec3d(toLook);
        return LookHelper.getLookRotation(mod, targetPosition);
    }
}

