/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util.helpers;

import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.baritone.CachedProjectile;
import net.minecraft.class_1297;
import net.minecraft.class_1668;
import net.minecraft.class_1676;
import net.minecraft.class_243;

public class ProjectileHelper {
    public static final double ARROW_GRAVITY_ACCEL = (double)0.05f;
    public static final double THROWN_ENTITY_GRAVITY_ACCEL = 0.03;

    public static boolean hasGravity(class_1676 entity) {
        return entity instanceof class_1668 ? false : !entity.method_5740();
    }

    private static class_243 getClosestPointOnFlatLine(double shootX, double shootZ, double velX, double velZ, double playerX, double playerZ) {
        double deltaX = playerX - shootX;
        double deltaZ = playerZ - shootZ;
        double t = (velX * deltaX + velZ * deltaZ) / (velX * velX + velZ * velZ);
        double hitX = shootX + velX * t;
        double hitZ = shootZ + velZ * t;
        return new class_243(hitX, 0.0, hitZ);
    }

    public static double getFlatDistanceSqr(double shootX, double shootZ, double velX, double velZ, double playerX, double playerZ) {
        return ProjectileHelper.getClosestPointOnFlatLine(shootX, shootZ, velX, velZ, playerX, playerZ).method_1028(playerX, 0.0, playerZ);
    }

    private static double getArrowHitHeight(double gravity, double horizontalVel, double verticalVel, double initialHeight, double distanceTraveled) {
        double time = distanceTraveled / horizontalVel;
        return initialHeight - verticalVel * time - 0.5 * gravity * time * time;
    }

    public static class_243 calculateArrowClosestApproach(class_243 shootOrigin, class_243 shootVelocity, double yGravity, class_243 playerOrigin) {
        class_243 flatEncounter = ProjectileHelper.getClosestPointOnFlatLine(shootOrigin.field_1352, shootOrigin.field_1350, shootVelocity.field_1352, shootVelocity.field_1350, playerOrigin.field_1352, playerOrigin.field_1350);
        double encounterDistanceTraveled = flatEncounter.method_1023(shootOrigin.field_1352, flatEncounter.field_1351, shootOrigin.field_1350).method_1033();
        double horizontalVel = Math.sqrt(shootVelocity.field_1352 * shootVelocity.field_1352 + shootVelocity.field_1350 * shootVelocity.field_1350);
        double verticalVel = shootVelocity.field_1351;
        double initialHeight = shootOrigin.field_1351;
        double hitHeight = ProjectileHelper.getArrowHitHeight(yGravity, horizontalVel, verticalVel, initialHeight, encounterDistanceTraveled);
        return new class_243(flatEncounter.field_1352, hitHeight, flatEncounter.field_1350);
    }

    public static class_243 calculateArrowClosestApproach(CachedProjectile projectile, class_243 pos) {
        return ProjectileHelper.calculateArrowClosestApproach(projectile.position, projectile.velocity, projectile.gravity, pos);
    }

    public static double[] calculateAnglesForSimpleProjectileMotion(double launchHeight, double launchTargetDistance, double launchVelocity, double gravity) {
        double y = -1.0 * launchHeight;
        double root = launchVelocity * launchVelocity * launchVelocity * launchVelocity - gravity * (gravity * launchTargetDistance * launchTargetDistance + 2.0 * y * launchVelocity * launchVelocity);
        if (root < 0.0) {
            Debug.logMessage("Not enough velocity, returning 45 degrees.");
            return new double[]{45.0, 45.0};
        }
        double tanTheta0 = (launchVelocity * launchVelocity + Math.sqrt(root)) / gravity * launchTargetDistance;
        double tanTheta1 = (launchVelocity * launchVelocity - Math.sqrt(root)) / gravity * launchTargetDistance;
        double[] angles = new double[]{Math.toDegrees(Math.atan(tanTheta0)), Math.toDegrees(Math.atan(tanTheta1))};
        return new double[]{Math.min(angles[0], angles[1]), Math.max(angles[0], angles[1])};
    }

    public static class_243 getThrowOrigin(class_1297 entity) {
        return entity.method_19538().method_1023(0.0, 0.1, 0.0);
    }

    @Deprecated
    private static double getNearestTimeOfShotProjectile(class_243 shootOrigin, class_243 shootVelocity, double yGravity, class_243 playerOrigin) {
        double r;
        double d;
        class_243 D = playerOrigin.method_1020(shootOrigin);
        double b = -(3.0 * yGravity * shootVelocity.field_1351) / 2.0;
        double a = yGravity * yGravity / 2.0;
        double p = -b / 3.0 * a;
        double c = shootVelocity.method_1027() + yGravity * shootVelocity.field_1351;
        double q = p * p * p + (b * c - 3.0 * a * (d = -1.0 * shootVelocity.method_1026(D))) / 6.0 * a * a;
        double rootInner = q * q + Math.pow((r = c / 3.0 * a) - p * p, 3.0);
        if (rootInner < 0.0) {
            return -1.0;
        }
        rootInner = Math.sqrt(rootInner);
        double outerPreCubeLeft = q + rootInner;
        double outerPreCubeRight = q - rootInner;
        return Math.pow(outerPreCubeLeft, 0.3333333333333333) + Math.pow(outerPreCubeRight, 0.3333333333333333) + p;
    }
}

