/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine;

import com.player2.playerengine.MCCommands;
import com.player2.playerengine.automaton.KeepName;
import com.player2.playerengine.automaton.command.defaults.DefaultCommands;
import com.player2.playerengine.automaton.entity.CustomFishingBobberEntity;
import com.player2.playerengine.player2api.AgentSideEffects;
import com.player2.playerengine.player2api.Event;
import com.player2.playerengine.player2api.auth.TokenStorage;
import com.player2.playerengine.player2api.manager.ConversationManager;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import io.netty.buffer.Unpooled;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@KeepName
public final class PlayerEngine {
    public static final Logger LOGGER = LogManager.getLogger((String)"PlayerEngine");
    public static final String MOD_ID = "playerengine";
    public static final String MOD_NAME = "PlayerEngine";
    public static final TagKey<Item> EMPTY_BUCKETS = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)PlayerEngine.id("empty_buckets"));
    public static final TagKey<Item> WATER_BUCKETS = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)PlayerEngine.id("water_buckets"));
    private static final ThreadPoolExecutor threadPool;
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES;
    public static RegistrySupplier<EntityType<CustomFishingBobberEntity>> FISHING_BOBBER;

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static ThreadPoolExecutor getExecutor() {
        return threadPool;
    }

    public static void onInitialize() {
        DefaultCommands.registerAll();
        ENTITY_TYPES.register();
        MCCommands.onInit();
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)new ResourceLocation(MOD_ID, "user_message"), (buf, context) -> {
            LOGGER.info("Server: Recieved user_message packet");
            String username = context.getPlayer().m_7755_().getString();
            String message = buf.m_130277_();
            ConversationManager.onUserChatMessage(new Event.UserMessage(message, username));
            AgentSideEffects.broadcastChatToAllPlayers(context.getPlayer().m_20194_(), String.format("<%s> %s", context.getPlayer().m_7755_().getString(), message));
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)new ResourceLocation(MOD_ID, "request_stt"), (buf, context) -> {
            LOGGER.info("Server: Recieved request_stt packet");
            String clientId = buf.m_130277_();
            String username = context.getPlayer().m_7755_().getString();
            String storedToken = TokenStorage.getToken(username, clientId);
            FriendlyByteBuf buf2 = new FriendlyByteBuf(Unpooled.buffer());
            buf2.m_130070_(storedToken);
            LOGGER.info("Server: Sending response_stt packet w/ token {}", (Object)storedToken);
            ((ServerPlayer)context.getPlayer()).f_8906_.m_9829_(NetworkManager.toPacket((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)new ResourceLocation(MOD_ID, "response_stt"), (FriendlyByteBuf)buf2));
        });
    }

    static {
        ENTITY_TYPES = DeferredRegister.create((String)MOD_ID, (ResourceKey)Registries.f_256939_);
        FISHING_BOBBER = ENTITY_TYPES.register("custom_fishing_bobber", () -> EntityType.Builder.m_20704_(CustomFishingBobberEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(EntityType.f_20533_.m_20678_(), EntityType.f_20533_.m_20679_()).m_20702_(64).m_20717_(1).m_20712_("custom_fishing_bobber"));
        AtomicInteger threadCounter = new AtomicInteger(0);
        threadPool = new ThreadPoolExecutor(4, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), r -> new Thread(r, "PlayerEngine Worker " + threadCounter.incrementAndGet()));
    }
}

