/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class AdditionalBaritoneSettings {
    private final Object breakMutex = new Object();
    private final Object placeMutex = new Object();
    private final Object propertiesMutex = new Object();
    private final Object globalHeuristicMutex = new Object();
    private final HashSet<BlockPos> blocksToAvoidBreaking = new HashSet();
    private final List<Predicate<BlockPos>> breakAvoiders = new ArrayList<Predicate<BlockPos>>();
    private final List<Predicate<BlockPos>> placeAvoiders = new ArrayList<Predicate<BlockPos>>();
    private final List<Predicate<BlockPos>> forceCanWalkOn = new ArrayList<Predicate<BlockPos>>();
    private final List<Predicate<BlockPos>> forceAvoidWalkThrough = new ArrayList<Predicate<BlockPos>>();
    private final List<BiPredicate<BlockState, ItemStack>> forceSaveTool = new ArrayList<BiPredicate<BlockState, ItemStack>>();
    private final List<BiPredicate<BlockState, ItemStack>> forceUseTool = new ArrayList<BiPredicate<BlockState, ItemStack>>();
    private final List<BiFunction<Double, BlockPos, Double>> globalHeuristics = new ArrayList<BiFunction<Double, BlockPos, Double>>();
    private final HashSet<Item> protectedItems = new HashSet();
    private boolean allowFlowingWaterPass;
    private boolean pauseInteractions;
    private boolean dontPlaceBucketButStillFall;
    private boolean allowSwimThroughLava = false;
    private boolean treatSoulSandAsOrdinaryBlock = false;
    private boolean canWalkOnEndPortal = false;

    public void canWalkOnEndPortal(boolean canWalk) {
        this.canWalkOnEndPortal = canWalk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void avoidBlockBreak(BlockPos pos) {
        Object object = this.breakMutex;
        synchronized (object) {
            this.blocksToAvoidBreaking.add(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void avoidBlockBreak(Predicate<BlockPos> avoider) {
        Object object = this.breakMutex;
        synchronized (object) {
            this.breakAvoiders.add(avoider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurePlaceBucketButDontFall(boolean allow) {
        Object object = this.propertiesMutex;
        synchronized (object) {
            this.dontPlaceBucketButStillFall = allow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void treatSoulSandAsOrdinaryBlock(boolean enable) {
        Object object = this.propertiesMutex;
        synchronized (object) {
            this.treatSoulSandAsOrdinaryBlock = enable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void avoidBlockPlace(Predicate<BlockPos> avoider) {
        Object object = this.placeMutex;
        synchronized (object) {
            this.placeAvoiders.add(avoider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldForceSaveTool(BlockState state, ItemStack tool) {
        Object object = this.propertiesMutex;
        synchronized (object) {
            return this.forceSaveTool.stream().anyMatch(pred -> pred.test(state, tool));
        }
    }

    public boolean shouldAvoidBreaking(int x, int y, int z) {
        return this.shouldAvoidBreaking(new BlockPos(x, y, z));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldAvoidBreaking(BlockPos pos) {
        Object object = this.breakMutex;
        synchronized (object) {
            return this.blocksToAvoidBreaking.contains(pos) ? true : this.breakAvoiders.stream().anyMatch(pred -> pred.test(pos));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldAvoidPlacingAt(BlockPos pos) {
        Object object = this.placeMutex;
        synchronized (object) {
            return this.placeAvoiders.stream().anyMatch(pred -> pred.test(pos));
        }
    }

    public boolean shouldAvoidPlacingAt(int x, int y, int z) {
        return this.shouldAvoidPlacingAt(new BlockPos(x, y, z));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canWalkOnForce(int x, int y, int z) {
        Object object = this.propertiesMutex;
        synchronized (object) {
            return this.forceCanWalkOn.stream().anyMatch(pred -> pred.test(new BlockPos(x, y, z)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldAvoidWalkThroughForce(BlockPos pos) {
        Object object = this.propertiesMutex;
        synchronized (object) {
            return this.forceAvoidWalkThrough.stream().anyMatch(pred -> pred.test(pos));
        }
    }

    public boolean shouldAvoidWalkThroughForce(int x, int y, int z) {
        return this.shouldAvoidWalkThroughForce(new BlockPos(x, y, z));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldForceUseTool(BlockState state, ItemStack tool) {
        Object object = this.propertiesMutex;
        synchronized (object) {
            return this.forceUseTool.stream().anyMatch(pred -> pred.test(state, tool));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldNotPlaceBucketButStillFall() {
        Object object = this.propertiesMutex;
        synchronized (object) {
            return this.dontPlaceBucketButStillFall;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldTreatSoulSandAsOrdinaryBlock() {
        Object object = this.propertiesMutex;
        synchronized (object) {
            return this.treatSoulSandAsOrdinaryBlock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInteractionPaused() {
        Object object = this.propertiesMutex;
        synchronized (object) {
            return this.pauseInteractions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInteractionPaused(boolean paused) {
        Object object = this.propertiesMutex;
        synchronized (object) {
            this.pauseInteractions = paused;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFlowingWaterPassAllowed() {
        Object object = this.propertiesMutex;
        synchronized (object) {
            return this.allowFlowingWaterPass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canSwimThroughLava() {
        Object object = this.propertiesMutex;
        synchronized (object) {
            return this.allowSwimThroughLava;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlowingWaterPass(boolean pass) {
        Object object = this.propertiesMutex;
        synchronized (object) {
            this.allowFlowingWaterPass = pass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allowSwimThroughLava(boolean allow) {
        Object object = this.propertiesMutex;
        synchronized (object) {
            this.allowSwimThroughLava = allow;
        }
    }

    public double applyGlobalHeuristic(double prev, int x, int y, int z) {
        return prev;
    }

    public HashSet<BlockPos> getBlocksToAvoidBreaking() {
        return this.blocksToAvoidBreaking;
    }

    public List<Predicate<BlockPos>> getBreakAvoiders() {
        return this.breakAvoiders;
    }

    public List<Predicate<BlockPos>> getPlaceAvoiders() {
        return this.placeAvoiders;
    }

    public List<Predicate<BlockPos>> getForceWalkOnPredicates() {
        return this.forceCanWalkOn;
    }

    public List<Predicate<BlockPos>> getForceAvoidWalkThroughPredicates() {
        return this.forceAvoidWalkThrough;
    }

    public List<BiPredicate<BlockState, ItemStack>> getForceSaveToolPredicates() {
        return this.forceSaveTool;
    }

    public List<BiPredicate<BlockState, ItemStack>> getForceUseToolPredicates() {
        return this.forceUseTool;
    }

    public List<BiFunction<Double, BlockPos, Double>> getGlobalHeuristics() {
        return this.globalHeuristics;
    }

    public boolean isItemProtected(Item item) {
        return this.protectedItems.contains(item);
    }

    public HashSet<Item> getProtectedItems() {
        return this.protectedItems;
    }

    public void protectItem(Item item) {
        this.protectedItems.add(item);
    }

    public void stopProtectingItem(Item item) {
        this.protectedItems.remove(item);
    }

    public Object getBreakMutex() {
        return this.breakMutex;
    }

    public Object getPlaceMutex() {
        return this.placeMutex;
    }

    public Object getPropertiesMutex() {
        return this.propertiesMutex;
    }

    public Object getGlobalHeuristicMutex() {
        return this.globalHeuristicMutex;
    }

    public boolean isCanWalkOnEndPortal() {
        return this.canWalkOnEndPortal;
    }
}

