/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.entity;

import com.mojang.logging.LogUtils;
import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.utils.IBucketAccessor;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class LivingEntityInteractionManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected Level world;
    protected final LivingEntity livingEntity;
    private GameType gameMode = GameType.SURVIVAL;
    @Nullable
    private GameType previousGameMode;
    private boolean mining;
    private int startMiningTime;
    private BlockPos miningPos = BlockPos.f_121853_;
    private int tickCounter;
    private boolean failedToMine;
    private BlockPos failedMiningPos = BlockPos.f_121853_;
    private int failedStartMiningTime;
    private int blockBreakingProgress = -1;
    private boolean brokeBlock;

    public LivingEntityInteractionManager(LivingEntity livingEntity) {
        this.livingEntity = livingEntity;
        this.world = livingEntity.m_9236_();
    }

    public GameType getGameMode() {
        return this.gameMode;
    }

    @Nullable
    public GameType getPreviousGameMode() {
        return this.previousGameMode;
    }

    public boolean isSurvivalLike() {
        return this.gameMode.m_46409_();
    }

    public boolean isCreative() {
        return this.gameMode.m_46408_();
    }

    public void update() {
        ++this.tickCounter;
        if (this.failedToMine) {
            BlockState blockState = this.world.m_8055_(this.failedMiningPos);
            if (blockState.m_60795_()) {
                this.failedToMine = false;
            } else {
                float f = this.continueMining(blockState, this.failedMiningPos, this.failedStartMiningTime);
                if (f >= 1.0f) {
                    this.failedToMine = false;
                    this.tryBreakBlock(this.failedMiningPos);
                }
            }
        } else if (this.mining) {
            BlockState blockState = this.world.m_8055_(this.miningPos);
            if (blockState.m_60795_()) {
                this.world.m_6801_(this.livingEntity.m_19879_(), this.miningPos, -1);
                this.blockBreakingProgress = -1;
                this.mining = false;
            } else {
                this.continueMining(blockState, this.miningPos, this.startMiningTime);
            }
        }
    }

    private float continueMining(BlockState state, BlockPos pos, int progress) {
        int i = this.tickCounter - progress;
        float f = this.calcBlockBreakingDelta(state, this.livingEntity, (BlockGetter)this.livingEntity.m_9236_(), pos) * (float)(i + 1);
        int j = (int)(f * 10.0f);
        if (j != this.blockBreakingProgress) {
            this.world.m_6801_(this.livingEntity.m_19879_(), pos, j);
            this.blockBreakingProgress = j;
        }
        return f;
    }

    private void method_41250(BlockPos pos, boolean bl, int i, String string) {
    }

    public void processBlockBreakingAction(BlockPos pos, ServerboundPlayerActionPacket.Action action, Direction direction, int worldHeight, int i) {
        if (this.livingEntity.m_146892_().m_82557_(Vec3.m_82512_((Vec3i)pos)) > ServerGamePacketListenerImpl.f_215198_) {
            this.method_41250(pos, false, i, "too far");
        } else if (pos.m_123342_() >= worldHeight) {
            this.method_41250(pos, false, i, "too high");
        } else if (action == ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK) {
            if (this.isCreative()) {
                this.finishMining(pos, i, "creative destroy");
                return;
            }
            this.startMiningTime = this.tickCounter;
            float f = 1.0f;
            BlockState blockState = this.world.m_8055_(pos);
            if (!blockState.m_60795_()) {
                f = this.calcBlockBreakingDelta(blockState, this.livingEntity, (BlockGetter)this.livingEntity.m_9236_(), pos);
            }
            if (!blockState.m_60795_() && f >= 1.0f) {
                this.finishMining(pos, i, "insta mine");
            } else {
                if (this.mining) {
                    this.method_41250(pos, false, i, "abort destroying since another started (client insta mine, server disagreed)");
                }
                this.mining = true;
                this.miningPos = pos.m_7949_();
                this.brokeBlock = true;
                int j = (int)(f * 10.0f);
                this.world.m_6801_(this.livingEntity.m_19879_(), pos, j);
                this.method_41250(pos, true, i, "actual start of destroying");
                this.blockBreakingProgress = j;
            }
        } else if (action == ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK) {
            if (pos.equals((Object)this.miningPos)) {
                int k = this.tickCounter - this.startMiningTime;
                BlockState blockStatex = this.world.m_8055_(pos);
                if (!blockStatex.m_60795_()) {
                    float g = this.calcBlockBreakingDelta(blockStatex, this.livingEntity, (BlockGetter)this.livingEntity.m_9236_(), pos) * (float)(k + 1);
                    if (g >= 0.7f) {
                        this.mining = false;
                        this.world.m_6801_(this.livingEntity.m_19879_(), pos, -1);
                        this.finishMining(pos, i, "destroyed");
                        return;
                    }
                    if (!this.failedToMine) {
                        this.mining = false;
                        this.failedToMine = true;
                        this.failedMiningPos = pos;
                        this.failedStartMiningTime = this.startMiningTime;
                    }
                }
            }
            this.method_41250(pos, true, i, "stopped destroying");
        } else if (action == ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK) {
            this.mining = false;
            if (!Objects.equals(this.miningPos, pos)) {
                LOGGER.warn("Mismatch in destroy block pos: {} {}", (Object)this.miningPos, (Object)pos);
                this.world.m_6801_(this.livingEntity.m_19879_(), this.miningPos, -1);
                this.method_41250(pos, true, i, "aborted mismatched destroying");
            }
            this.world.m_6801_(this.livingEntity.m_19879_(), pos, -1);
            this.method_41250(pos, true, i, "aborted destroying");
        }
    }

    public float calcBlockBreakingDelta(BlockState state, LivingEntity player, BlockGetter world, BlockPos pos) {
        float f = state.m_60800_(world, pos);
        if (f == -1.0f) {
            return 0.0f;
        }
        int i = this.canHarvest(state, player.m_21120_(InteractionHand.MAIN_HAND)) ? 30 : 100;
        return this.getBlockBreakingSpeed(player, state) / f / (float)i;
    }

    public boolean canHarvest(BlockState state, ItemStack heldItem) {
        return !state.m_60834_() || heldItem.m_41735_(state);
    }

    public float getBlockBreakingSpeed(LivingEntity entity, BlockState block) {
        float f = this.livingEntity.m_21120_(InteractionHand.MAIN_HAND).m_41691_(block);
        if (f > 1.0f) {
            int i = EnchantmentHelper.m_44926_((LivingEntity)entity);
            ItemStack itemStack = this.livingEntity.m_21120_(InteractionHand.MAIN_HAND);
            if (i > 0 && !itemStack.m_41619_()) {
                f += (float)(i * i + 1);
            }
        }
        if (MobEffectUtil.m_19584_((LivingEntity)entity)) {
            f *= 1.0f + (float)(MobEffectUtil.m_19586_((LivingEntity)entity) + 1) * 0.2f;
        }
        if (entity.m_21023_(MobEffects.f_19599_)) {
            f *= (switch (entity.m_21124_(MobEffects.f_19599_).m_19564_()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            });
        }
        if (entity.m_204029_(FluidTags.f_13131_) && !EnchantmentHelper.m_44934_((LivingEntity)entity)) {
            f /= 5.0f;
        }
        if (!entity.m_20096_()) {
            f /= 5.0f;
        }
        return f;
    }

    public void finishMining(BlockPos pos, int i, String reason) {
        if (this.tryBreakBlock(pos)) {
            this.method_41250(pos, true, i, reason);
        } else {
            this.method_41250(pos, false, i, reason);
        }
    }

    public boolean tryBreakBlock(BlockPos pos) {
        BlockState blockState = this.world.m_8055_(pos);
        BlockEntity blockEntity = this.world.m_7702_(pos);
        Block block = blockState.m_60734_();
        if (block instanceof GameMasterBlock) {
            this.world.m_7260_(pos, blockState, blockState, 3);
            return false;
        }
        this.world.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223719_((Entity)this.livingEntity, (BlockState)blockState));
        boolean bl = this.world.m_7471_(pos, false);
        if (bl) {
            block.m_6786_((LevelAccessor)this.world, pos, blockState);
        }
        if (this.isCreative()) {
            return true;
        }
        ItemStack itemStack = this.livingEntity.m_21205_();
        ItemStack itemStack2 = itemStack.m_41777_();
        boolean bl2 = true;
        itemStack.m_41720_().m_6813_(itemStack, this.world, blockState, pos, this.livingEntity);
        if (bl && bl2) {
            Block.m_49881_((BlockState)blockState, (Level)this.world, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)this.livingEntity, (ItemStack)itemStack2);
        }
        return true;
    }

    public InteractionResult interactItem(LivingEntity player, Level world, ItemStack stack, InteractionHand hand) {
        if (this.gameMode == GameType.SPECTATOR) {
            return InteractionResult.PASS;
        }
        int i = stack.m_41613_();
        int j = stack.m_41773_();
        try {
            InteractionResultHolder<ItemStack> typedActionResult;
            Item item = stack.m_41720_();
            if (item instanceof BucketItem) {
                BucketItem bucketItem = (BucketItem)item;
                typedActionResult = this.useBucket(bucketItem, world, player, hand);
            } else {
                typedActionResult = stack.m_41682_(world, null, hand);
            }
            ItemStack itemStack = (ItemStack)typedActionResult.m_19095_();
            if (itemStack == stack && itemStack.m_41613_() == i && itemStack.m_41779_() <= 0 && itemStack.m_41773_() == j) {
                return typedActionResult.m_19089_();
            }
            if (typedActionResult.m_19089_() == InteractionResult.FAIL && itemStack.m_41779_() > 0 && !player.m_6117_()) {
                return typedActionResult.m_19089_();
            }
            if (stack != itemStack) {
                player.m_21008_(hand, itemStack);
            }
            if (this.isCreative() && itemStack != ItemStack.f_41583_) {
                itemStack.m_41764_(i);
                if (itemStack.m_41763_() && itemStack.m_41773_() != j) {
                    itemStack.m_41721_(j);
                }
            }
            if (itemStack.m_41619_()) {
                player.m_21008_(hand, ItemStack.f_41583_);
            }
            return typedActionResult.m_19089_();
        }
        catch (Exception var10) {
            return InteractionResult.PASS;
        }
    }

    public InteractionResultHolder<ItemStack> useBucket(BucketItem bucket, Level world, LivingEntity user, InteractionHand hand) {
        BlockPos blockPos3;
        ItemStack itemStack = user.m_21120_(hand);
        BlockHitResult blockHitResult = LivingEntityInteractionManager.raycast(world, user, ((IBucketAccessor)bucket).getFluid() == Fluids.f_76191_ ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE);
        if (blockHitResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (blockHitResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        BlockPos blockPos = blockHitResult.m_82425_();
        Direction direction = blockHitResult.m_82434_();
        BlockPos blockPos2 = blockPos.m_121945_(direction);
        if (((IBucketAccessor)bucket).getFluid() == Fluids.f_76191_) {
            BucketPickup fluidDrainable;
            ItemStack itemStack2;
            BlockState blockState = world.m_8055_(blockPos);
            if (blockState.m_60734_() instanceof BucketPickup && !(itemStack2 = (fluidDrainable = (BucketPickup)blockState.m_60734_()).m_142598_((LevelAccessor)world, blockPos, blockState)).m_41619_()) {
                fluidDrainable.m_142298_().ifPresent(sound -> user.m_5496_(sound, 1.0f, 1.0f));
                world.m_142346_((Entity)user, GameEvent.f_157816_, blockPos);
                ItemStack itemStack3 = LivingEntityInteractionManager.exchangeStack(itemStack, user, itemStack2);
                return InteractionResultHolder.m_19092_((Object)itemStack3, (boolean)world.m_5776_());
            }
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        BlockState blockState = world.m_8055_(blockPos);
        BlockPos blockPos4 = blockPos3 = blockState.m_60734_() instanceof LiquidBlockContainer && ((IBucketAccessor)bucket).getFluid() == Fluids.f_76193_ ? blockPos : blockPos2;
        if (bucket.m_142073_(null, world, blockPos3, blockHitResult)) {
            bucket.m_142131_(null, world, itemStack, blockPos3);
            return InteractionResultHolder.m_19092_((Object)new ItemStack((ItemLike)Items.f_42446_), (boolean)world.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    public boolean canPlaceOn(LivingEntity entity, BlockPos pos, Direction facing, ItemStack stack) {
        BlockPos blockPos = pos.m_121945_(facing.m_122424_());
        BlockInWorld cachedBlockPosition = new BlockInWorld((LevelReader)entity.m_9236_(), blockPos, false);
        return stack.m_204121_(entity.m_9236_().m_9598_().m_175515_(Registries.f_256747_), cachedBlockPosition);
    }

    protected static BlockHitResult raycast(Level world, LivingEntity player, ClipContext.Fluid fluidHandling) {
        float f = player.m_146909_();
        float g = player.m_146908_();
        Vec3 vec3d = player.m_146892_();
        float h = Mth.m_14089_((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float i = Mth.m_14031_((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float j = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float k = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float l = i * j;
        float n = h * j;
        double d = 5.0;
        Vec3 vec3d2 = vec3d.m_82520_((double)l * 5.0, (double)k * 5.0, (double)n * 5.0);
        return world.m_45547_(new ClipContext(vec3d, vec3d2, ClipContext.Block.OUTLINE, fluidHandling, (Entity)player));
    }

    public static ItemStack exchangeStack(ItemStack inputStack, LivingEntity player, ItemStack outputStack) {
        inputStack.m_41774_(1);
        if (inputStack.m_41619_()) {
            return outputStack;
        }
        if (!((IInventoryProvider)player).getLivingInventory().insertStack(outputStack)) {
            player.m_19983_(outputStack);
        }
        return inputStack;
    }

    public boolean shouldCancelInteraction() {
        return false;
    }

    public InteractionResult interactBlock(LivingEntity player, Level world, ItemStack stack, InteractionHand hand, BlockHitResult hitResult) {
        BlockPos blockPos = hitResult.m_82425_();
        BlockState blockState = world.m_8055_(blockPos);
        if (!blockState.m_60734_().m_245993_(world.m_246046_())) {
            return InteractionResult.FAIL;
        }
        boolean bl = !player.m_21205_().m_41619_() || !player.m_21206_().m_41619_();
        boolean bl2 = this.shouldCancelInteraction() && bl;
        ItemStack itemStack = stack.m_41777_();
        if (!bl2) {
            try {
                InteractionResult actionResult = blockState.m_60664_(world, null, hand, hitResult);
                if (actionResult.m_19077_()) {
                    return actionResult;
                }
            }
            catch (NullPointerException actionResult) {
                // empty catch block
            }
        }
        if (!stack.m_41619_()) {
            InteractionResult actionResult2;
            UseOnContext itemUsageContext = new UseOnContext(player.m_9236_(), null, hand, player.m_21120_(hand), hitResult){

                public boolean m_7078_() {
                    return this.m_7078_();
                }
            };
            if (this.isCreative()) {
                int i = stack.m_41613_();
                actionResult2 = stack.m_41661_(itemUsageContext);
                stack.m_41764_(i);
            } else {
                actionResult2 = stack.m_41661_(itemUsageContext);
            }
            return actionResult2;
        }
        return InteractionResult.PASS;
    }

    public void setWorld(ServerLevel world) {
        this.world = world;
    }

    public boolean isMining() {
        return this.mining;
    }

    public BlockPos getMiningPos() {
        return this.miningPos;
    }

    public int getBlockBreakingProgress() {
        return this.blockBreakingProgress;
    }

    public boolean hasBrokenBlock() {
        return this.brokeBlock;
    }
}

