/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.utils;

import com.player2.playerengine.automaton.api.BaritoneAPI;
import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.cache.IWorldData;
import com.player2.playerengine.automaton.api.entity.LivingEntityHungerManager;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.automaton.api.pathing.calc.Avoidance;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.api.utils.IInteractionController;
import com.player2.playerengine.automaton.api.utils.Rotation;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface IEntityContext {
    public LivingEntity entity();

    default public IBaritone baritone() {
        return IBaritone.KEY.get(this.entity());
    }

    @Nullable
    public LivingEntityInventory inventory();

    @Nullable
    public LivingEntityHungerManager hungerManager();

    public IInteractionController playerController();

    public ServerLevel world();

    default public Iterable<Entity> worldEntities() {
        return this.world().m_8583_();
    }

    default public Stream<Entity> worldEntitiesStream() {
        return StreamSupport.stream(this.worldEntities().spliterator(), false);
    }

    public void setAvoidanceFinder(@Nullable Supplier<List<Avoidance>> var1);

    public List<Avoidance> listAvoidedAreas();

    public IWorldData worldData();

    public HitResult objectMouseOver();

    public BetterBlockPos feetPos();

    default public Vec3 feetPosAsVec() {
        return new Vec3(this.entity().m_20185_(), this.entity().m_20186_(), this.entity().m_20189_());
    }

    default public Vec3 headPos() {
        return new Vec3(this.entity().m_20185_(), this.entity().m_20186_() + (double)this.entity().m_20192_(), this.entity().m_20189_());
    }

    default public Rotation entityRotations() {
        return new Rotation(this.entity().m_146908_(), this.entity().m_146909_());
    }

    default public Optional<BlockPos> getSelectedBlock() {
        HitResult result = this.objectMouseOver();
        return result != null && result.m_6662_() == HitResult.Type.BLOCK ? Optional.of(((BlockHitResult)result).m_82425_()) : Optional.empty();
    }

    default public boolean isLookingAt(BlockPos pos) {
        return this.getSelectedBlock().equals(Optional.of(pos));
    }

    default public void logDebug(String message) {
        if (BaritoneAPI.getGlobalSettings().chatDebug.get().booleanValue()) {
            LivingEntity entity = this.entity();
            if (entity instanceof Player) {
                ((Player)entity).m_5661_((Component)Component.m_237113_((String)message).m_130940_(ChatFormatting.GRAY), false);
            }
            if (BaritoneAPI.getGlobalSettings().syncWithOps.get().booleanValue()) {
                MinecraftServer server = this.world().m_7654_();
                for (ServerPlayer p : server.m_6846_().m_11314_()) {
                    if (!server.m_6846_().m_11303_(p.m_36316_())) continue;
                    IBaritone.KEY.get(p).logDirect(message);
                }
            }
        }
    }
}

