/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.cache;

import com.player2.playerengine.automaton.api.cache.IWaypoint;
import com.player2.playerengine.automaton.api.cache.IWaypointCollection;
import com.player2.playerengine.automaton.api.cache.Waypoint;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;

public class WaypointCollection
implements IWaypointCollection {
    private final Map<IWaypoint.Tag, Set<IWaypoint>> waypoints = new EnumMap(Arrays.stream(IWaypoint.Tag.values()).collect(Collectors.toMap(Function.identity(), t -> new HashSet())));

    WaypointCollection() {
    }

    public void readFromNbt(CompoundTag nbt) {
        for (IWaypoint.Tag tag : IWaypoint.Tag.values()) {
            this.waypoints.put(tag, this.readFromNbt(tag, nbt.m_128437_(tag.name(), 10)));
        }
    }

    private synchronized Set<IWaypoint> readFromNbt(IWaypoint.Tag tag, ListTag nbt) {
        HashSet<IWaypoint> ret = new HashSet<IWaypoint>();
        for (int i = 0; i < nbt.size(); ++i) {
            CompoundTag in = nbt.m_128728_(i);
            String name = in.m_128461_("name");
            long creationTimestamp = in.m_128454_("created");
            BetterBlockPos pos = new BetterBlockPos(NbtUtils.m_129239_((CompoundTag)in.m_128469_("pos")));
            ret.add(new Waypoint(name, tag, pos, creationTimestamp));
        }
        return ret;
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        for (IWaypoint.Tag waypointTag : IWaypoint.Tag.values()) {
            nbt.m_128365_(waypointTag.name(), (Tag)this.save(waypointTag));
        }
        return nbt;
    }

    private synchronized ListTag save(IWaypoint.Tag waypointTag) {
        ListTag list = new ListTag();
        for (IWaypoint waypoint : this.waypoints.get((Object)waypointTag)) {
            CompoundTag serializedWaypoint = new CompoundTag();
            serializedWaypoint.m_128359_("name", waypoint.getName());
            serializedWaypoint.m_128356_("created", waypoint.getCreationTimestamp());
            serializedWaypoint.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)waypoint.getLocation()));
            list.add((Object)serializedWaypoint);
        }
        return list;
    }

    @Override
    public void addWaypoint(IWaypoint waypoint) {
        this.waypoints.get((Object)waypoint.getTag()).add(waypoint);
    }

    @Override
    public void removeWaypoint(IWaypoint waypoint) {
        this.waypoints.get((Object)waypoint.getTag()).remove(waypoint);
    }

    @Override
    public IWaypoint getMostRecentByTag(IWaypoint.Tag tag) {
        return this.waypoints.get((Object)tag).stream().min(Comparator.comparingLong(w -> -w.getCreationTimestamp())).orElse(null);
    }

    @Override
    public Set<IWaypoint> getByTag(IWaypoint.Tag tag) {
        return Collections.unmodifiableSet(this.waypoints.get((Object)tag));
    }

    @Override
    public Set<IWaypoint> getAllWaypoints() {
        return this.waypoints.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

