/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.cache;

import com.player2.playerengine.automaton.api.cache.IWorldScanner;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.api.utils.BlockOptionalMetaLookup;
import com.player2.playerengine.automaton.api.utils.IEntityContext;
import com.player2.playerengine.automaton.utils.accessor.ServerChunkManagerAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;

public enum WorldScanner implements IWorldScanner
{
    INSTANCE;

    public static final int SECTION_HEIGHT = 16;
    private static final int[] DEFAULT_COORDINATE_ITERATION_ORDER;

    @Override
    public List<BlockPos> scanChunkRadius(IEntityContext ctx, BlockOptionalMetaLookup filter, int max, int yLevelThreshold, int maxSearchRadius) {
        ArrayList<BlockPos> res = new ArrayList<BlockPos>();
        if (filter.blocks().isEmpty()) {
            return res;
        }
        ServerChunkManagerAccessor chunkProvider = (ServerChunkManagerAccessor)ctx.world().m_7726_();
        int maxSearchRadiusSq = maxSearchRadius * maxSearchRadius;
        int playerChunkX = ctx.feetPos().m_123341_() >> 4;
        int playerChunkZ = ctx.feetPos().m_123343_() >> 4;
        int playerY = ctx.feetPos().m_123342_();
        int playerYBlockStateContainerIndex = playerY >> 4;
        int[] coordinateIterationOrder = this.streamSectionY(ctx.world()).boxed().sorted(Comparator.comparingInt(y -> Math.abs(y - playerYBlockStateContainerIndex))).mapToInt(x -> x).toArray();
        int searchRadiusSq = 0;
        boolean foundWithinY = false;
        while (true) {
            boolean allUnloaded = true;
            boolean foundChunks = false;
            for (int xoff = -searchRadiusSq; xoff <= searchRadiusSq; ++xoff) {
                for (int zoff = -searchRadiusSq; zoff <= searchRadiusSq; ++zoff) {
                    int distance = xoff * xoff + zoff * zoff;
                    if (distance != searchRadiusSq) continue;
                    foundChunks = true;
                    int chunkX = xoff + playerChunkX;
                    int chunkZ = zoff + playerChunkZ;
                    LevelChunk chunk = chunkProvider.automatone$getChunkNow(chunkX, chunkZ);
                    if (chunk == null) continue;
                    allUnloaded = false;
                    if (!this.scanChunkInto(chunkX << 4, chunkZ << 4, (ChunkAccess)chunk, filter, res, max, yLevelThreshold, playerY, coordinateIterationOrder)) continue;
                    foundWithinY = true;
                }
            }
            if (allUnloaded && foundChunks || res.size() >= max && (searchRadiusSq > maxSearchRadiusSq || searchRadiusSq > 1 && foundWithinY)) {
                return res;
            }
            ++searchRadiusSq;
        }
    }

    @Override
    public List<BlockPos> scanChunk(IEntityContext ctx, BlockOptionalMetaLookup filter, ChunkPos pos, int max, int yLevelThreshold) {
        if (filter.blocks().isEmpty()) {
            return Collections.emptyList();
        }
        ServerChunkCache chunkProvider = ctx.world().m_7726_();
        ChunkAccess chunk = chunkProvider.m_7587_(pos.f_45578_, pos.f_45579_, ChunkStatus.f_62326_, false);
        int playerY = ctx.feetPos().m_123342_();
        if (chunk instanceof LevelChunk && !((LevelChunk)chunk).m_6430_()) {
            ArrayList<BlockPos> res = new ArrayList<BlockPos>();
            this.scanChunkInto(pos.f_45578_ << 4, pos.f_45579_ << 4, chunk, filter, res, max, yLevelThreshold, playerY, this.streamSectionY(ctx.world()).toArray());
            return res;
        }
        return Collections.emptyList();
    }

    private IntStream streamSectionY(ServerLevel world) {
        return IntStream.range(0, world.m_141928_() / 16);
    }

    @Override
    public int repack(IEntityContext ctx) {
        return this.repack(ctx, 40);
    }

    @Override
    public int repack(IEntityContext ctx, int range) {
        ServerChunkCache chunkProvider = ctx.world().m_7726_();
        BetterBlockPos playerPos = ctx.feetPos();
        int playerChunkX = playerPos.m_123341_() >> 4;
        int playerChunkZ = playerPos.m_123343_() >> 4;
        int minX = playerChunkX - range;
        int minZ = playerChunkZ - range;
        int maxX = playerChunkX + range;
        int maxZ = playerChunkZ + range;
        int queued = 0;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                LevelChunk chunk = chunkProvider.m_62227_(x, z, false);
                if (chunk == null || chunk.m_6430_()) continue;
                ++queued;
            }
        }
        return queued;
    }

    private boolean scanChunkInto(int chunkX, int chunkZ, ChunkAccess chunk, BlockOptionalMetaLookup filter, Collection<BlockPos> result, int max, int yLevelThreshold, int playerY, int[] coordinateIterationOrder) {
        LevelChunkSection[] chunkInternalStorageArray = chunk.m_7103_();
        boolean foundWithinY = false;
        if (chunkInternalStorageArray.length != coordinateIterationOrder.length) {
            throw new IllegalStateException("Unexpected number of sections in chunk (expected " + coordinateIterationOrder.length + ", got " + chunkInternalStorageArray.length + ")");
        }
        for (int yIndex = 0; yIndex < chunkInternalStorageArray.length; ++yIndex) {
            int y0 = coordinateIterationOrder[yIndex];
            LevelChunkSection section = chunkInternalStorageArray[y0];
            if (section == null || section.m_188008_()) continue;
            if (!section.m_63002_(filter::has)) continue;
            int yReal = (y0 << 4) + chunk.m_141937_();
            PalettedContainer bsc = section.m_63019_();
            for (int yy = 0; yy < 16; ++yy) {
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        BlockState state = (BlockState)bsc.m_63087_(x, yy, z);
                        if (!filter.has(state)) continue;
                        int y = yReal | yy;
                        if (result.size() >= max) {
                            if (Math.abs(y - playerY) < yLevelThreshold) {
                                foundWithinY = true;
                            } else if (foundWithinY) {
                                return true;
                            }
                        }
                        result.add(new BlockPos(chunkX | x, y, chunkZ | z));
                    }
                }
            }
        }
        return foundWithinY;
    }

    static {
        DEFAULT_COORDINATE_ITERATION_ORDER = IntStream.range(0, 16).toArray();
    }
}

