/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.pathing.movement;

import com.player2.playerengine.automaton.Baritone;
import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.Settings;
import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.automaton.api.pathing.movement.ActionCosts;
import com.player2.playerengine.automaton.api.pathing.movement.MovementStatus;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.api.utils.IEntityContext;
import com.player2.playerengine.automaton.api.utils.RayTraceUtils;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.RotationUtils;
import com.player2.playerengine.automaton.api.utils.VecUtils;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.pathing.movement.CalculationContext;
import com.player2.playerengine.automaton.pathing.movement.Movement;
import com.player2.playerengine.automaton.pathing.movement.MovementState;
import com.player2.playerengine.automaton.utils.BlockStateInterface;
import com.player2.playerengine.automaton.utils.ToolSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EndPortalBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.InfestedBlock;
import net.minecraft.world.level.block.ScaffoldingBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.WaterFluid;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public interface MovementHelper
extends ActionCosts {
    public static boolean avoidBreaking(BlockStateInterface bsi, int x, int y, int z, BlockState state, Settings settings) {
        Block b = state.m_60734_();
        return b == Blocks.f_50126_ || b instanceof InfestedBlock || MovementHelper.avoidAdjacentBreaking(bsi, x, y + 1, z, true, settings) || MovementHelper.avoidAdjacentBreaking(bsi, x + 1, y, z, false, settings) || MovementHelper.avoidAdjacentBreaking(bsi, x - 1, y, z, false, settings) || MovementHelper.avoidAdjacentBreaking(bsi, x, y, z + 1, false, settings) || MovementHelper.avoidAdjacentBreaking(bsi, x, y, z - 1, false, settings);
    }

    public static boolean avoidAdjacentBreaking(BlockStateInterface bsi, int x, int y, int z, boolean directlyAbove, Settings settings) {
        BlockState state = bsi.get0(x, y, z);
        Block block = state.m_60734_();
        return !directlyAbove && block instanceof FallingBlock && settings.avoidUpdatingFallingBlocks.get() != false && FallingBlock.m_53241_((BlockState)bsi.get0(x, y - 1, z)) ? true : !state.m_60819_().m_76178_();
    }

    public static boolean canWalkThrough(IEntityContext ctx, BetterBlockPos pos) {
        return MovementHelper.canWalkThrough(new BlockStateInterface(ctx), pos.x, pos.y, pos.z, ctx.baritone().settings());
    }

    public static boolean canWalkThrough(BlockStateInterface bsi, int x, int y, int z, Settings settings) {
        return MovementHelper.canWalkThrough(bsi, x, y, z, bsi.get0(x, y, z), settings);
    }

    public static boolean canWalkThrough(BlockStateInterface bsi, int x, int y, int z, BlockState state, Settings settings) {
        Block block = state.m_60734_();
        if (block instanceof AirBlock) {
            return true;
        }
        if (!(block instanceof BaseFireBlock || block == Blocks.f_50267_ || block == Blocks.f_50033_ || block == Blocks.f_50257_ || block == Blocks.f_50262_ || block instanceof AbstractSkullBlock || block == Blocks.f_50628_ || block instanceof ShulkerBoxBlock || block instanceof SlabBlock || block instanceof TrapDoorBlock || block == Blocks.f_50719_ || block == Blocks.f_152541_ || block == Blocks.f_152542_ || block == Blocks.f_152475_ || block == Blocks.f_152538_ || block == Blocks.f_152539_ || block == Blocks.f_50489_)) {
            if (settings.blocksToAvoid.get().contains(state.m_60734_())) {
                return false;
            }
            if (block instanceof DoorBlock || block instanceof FenceGateBlock) {
                return block instanceof FenceGateBlock || DoorBlock.m_52817_((BlockState)state);
            }
            if (block instanceof CarpetBlock) {
                return MovementHelper.canWalkOn(bsi, x, y - 1, z, settings);
            }
            if (block instanceof SnowLayerBlock) {
                if (!bsi.worldContainsLoadedChunk(x, z)) {
                    return true;
                }
                return (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_) >= 3 ? false : MovementHelper.canWalkOn(bsi, x, y - 1, z, settings);
            }
            if (MovementHelper.isFlowing(x, y, z, state, bsi)) {
                return false;
            }
            FluidState fluidState = state.m_60819_();
            if (!(fluidState.m_76152_() instanceof WaterFluid)) {
                return state.m_60647_(bsi.access, BlockPos.f_121853_, PathComputationType.LAND);
            }
            if (settings.assumeWalkOnWater.get().booleanValue()) {
                return false;
            }
            BlockState up = bsi.get0(x, y + 1, z);
            return (settings.allowSwimming.get() != false || up.m_60819_().m_76178_()) && !(up.m_60734_() instanceof WaterlilyBlock);
        }
        return false;
    }

    public static boolean fullyPassable(CalculationContext context, int x, int y, int z) {
        return MovementHelper.fullyPassable(context.bsi.access, (BlockPos)context.bsi.isPassableBlockPos.m_122178_(x, y, z), context.bsi.get0(x, y, z));
    }

    public static boolean fullyPassable(IEntityContext ctx, BlockPos pos) {
        return MovementHelper.fullyPassable((BlockGetter)ctx.world(), pos, ctx.world().m_8055_(pos));
    }

    public static boolean fullyPassable(BlockGetter access, BlockPos pos, BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof AirBlock) {
            return true;
        }
        return !(block instanceof BaseFireBlock) && block != Blocks.f_50267_ && block != Blocks.f_50033_ && block != Blocks.f_50191_ && block != Blocks.f_50155_ && block != Blocks.f_50262_ && !(block instanceof DoorBlock) && !(block instanceof FenceGateBlock) && !(block instanceof SnowLayerBlock) && state.m_60819_().m_76178_() && !(block instanceof TrapDoorBlock) && !(block instanceof EndPortalBlock) && !(block instanceof SkullBlock) && !(block instanceof ShulkerBoxBlock) ? state.m_60647_(access, pos, PathComputationType.LAND) : false;
    }

    public static boolean isReplaceable(int x, int y, int z, BlockState state, BlockStateInterface bsi) {
        Block block = state.m_60734_();
        if (block instanceof AirBlock) {
            return true;
        }
        if (block instanceof SnowLayerBlock) {
            return !bsi.worldContainsLoadedChunk(x, z) ? true : (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_) == 1;
        }
        return block != Blocks.f_50360_ && block != Blocks.f_50359_ ? state.m_247087_() : true;
    }

    @Deprecated
    public static boolean isReplacable(int x, int y, int z, BlockState state, BlockStateInterface bsi) {
        return MovementHelper.isReplaceable(x, y, z, state, bsi);
    }

    public static boolean isDoorPassable(IEntityContext ctx, BlockPos doorPos, BlockPos playerPos) {
        if (playerPos.equals((Object)doorPos)) {
            return false;
        }
        BlockState state = BlockStateInterface.get(ctx, doorPos);
        return !(state.m_60734_() instanceof DoorBlock) ? true : MovementHelper.isHorizontalBlockPassable(doorPos, state, playerPos, DoorBlock.f_52727_);
    }

    public static boolean isGatePassable(IEntityContext ctx, BlockPos gatePos, BlockPos playerPos) {
        if (playerPos.equals((Object)gatePos)) {
            return false;
        }
        BlockState state = BlockStateInterface.get(ctx, gatePos);
        return !(state.m_60734_() instanceof FenceGateBlock) ? true : (Boolean)state.m_61143_((Property)FenceGateBlock.f_53341_);
    }

    public static boolean isHorizontalBlockPassable(BlockPos blockPos, BlockState blockState, BlockPos playerPos, BooleanProperty propertyOpen) {
        Direction.Axis playerFacing;
        if (playerPos.equals((Object)blockPos)) {
            return false;
        }
        Direction.Axis facing = ((Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122434_();
        boolean open = (Boolean)blockState.m_61143_((Property)propertyOpen);
        if (!playerPos.m_122012_().equals((Object)blockPos) && !playerPos.m_122019_().equals((Object)blockPos)) {
            if (!playerPos.m_122029_().equals((Object)blockPos) && !playerPos.m_122024_().equals((Object)blockPos)) {
                return true;
            }
            playerFacing = Direction.Axis.X;
        } else {
            playerFacing = Direction.Axis.Z;
        }
        return facing == playerFacing == open;
    }

    public static boolean avoidWalkingInto(BlockState state) {
        Block block = state.m_60734_();
        return !state.m_60819_().m_76178_() || block == Blocks.f_50450_ || block == Blocks.f_50128_ || block instanceof BaseFireBlock || block == Blocks.f_50257_ || block == Blocks.f_50033_ || block == Blocks.f_50628_;
    }

    public static boolean canWalkOn(BlockStateInterface bsi, int x, int y, int z, BlockState state, Settings settings) {
        Block block = state.m_60734_();
        if (block instanceof AirBlock || block == Blocks.f_50450_ || block == Blocks.f_50628_ || block == Blocks.f_50719_) {
            return false;
        }
        if (MovementHelper.isBlockNormalCube(state)) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_13082_)) {
            return true;
        }
        if (block == Blocks.f_50093_ || block == Blocks.f_152481_) {
            return true;
        }
        if (block == Blocks.f_50265_ || block == Blocks.f_50087_ || block == Blocks.f_50325_) {
            return true;
        }
        if (MovementHelper.isWater(state)) {
            BlockState upState = bsi.get0(x, y + 1, z);
            Block up = upState.m_60734_();
            if (up != Blocks.f_50196_ && !(up instanceof CarpetBlock)) {
                return !MovementHelper.isFlowing(x, y, z, state, bsi) && upState.m_60819_().m_76152_() != Fluids.f_76192_ ? MovementHelper.isWater(upState) ^ settings.assumeWalkOnWater.get() : MovementHelper.isWater(upState) && settings.assumeWalkOnWater.get() == false;
            }
            return true;
        }
        if (settings.assumeWalkOnLava.get().booleanValue() && MovementHelper.isLava(state) && !MovementHelper.isFlowing(x, y, z, state, bsi)) {
            return true;
        }
        if (block == Blocks.f_50058_ || block instanceof StainedGlassBlock) {
            return true;
        }
        if (!(block instanceof SlabBlock)) {
            return block instanceof StairBlock;
        }
        return !settings.allowWalkOnBottomSlab.get().booleanValue() ? state.m_61143_((Property)SlabBlock.f_56353_) != SlabType.BOTTOM : true;
    }

    public static boolean canWalkOn(IEntityContext ctx, BetterBlockPos pos, BlockState state) {
        return MovementHelper.canWalkOn(new BlockStateInterface(ctx), pos.x, pos.y, pos.z, state, ctx.baritone().settings());
    }

    public static boolean canWalkOn(IEntityContext ctx, BlockPos pos) {
        return MovementHelper.canWalkOn(new BlockStateInterface(ctx), pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), ctx.baritone().settings());
    }

    public static boolean canWalkOn(IEntityContext ctx, BetterBlockPos pos) {
        return MovementHelper.canWalkOn(new BlockStateInterface(ctx), pos.x, pos.y, pos.z, ctx.baritone().settings());
    }

    public static boolean canWalkOn(BlockStateInterface bsi, int x, int y, int z, Settings settings) {
        return MovementHelper.canWalkOn(bsi, x, y, z, bsi.get0(x, y, z), settings);
    }

    public static boolean canPlaceAgainst(BlockStateInterface bsi, int x, int y, int z) {
        return MovementHelper.canPlaceAgainst(bsi, x, y, z, bsi.get0(x, y, z));
    }

    public static boolean canPlaceAgainst(BlockStateInterface bsi, BlockPos pos) {
        return MovementHelper.canPlaceAgainst(bsi, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static boolean canPlaceAgainst(IEntityContext ctx, BlockPos pos) {
        return MovementHelper.canPlaceAgainst(new BlockStateInterface(ctx), pos);
    }

    public static boolean canPlaceAgainst(BlockStateInterface bsi, int x, int y, int z, BlockState state) {
        return MovementHelper.isBlockNormalCube(state) || state.m_60734_() == Blocks.f_50058_ || state.m_60734_() instanceof StainedGlassBlock;
    }

    public static double getMiningDurationTicks(CalculationContext context, int x, int y, int z, boolean includeFalling) {
        return MovementHelper.getMiningDurationTicks(context, x, y, z, context.get(x, y, z), includeFalling);
    }

    public static double getMiningDurationTicks(CalculationContext context, int x, int y, int z, BlockState state, boolean includeFalling) {
        if (!MovementHelper.canWalkThrough(context.bsi, x, y, z, state, context.baritone.settings())) {
            BlockState above;
            if (!state.m_60819_().m_76178_()) {
                return 1000000.0;
            }
            double mult = context.breakCostMultiplierAt(x, y, z, state);
            if (mult >= 1000000.0) {
                return 1000000.0;
            }
            if (MovementHelper.avoidBreaking(context.bsi, x, y, z, state, context.baritone.settings())) {
                return 1000000.0;
            }
            if (context.toolSet == null) {
                return 1000000.0;
            }
            double strVsBlock = context.toolSet.getStrVsBlock(state);
            if (strVsBlock <= 0.0) {
                return 1000000.0;
            }
            double result = 1.0 / strVsBlock;
            result += context.breakBlockAdditionalCost;
            result *= mult;
            if (includeFalling && (above = context.get(x, y + 1, z)).m_60734_() instanceof FallingBlock) {
                result += MovementHelper.getMiningDurationTicks(context, x, y + 1, z, above, true);
            }
            return result;
        }
        return 0.0;
    }

    public static boolean isBottomSlab(BlockState state) {
        return state.m_60734_() instanceof SlabBlock && state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM;
    }

    public static void switchToBestToolFor(IEntityContext ctx, BlockState b) {
        LivingEntity entity = ctx.entity();
        if (entity instanceof IInventoryProvider) {
            MovementHelper.switchToBestToolFor(ctx, b, new ToolSet(entity), ctx.baritone().settings().preferSilkTouch.get());
        }
    }

    public static void switchToBestToolFor(IEntityContext ctx, BlockState b, ToolSet ts, boolean preferSilkTouch) {
        LivingEntityInventory inventory = ctx.inventory();
        if (inventory != null && !ctx.baritone().settings().disableAutoTool.get().booleanValue() && !ctx.baritone().settings().assumeExternalAutoTool.get().booleanValue()) {
            inventory.selectedSlot = ts.getBestSlot(b.m_60734_(), preferSilkTouch);
        }
    }

    public static void moveTowards(IEntityContext ctx, MovementState state, BlockPos pos) {
        state.setTarget(new MovementState.MovementTarget(new Rotation(RotationUtils.calcRotationFromVec3d(ctx.headPos(), VecUtils.getBlockPosCenter(pos), ctx.entityRotations()).getYaw(), ctx.entity().m_146909_()), false)).setInput(Input.MOVE_FORWARD, true);
    }

    public static boolean isWater(BlockState state) {
        return state.m_60819_().m_205070_(FluidTags.f_13131_);
    }

    public static boolean isWater(IEntityContext ctx, BlockPos bp) {
        return MovementHelper.isWater(BlockStateInterface.get(ctx, bp));
    }

    public static boolean isLava(BlockState state) {
        Fluid f = state.m_60819_().m_76152_();
        return f == Fluids.f_76195_ || f == Fluids.f_76194_;
    }

    public static boolean isLiquid(IEntityContext ctx, BlockPos p) {
        return MovementHelper.isLiquid(BlockStateInterface.get(ctx, p));
    }

    public static boolean isLiquid(BlockState blockState) {
        return !blockState.m_60819_().m_76178_();
    }

    public static boolean possiblyFlowing(BlockState state) {
        FluidState fluidState = state.m_60819_();
        return fluidState.m_76152_() instanceof FlowingFluid && fluidState.m_76152_().m_7430_(fluidState) != 8;
    }

    public static boolean isFlowing(int x, int y, int z, BlockState state, BlockStateInterface bsi) {
        FluidState fluidState = state.m_60819_();
        if (!(fluidState.m_76152_() instanceof FlowingFluid)) {
            return false;
        }
        return fluidState.m_76152_().m_7430_(fluidState) != 8 ? true : MovementHelper.possiblyFlowing(bsi.get0(x + 1, y, z)) || MovementHelper.possiblyFlowing(bsi.get0(x - 1, y, z)) || MovementHelper.possiblyFlowing(bsi.get0(x, y, z + 1)) || MovementHelper.possiblyFlowing(bsi.get0(x, y, z - 1));
    }

    public static boolean isBlockNormalCube(BlockState state) {
        Block block = state.m_60734_();
        if (!(block instanceof BambooStalkBlock || block instanceof MovingPistonBlock || block instanceof ScaffoldingBlock || block instanceof ShulkerBoxBlock)) {
            try {
                return state.m_60838_(null, BlockPos.f_121853_);
            }
            catch (NullPointerException var3) {
                return false;
            }
        }
        return false;
    }

    public static PlaceResult attemptToPlaceABlock(MovementState state, IBaritone baritone, BlockPos placeAt, boolean preferDown, boolean wouldSneak) {
        IEntityContext ctx = baritone.getEntityContext();
        Optional<Rotation> direct = RotationUtils.reachable(ctx, placeAt, wouldSneak);
        boolean found = false;
        if (direct.isPresent()) {
            state.setTarget(new MovementState.MovementTarget(direct.get(), true));
            found = true;
        }
        int i = 0;
        while (true) {
            block12: {
                block11: {
                    if (i >= 5) break block11;
                    BlockPos against1 = placeAt.m_121945_(Movement.HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i]);
                    if (!MovementHelper.canPlaceAgainst(ctx, against1)) break block12;
                    if (!((Baritone)baritone).getInventoryBehavior().selectThrowawayForLocation(false, placeAt.m_123341_(), placeAt.m_123342_(), placeAt.m_123343_())) {
                        baritone.logDebug("bb pls get me some blocks. dirt, netherrack, cobble");
                        state.setStatus(MovementStatus.UNREACHABLE);
                        return PlaceResult.NO_OPTION;
                    }
                    double faceX = ((double)(placeAt.m_123341_() + against1.m_123341_()) + 1.0) * 0.5;
                    double faceY = ((double)(placeAt.m_123342_() + against1.m_123342_()) + 0.5) * 0.5;
                    double faceZ = ((double)(placeAt.m_123343_() + against1.m_123343_()) + 1.0) * 0.5;
                    Rotation place = RotationUtils.calcRotationFromVec3d(wouldSneak ? RayTraceUtils.inferSneakingEyePosition((Entity)ctx.entity()) : ctx.headPos(), new Vec3(faceX, faceY, faceZ), ctx.entityRotations());
                    HitResult res = RayTraceUtils.rayTraceTowards((Entity)ctx.entity(), place, ctx.playerController().getBlockReachDistance(), wouldSneak);
                    if (res == null || res.m_6662_() != HitResult.Type.BLOCK || !((BlockHitResult)res).m_82425_().equals((Object)against1) || !((BlockHitResult)res).m_82425_().m_121945_(((BlockHitResult)res).m_82434_()).equals((Object)placeAt)) break block12;
                    state.setTarget(new MovementState.MovementTarget(place, true));
                    found = true;
                    if (preferDown) break block12;
                }
                if (ctx.getSelectedBlock().isPresent()) {
                    BlockPos selectedBlock = ctx.getSelectedBlock().get();
                    Direction side = ((BlockHitResult)ctx.objectMouseOver()).m_82434_();
                    if (selectedBlock.equals((Object)placeAt) || MovementHelper.canPlaceAgainst(ctx, selectedBlock) && selectedBlock.m_121945_(side).equals((Object)placeAt)) {
                        if (wouldSneak) {
                            state.setInput(Input.SNEAK, true);
                        }
                        ((Baritone)baritone).getInventoryBehavior().selectThrowawayForLocation(true, placeAt.m_123341_(), placeAt.m_123342_(), placeAt.m_123343_());
                        return PlaceResult.READY_TO_PLACE;
                    }
                }
                if (found) {
                    if (wouldSneak) {
                        state.setInput(Input.SNEAK, true);
                    }
                    ((Baritone)baritone).getInventoryBehavior().selectThrowawayForLocation(true, placeAt.m_123341_(), placeAt.m_123342_(), placeAt.m_123343_());
                    return PlaceResult.ATTEMPTING;
                }
                return PlaceResult.NO_OPTION;
            }
            ++i;
        }
    }

    public static boolean isTransparent(Block b) {
        return b == Blocks.f_50016_ || b == Blocks.f_49991_ || b == Blocks.f_49990_;
    }

    public static enum PlaceResult {
        READY_TO_PLACE,
        ATTEMPTING,
        NO_OPTION;

    }
}

