/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.pathing.movement.movements;

import com.google.common.collect.ImmutableSet;
import com.player2.playerengine.automaton.Baritone;
import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.pathing.movement.MovementStatus;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.pathing.movement.CalculationContext;
import com.player2.playerengine.automaton.pathing.movement.Movement;
import com.player2.playerengine.automaton.pathing.movement.MovementHelper;
import com.player2.playerengine.automaton.pathing.movement.MovementState;
import com.player2.playerengine.automaton.utils.pathing.MutableMoveResult;
import java.util.Set;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ScaffoldingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MovementDownward
extends Movement {
    private int numTicks = 0;

    public MovementDownward(IBaritone baritone, BetterBlockPos start, BetterBlockPos end) {
        super(baritone, start, end, MovementDownward.buildPositionsToBreak((Entity)baritone.getEntityContext().entity(), end));
    }

    public static BetterBlockPos[] buildPositionsToBreak(Entity entity, BetterBlockPos end) {
        int x = end.x;
        int y = end.y;
        int z = end.z;
        EntityDimensions dims = entity.m_6972_(Pose.STANDING);
        int requiredSideSpace = CalculationContext.getRequiredSideSpace(dims);
        int sideLength = requiredSideSpace * 2 + 1;
        BetterBlockPos[] ret = new BetterBlockPos[sideLength * sideLength];
        int i = 0;
        for (int dx = -requiredSideSpace; dx <= requiredSideSpace; ++dx) {
            for (int dz = -requiredSideSpace; dz <= requiredSideSpace; ++dz) {
                ret[i++] = new BetterBlockPos(x + dx, y, z + dz);
            }
        }
        return ret;
    }

    @Override
    public void reset() {
        super.reset();
        this.numTicks = 0;
    }

    @Override
    public double calculateCost(CalculationContext context) {
        MutableMoveResult result = new MutableMoveResult();
        MovementDownward.cost(context, this.src.x, this.src.y, this.src.z, result);
        return result.cost;
    }

    @Override
    protected Set<BetterBlockPos> calculateValidPositions() {
        return ImmutableSet.of((Object)((Object)this.src), (Object)((Object)this.dest));
    }

    public static void cost(CalculationContext context, int x, int y, int z, MutableMoveResult result) {
        if (context.allowDownward && MovementHelper.canWalkOn(context.bsi, x, y - 2, z, context.baritone.settings())) {
            BlockState downBlock = context.get(x, y - 1, z);
            BlockState fromBlock = context.get(x, y, z);
            if (!fromBlock.m_60713_(Blocks.f_50616_) || !((Boolean)fromBlock.m_61143_((Property)ScaffoldingBlock.f_56014_)).booleanValue()) {
                if (downBlock.m_204336_(BlockTags.f_13082_)) {
                    if (fromBlock.m_204336_(BlockTags.f_13082_) && downBlock.m_60713_(Blocks.f_50616_) && !fromBlock.m_60713_(Blocks.f_50616_)) {
                        return;
                    }
                    if (context.requiredSideSpace == 0) {
                        result.cost = 6.666666666666667;
                    }
                } else {
                    double totalHardness = 0.0;
                    int requiredSideSpace = context.requiredSideSpace;
                    boolean waterFloor = false;
                    BlockState headState = context.get(x, y + context.height - 1, z);
                    boolean inWater = MovementHelper.isWater(headState);
                    for (int dx = -requiredSideSpace; dx <= requiredSideSpace; ++dx) {
                        for (int dz = -requiredSideSpace; dz <= requiredSideSpace; ++dz) {
                            int checkedX = x + dx;
                            int checkedZ = z + dz;
                            BlockState toBreak = context.get(checkedX, y - 1, checkedZ);
                            totalHardness += MovementHelper.getMiningDurationTicks(context, checkedX, y - 1, checkedZ, toBreak, false);
                            if (!MovementHelper.isWater(toBreak)) continue;
                            waterFloor = true;
                        }
                    }
                    if (inWater) {
                        totalHardness *= 5.0;
                    }
                    double fallCost = (waterFloor ? context.waterWalkSpeed / 4.63284688441047 : 1.0) * FALL_N_BLOCKS_COST[1];
                    result.cost = fallCost + totalHardness;
                    result.oxygenCost = context.oxygenCost(fallCost * 0.5 + totalHardness, headState) + context.oxygenCost(fallCost * 0.5, fromBlock);
                }
            }
        }
    }

    @Override
    public MovementState updateState(MovementState state) {
        super.updateState(state);
        if (state.getStatus() != MovementStatus.RUNNING) {
            return state;
        }
        if (this.ctx.feetPos().equals((Object)this.dest)) {
            return state.setStatus(MovementStatus.SUCCESS);
        }
        if (!this.playerInValidPosition()) {
            return state.setStatus(MovementStatus.UNREACHABLE);
        }
        double diffX = this.ctx.entity().m_20185_() - ((double)this.dest.m_123341_() + 0.5);
        double diffZ = this.ctx.entity().m_20189_() - ((double)this.dest.m_123343_() + 0.5);
        double ab = Math.sqrt(diffX * diffX + diffZ * diffZ);
        if (this.numTicks++ < 10 && ab < 0.2) {
            if (((Baritone)this.baritone).bsi.get0(this.baritone.getEntityContext().feetPos().down()).m_60713_(Blocks.f_50616_)) {
                state.setInput(Input.SNEAK, true);
            } else if (this.ctx.entity().m_5842_()) {
                state.setInput(Input.SNEAK, true);
            }
            return state;
        }
        MovementHelper.moveTowards(this.ctx, state, this.dest);
        return state;
    }
}

