/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.process;

import com.player2.playerengine.PlayerEngine;
import com.player2.playerengine.automaton.Baritone;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.automaton.api.pathing.goals.GoalBlock;
import com.player2.playerengine.automaton.api.pathing.goals.GoalComposite;
import com.player2.playerengine.automaton.api.pathing.goals.GoalRunAway;
import com.player2.playerengine.automaton.api.pathing.goals.GoalTwoBlocks;
import com.player2.playerengine.automaton.api.process.IMineProcess;
import com.player2.playerengine.automaton.api.process.PathingCommand;
import com.player2.playerengine.automaton.api.process.PathingCommandType;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.api.utils.BlockOptionalMeta;
import com.player2.playerengine.automaton.api.utils.BlockOptionalMetaLookup;
import com.player2.playerengine.automaton.api.utils.BlockUtils;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.RotationUtils;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.cache.CachedChunk;
import com.player2.playerengine.automaton.cache.WorldScanner;
import com.player2.playerengine.automaton.pathing.movement.CalculationContext;
import com.player2.playerengine.automaton.pathing.movement.MovementHelper;
import com.player2.playerengine.automaton.utils.BaritoneProcessHelper;
import com.player2.playerengine.automaton.utils.BlockStateInterface;
import com.player2.playerengine.automaton.utils.NotificationHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;

public final class MineProcess
extends BaritoneProcessHelper
implements IMineProcess {
    private static final int ORE_LOCATIONS_COUNT = 64;
    private BlockOptionalMetaLookup filter;
    private List<BlockPos> knownOreLocations;
    private List<BlockPos> blacklist;
    private Map<BlockPos, Long> anticipatedDrops;
    private BlockPos branchPoint;
    private GoalRunAway branchPointRunaway;
    private int desiredQuantity;
    private int tickCount;

    public MineProcess(Baritone baritone) {
        super(baritone);
    }

    @Override
    public boolean isActive() {
        return this.filter != null;
    }

    @Override
    public PathingCommand onTick(boolean calcFailed, boolean isSafeToCancel) {
        PathingCommand command;
        if (this.desiredQuantity > 0) {
            LivingEntityInventory inventory = this.ctx.inventory();
            int curr = inventory == null ? -1 : inventory.main.stream().filter(stack -> this.filter.has((ItemStack)stack)).mapToInt(ItemStack::m_41613_).sum();
            PlayerEngine.LOGGER.debug("Currently have " + curr + " valid items");
            if (curr >= this.desiredQuantity) {
                this.logDirect("Have " + curr + " valid items");
                this.cancel();
                return null;
            }
        }
        if (calcFailed) {
            if (this.knownOreLocations.isEmpty() || !this.baritone.settings().blacklistClosestOnFailure.get().booleanValue()) {
                this.logDirect("Unable to find any path to " + String.valueOf(this.filter) + ", canceling mine");
                if (this.baritone.settings().desktopNotifications.get().booleanValue() && this.baritone.settings().notificationOnMineFail.get().booleanValue()) {
                    NotificationHelper.notify("Unable to find any path to " + String.valueOf(this.filter) + ", canceling mine", true);
                }
                this.cancel();
                return null;
            }
            this.logDirect("Unable to find any path to " + String.valueOf(this.filter) + ", blacklisting presumably unreachable closest instance...");
            if (this.baritone.settings().desktopNotifications.get().booleanValue() && this.baritone.settings().notificationOnMineFail.get().booleanValue()) {
                NotificationHelper.notify("Unable to find any path to " + String.valueOf(this.filter) + ", blacklisting presumably unreachable closest instance...", true);
            }
            this.knownOreLocations.stream().min(Comparator.comparingDouble(arg_0 -> ((BetterBlockPos)this.ctx.feetPos()).m_123331_(arg_0))).ifPresent(this.blacklist::add);
            this.knownOreLocations.removeIf(this.blacklist::contains);
        }
        if (!this.baritone.settings().allowBreak.get().booleanValue()) {
            this.logDirect("Unable to mine when allowBreak is false!");
            this.cancel();
            return null;
        }
        this.updateLoucaSystem();
        int mineGoalUpdateInterval = this.baritone.settings().mineGoalUpdateInterval.get();
        ArrayList<BlockPos> curr = new ArrayList<BlockPos>(this.knownOreLocations);
        if (mineGoalUpdateInterval != 0 && this.tickCount++ % mineGoalUpdateInterval == 0) {
            CalculationContext context = new CalculationContext(this.baritone, true);
            PlayerEngine.getExecutor().execute(() -> this.rescan(curr, context));
        }
        if (this.baritone.settings().legitMine.get().booleanValue()) {
            this.addNearby();
        }
        Optional<BlockPos> shaft = curr.stream().filter(pos -> pos.m_123341_() == this.ctx.feetPos().m_123341_() && pos.m_123343_() == this.ctx.feetPos().m_123343_()).filter(pos -> pos.m_123342_() >= this.ctx.feetPos().m_123342_()).filter(pos -> !(BlockStateInterface.get(this.ctx, pos).m_60734_() instanceof AirBlock)).min(Comparator.comparingDouble(arg_0 -> ((BetterBlockPos)this.ctx.feetPos()).m_123331_(arg_0)));
        this.baritone.getInputOverrideHandler().clearAllKeys();
        if (shaft.isPresent() && this.ctx.entity().m_20096_()) {
            Optional<Rotation> rot;
            BlockPos pos2 = shaft.get();
            BlockState state = this.baritone.bsi.get0(pos2);
            if (!MovementHelper.avoidBreaking(this.baritone.bsi, pos2.m_123341_(), pos2.m_123342_(), pos2.m_123343_(), state, this.baritone.settings()) && (rot = RotationUtils.reachable(this.ctx, pos2)).isPresent() && isSafeToCancel) {
                this.baritone.getLookBehavior().updateTarget(rot.get(), true);
                MovementHelper.switchToBestToolFor(this.ctx, this.ctx.world().m_8055_(pos2));
                if (this.ctx.isLookingAt(pos2) || this.ctx.entityRotations().isReallyCloseTo(rot.get())) {
                    this.baritone.getInputOverrideHandler().setInputForceState(Input.CLICK_LEFT, true);
                }
                return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
            }
        }
        if ((command = this.updateGoal()) == null) {
            this.cancel();
            return null;
        }
        return command;
    }

    private void updateLoucaSystem() {
        HashMap<BlockPos, Long> copy = new HashMap<BlockPos, Long>(this.anticipatedDrops);
        this.ctx.getSelectedBlock().ifPresent(posx -> {
            if (this.knownOreLocations.contains(posx)) {
                copy.put((BlockPos)posx, System.currentTimeMillis() + this.baritone.settings().mineDropLoiterDurationMSThanksLouca.get());
            }
        });
        for (BlockPos pos : this.anticipatedDrops.keySet()) {
            if ((Long)copy.get(pos) >= System.currentTimeMillis()) continue;
            copy.remove(pos);
        }
        this.anticipatedDrops = copy;
    }

    @Override
    public void onLostControl() {
        this.mine(0, (BlockOptionalMetaLookup)null);
    }

    @Override
    public String displayName0() {
        return "Mine " + String.valueOf(this.filter);
    }

    private PathingCommand updateGoal() {
        boolean legit = this.baritone.settings().legitMine.get();
        List<BlockPos> locs = this.knownOreLocations;
        if (locs.isEmpty()) {
            if (!legit) {
                return null;
            }
            int y = this.baritone.settings().legitMineYLevel.get();
            if (this.branchPoint == null) {
                this.branchPoint = this.ctx.feetPos();
            }
            if (this.branchPointRunaway == null) {
                this.branchPointRunaway = new GoalRunAway(1.0, y, new BlockPos[]{this.branchPoint}){

                    @Override
                    public boolean isInGoal(int x, int yx, int z) {
                        return false;
                    }

                    @Override
                    public double heuristic() {
                        return Double.NEGATIVE_INFINITY;
                    }
                };
            }
            return new PathingCommand(this.branchPointRunaway, PathingCommandType.REVALIDATE_GOAL_AND_PATH);
        }
        CalculationContext context = new CalculationContext(this.baritone);
        locs = MineProcess.prune(context, new ArrayList<BlockPos>(locs), this.filter, 64, this.blacklist, this.droppedItemsScan());
        int locsSize = locs.size();
        Goal[] list = new Goal[locsSize];
        for (int i = 0; i < locsSize; ++i) {
            Goal coalesce;
            BlockPos loc = locs.get(i);
            list[i] = coalesce = this.coalesce(loc, locs, context);
        }
        GoalComposite goal = new GoalComposite(list);
        this.knownOreLocations = locs;
        return new PathingCommand(goal, legit ? PathingCommandType.FORCE_REVALIDATE_GOAL_AND_PATH : PathingCommandType.REVALIDATE_GOAL_AND_PATH);
    }

    private void rescan(List<BlockPos> already, CalculationContext context) {
        if (this.filter != null && !this.baritone.settings().legitMine.get().booleanValue()) {
            List<BlockPos> dropped = this.droppedItemsScan();
            List<BlockPos> locs = MineProcess.searchWorld(context, this.filter, 64, already, this.blacklist, dropped);
            locs.addAll(dropped);
            if (locs.isEmpty()) {
                this.logDirect("No locations for " + String.valueOf(this.filter) + " known, cancelling");
                if (this.baritone.settings().desktopNotifications.get().booleanValue() && this.baritone.settings().notificationOnMineFail.get().booleanValue()) {
                    NotificationHelper.notify("No locations for " + String.valueOf(this.filter) + " known, cancelling", true);
                }
                this.cancel();
            } else {
                this.knownOreLocations = locs;
            }
        }
    }

    private boolean internalMiningGoal(BlockPos pos, CalculationContext context, List<BlockPos> locs) {
        if (locs.contains(pos)) {
            return true;
        }
        BlockState state = context.bsi.get0(pos);
        return this.baritone.settings().internalMiningAirException.get() != false && state.m_60734_() instanceof AirBlock ? true : this.filter.has(state) && MineProcess.plausibleToBreak(context, pos);
    }

    private Goal coalesce(BlockPos loc, List<BlockPos> locs, CalculationContext context) {
        boolean assumeVerticalShaftMine;
        boolean bl = assumeVerticalShaftMine = !(this.baritone.bsi.get0(loc.m_7494_()).m_60734_() instanceof FallingBlock);
        if (!this.baritone.settings().forceInternalMining.get().booleanValue()) {
            return assumeVerticalShaftMine ? new GoalThreeBlocks(loc) : new GoalTwoBlocks(loc);
        }
        boolean upwardGoal = this.internalMiningGoal(loc.m_7494_(), context, locs);
        boolean downwardGoal = this.internalMiningGoal(loc.m_7495_(), context, locs);
        boolean doubleDownwardGoal = this.internalMiningGoal(loc.m_6625_(2), context, locs);
        if (upwardGoal == downwardGoal) {
            return doubleDownwardGoal && assumeVerticalShaftMine ? new GoalThreeBlocks(loc) : new GoalTwoBlocks(loc);
        }
        if (upwardGoal) {
            return new GoalBlock(loc);
        }
        return doubleDownwardGoal && assumeVerticalShaftMine ? new GoalTwoBlocks(loc.m_7495_()) : new GoalBlock(loc.m_7495_());
    }

    public List<BlockPos> droppedItemsScan() {
        if (!this.baritone.settings().mineScanDroppedItems.get().booleanValue()) {
            return Collections.emptyList();
        }
        ArrayList<BlockPos> ret = new ArrayList<BlockPos>();
        for (Entity entity : this.ctx.world().m_8583_()) {
            ItemEntity ei;
            if (!(entity instanceof ItemEntity) || !this.filter.has((ei = (ItemEntity)entity).m_32055_())) continue;
            ret.add(entity.m_20183_());
        }
        ret.addAll(this.anticipatedDrops.keySet());
        return ret;
    }

    public static List<BlockPos> searchWorld(CalculationContext ctx, BlockOptionalMetaLookup filter, int max, List<BlockPos> alreadyKnown, List<BlockPos> blacklist, List<BlockPos> dropped) {
        List<BlockPos> locs = new ArrayList<BlockPos>();
        ArrayList<Block> untracked = new ArrayList<Block>();
        for (BlockOptionalMeta bom : filter.blocks()) {
            Block block = bom.getBlock();
            if (CachedChunk.BLOCKS_TO_KEEP_TRACK_OF.contains((Object)block)) {
                BetterBlockPos pf = ctx.baritone.getEntityContext().feetPos();
                locs.addAll(ctx.worldData.getCachedWorld().getLocationsOf(BlockUtils.blockToString(block), ctx.baritone.settings().maxCachedWorldScanCount.get(), pf.x, pf.z, 2));
                continue;
            }
            untracked.add(block);
        }
        locs = MineProcess.prune(ctx, locs, filter, max, blacklist, dropped);
        if (!untracked.isEmpty() || ctx.baritone.settings().extendCacheOnThreshold.get().booleanValue() && locs.size() < max) {
            locs.addAll(WorldScanner.INSTANCE.scanChunkRadius(ctx.getBaritone().getEntityContext(), filter, max, 10, 32));
        }
        locs.addAll(alreadyKnown);
        return MineProcess.prune(ctx, locs, filter, max, blacklist, dropped);
    }

    private void addNearby() {
        List<BlockPos> dropped = this.droppedItemsScan();
        this.knownOreLocations.addAll(dropped);
        BetterBlockPos playerFeet = this.ctx.feetPos();
        BlockStateInterface bsi = new BlockStateInterface(this.ctx);
        int searchDist = 10;
        double fakedBlockReachDistance = 20.0;
        for (int x = playerFeet.m_123341_() - searchDist; x <= playerFeet.m_123341_() + searchDist; ++x) {
            for (int y = playerFeet.m_123342_() - searchDist; y <= playerFeet.m_123342_() + searchDist; ++y) {
                for (int z = playerFeet.m_123343_() - searchDist; z <= playerFeet.m_123343_() + searchDist; ++z) {
                    if (!this.filter.has(bsi.get0(x, y, z))) continue;
                    BlockPos pos = new BlockPos(x, y, z);
                    if ((!this.baritone.settings().legitMineIncludeDiagonals.get().booleanValue() || !this.knownOreLocations.stream().anyMatch(ore -> ore.m_123331_((Vec3i)pos) <= 2.0)) && !RotationUtils.reachable(this.ctx.entity(), pos, fakedBlockReachDistance).isPresent()) continue;
                    this.knownOreLocations.add(pos);
                }
            }
        }
        this.knownOreLocations = MineProcess.prune(new CalculationContext(this.baritone), this.knownOreLocations, this.filter, 64, this.blacklist, dropped);
    }

    private static List<BlockPos> prune(CalculationContext ctx, List<BlockPos> locs2, BlockOptionalMetaLookup filter, int max, List<BlockPos> blacklist, List<BlockPos> dropped) {
        dropped.removeIf(drop -> {
            for (BlockPos pos : locs2) {
                if (!(pos.m_123331_((Vec3i)drop) <= 9.0) || !filter.has(ctx.get(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())) || !MineProcess.plausibleToBreak(ctx, pos)) continue;
                return true;
            }
            return false;
        });
        List<BlockPos> locs = locs2.stream().distinct().filter(pos -> !ctx.bsi.worldContainsLoadedChunk(pos.m_123341_(), pos.m_123343_()) || filter.has(ctx.get(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())) || dropped.contains(pos)).filter(pos -> MineProcess.plausibleToBreak(ctx, pos)).filter(pos -> ctx.getBaritone().settings().allowOnlyExposedOres.get() != false ? MineProcess.isNextToAir(ctx, pos) : true).filter(pos -> pos.m_123342_() >= ctx.getBaritone().settings().minYLevelWhileMining.get()).filter(pos -> !blacklist.contains(pos)).sorted(Comparator.comparingDouble(arg_0 -> ((BlockPos)ctx.getBaritone().getEntityContext().entity().m_20183_()).m_123331_(arg_0))).collect(Collectors.toList());
        return locs.size() > max ? locs.subList(0, max) : locs;
    }

    public static boolean isNextToAir(CalculationContext ctx, BlockPos pos) {
        int radius = ctx.getBaritone().settings().allowOnlyExposedOresDistance.get();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    if (Math.abs(dx) + Math.abs(dy) + Math.abs(dz) > radius || !MovementHelper.isTransparent(ctx.getBlock(pos.m_123341_() + dx, pos.m_123342_() + dy, pos.m_123343_() + dz))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean plausibleToBreak(CalculationContext ctx, BlockPos pos) {
        return MovementHelper.getMiningDurationTicks(ctx, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), ctx.bsi.get0(pos), true) >= 1000000.0 ? false : ctx.bsi.get0(pos.m_7494_()).m_60734_() != Blocks.f_50752_ || ctx.bsi.get0(pos.m_7495_()).m_60734_() != Blocks.f_50752_;
    }

    @Override
    public void mineByName(int quantity, String ... blocks) {
        this.mine(quantity, new BlockOptionalMetaLookup(this.baritone.getEntityContext().world(), blocks));
    }

    @Override
    public void mine(int quantity, BlockOptionalMetaLookup filter) {
        this.filter = filter;
        if (filter != null && !this.baritone.settings().allowBreak.get().booleanValue()) {
            this.logDirect("Unable to mine when allowBreak is false!");
            this.mine(quantity, (BlockOptionalMetaLookup)null);
        } else {
            this.desiredQuantity = quantity;
            this.knownOreLocations = new ArrayList<BlockPos>();
            this.blacklist = new ArrayList<BlockPos>();
            this.branchPoint = null;
            this.branchPointRunaway = null;
            this.anticipatedDrops = new HashMap<BlockPos, Long>();
            if (filter != null) {
                this.rescan(new ArrayList<BlockPos>(), new CalculationContext(this.baritone));
            }
        }
    }

    @Override
    public void mine(int quantity, Block ... blocks) {
        this.mine(quantity, new BlockOptionalMetaLookup((BlockOptionalMeta[])Stream.of(blocks).map(block -> new BlockOptionalMeta(this.baritone.getEntityContext().world(), (Block)block)).toArray(BlockOptionalMeta[]::new)));
    }

    private static class GoalThreeBlocks
    extends GoalTwoBlocks {
        public GoalThreeBlocks(BlockPos pos) {
            super(pos);
        }

        @Override
        public boolean isInGoal(int x, int y, int z) {
            return x == this.x && (y == this.y || y == this.y - 1 || y == this.y - 2) && z == this.z;
        }

        @Override
        public double heuristic(int x, int y, int z) {
            int xDiff = x - this.x;
            int yDiff = y - this.y;
            int zDiff = z - this.z;
            return GoalBlock.calculate(xDiff, yDiff < -1 ? yDiff + 2 : (yDiff == -1 ? 0 : yDiff), zDiff);
        }
    }
}

