/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.utils.player;

import com.player2.playerengine.automaton.api.BaritoneAPI;
import com.player2.playerengine.automaton.api.cache.IWorldData;
import com.player2.playerengine.automaton.api.entity.IHungerManagerProvider;
import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityHungerManager;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.automaton.api.pathing.calc.Avoidance;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.api.utils.IEntityContext;
import com.player2.playerengine.automaton.api.utils.IInteractionController;
import com.player2.playerengine.automaton.api.utils.RayTraceUtils;
import com.player2.playerengine.automaton.utils.accessor.ServerChunkManagerAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class EntityContext
implements IEntityContext {
    private final LivingEntity entity;
    @Nullable
    private Supplier<List<Avoidance>> avoidanceFinder;

    public EntityContext(LivingEntity entity) {
        this.entity = entity;
    }

    @Override
    public LivingEntity entity() {
        return this.entity;
    }

    @Override
    @Nullable
    public LivingEntityInventory inventory() {
        return this.entity instanceof IInventoryProvider ? ((IInventoryProvider)this.entity).getLivingInventory() : null;
    }

    @Override
    @Nullable
    public LivingEntityHungerManager hungerManager() {
        return this.entity instanceof IHungerManagerProvider ? ((IHungerManagerProvider)this.entity).getHungerManager() : null;
    }

    @Override
    public IInteractionController playerController() {
        return IInteractionController.KEY.get(this.entity);
    }

    @Override
    public ServerLevel world() {
        Level world = this.entity.m_9236_();
        if (world.f_46443_) {
            throw new IllegalStateException();
        }
        return (ServerLevel)world;
    }

    @Override
    public IWorldData worldData() {
        return BaritoneAPI.getProvider().getBaritone(this.entity).getEntityContext().worldData();
    }

    @Override
    public HitResult objectMouseOver() {
        return RayTraceUtils.rayTraceTowards((Entity)this.entity(), this.entityRotations(), this.playerController().getBlockReachDistance());
    }

    @Override
    public BetterBlockPos feetPos() {
        LevelChunk chunk;
        double x = this.entity().m_20185_();
        double z = this.entity().m_20189_();
        BetterBlockPos feet = new BetterBlockPos(x, this.entity().m_20186_() + 0.1251, z);
        ServerLevel world = this.world();
        if (world != null && (chunk = ((ServerChunkManagerAccessor)world.m_7726_()).automatone$getChunkNow((int)x << 4, (int)z << 4)) != null && chunk.m_8055_((BlockPos)feet).m_60734_() instanceof SlabBlock) {
            return feet.up();
        }
        return feet;
    }

    private Stream<Entity> streamHostileEntities() {
        return this.worldEntitiesStream().filter(entity -> entity instanceof Mob).filter(entity -> !(entity instanceof Spider) || (double)entity.m_213856_() < 0.5).filter(entity -> !(entity instanceof ZombifiedPiglin) || ((ZombifiedPiglin)entity).m_21188_() != null).filter(entity -> !(entity instanceof EnderMan) || ((EnderMan)entity).m_32531_());
    }

    @Override
    public void setAvoidanceFinder(@Nullable Supplier<List<Avoidance>> avoidanceFinder) {
        this.avoidanceFinder = avoidanceFinder;
    }

    @Override
    public List<Avoidance> listAvoidedAreas() {
        if (!this.baritone().settings().avoidance.get().booleanValue()) {
            return Collections.emptyList();
        }
        if (this.avoidanceFinder != null) {
            return this.avoidanceFinder.get();
        }
        ArrayList<Avoidance> res = new ArrayList<Avoidance>();
        double mobCoeff = this.baritone().settings().mobAvoidanceCoefficient.get();
        if (mobCoeff != 1.0) {
            this.streamHostileEntities().forEach(entity -> res.add(new Avoidance(entity.m_20183_(), mobCoeff, this.baritone().settings().mobAvoidanceRadius.get())));
        }
        return res;
    }
}

