/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.chains;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.chains.SingleTaskChain;
import com.player2.playerengine.tasks.DoToClosestBlockTask;
import com.player2.playerengine.tasks.InteractWithBlockTask;
import com.player2.playerengine.tasks.base.TaskRunner;
import com.player2.playerengine.tasks.construction.PutOutFireTask;
import com.player2.playerengine.tasks.movement.EnterNetherPortalTask;
import com.player2.playerengine.tasks.movement.EscapeFromLavaTask;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.tasks.movement.SafeRandomShimmyTask;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class WorldSurvivalChain
extends SingleTaskChain {
    private final TimerGame wasInLavaTimer = new TimerGame(1.0);
    private final TimerGame portalStuckTimer = new TimerGame(5.0);
    private boolean wasAvoidingDrowning;
    private BlockPos extinguishWaterPosition;

    public WorldSurvivalChain(TaskRunner runner) {
        super(runner);
    }

    @Override
    protected void onTaskFinish(PlayerEngineController mod) {
    }

    @Override
    public float getPriority() {
        if (!PlayerEngineController.inGame()) {
            return Float.NEGATIVE_INFINITY;
        }
        PlayerEngineController mod = this.controller;
        this.handleDrowning(mod);
        if (this.isInLavaOhShit(mod) && mod.getBehaviour().shouldEscapeLava()) {
            this.setTask(new EscapeFromLavaTask(mod));
            return 100.0f;
        }
        if (this.isInFire(mod)) {
            this.setTask(new DoToClosestBlockTask(PutOutFireTask::new, Blocks.f_50083_, Blocks.f_50084_));
            return 100.0f;
        }
        if (mod.getModSettings().shouldExtinguishSelfWithWater()) {
            if (!(this.mainTask instanceof EscapeFromLavaTask && this.isCurrentlyRunning(mod) || !mod.getPlayer().m_6060_() || mod.getPlayer().m_21023_(MobEffects.f_19607_) || mod.getWorld().m_6042_().f_63857_())) {
                Optional<Rotation> reach;
                BlockPos targetWaterPos;
                if (mod.getItemStorage().hasItem(Items.f_42447_) && WorldHelper.isSolidBlock(this.controller, (targetWaterPos = mod.getPlayer().m_20183_()).m_7495_()) && WorldHelper.canPlace(this.controller, targetWaterPos) && (reach = LookHelper.getReach(this.controller, targetWaterPos.m_7495_(), Direction.UP)).isPresent()) {
                    mod.getBaritone().getLookBehavior().updateTarget(reach.get(), true);
                    if (mod.getBaritone().getEntityContext().isLookingAt(targetWaterPos.m_7495_()) && mod.getSlotHandler().forceEquipItem(Items.f_42447_)) {
                        this.extinguishWaterPosition = targetWaterPos;
                        mod.getInputControls().tryPress(Input.CLICK_RIGHT);
                        this.setTask(null);
                        return 90.0f;
                    }
                }
                this.setTask(new DoToClosestBlockTask(GetToBlockTask::new, Blocks.f_49990_));
                return 90.0f;
            }
            if (mod.getItemStorage().hasItem(Items.f_42446_) && this.extinguishWaterPosition != null && mod.getBlockScanner().isBlockAtPosition(this.extinguishWaterPosition, Blocks.f_49990_)) {
                this.setTask(new InteractWithBlockTask(new ItemTarget(Items.f_42446_, 1), Direction.UP, this.extinguishWaterPosition.m_7495_(), true));
                return 60.0f;
            }
            this.extinguishWaterPosition = null;
        }
        if (this.isStuckInNetherPortal()) {
            mod.getExtraBaritoneSettings().setInteractionPaused(true);
        } else {
            this.portalStuckTimer.reset();
            mod.getExtraBaritoneSettings().setInteractionPaused(false);
        }
        if (this.portalStuckTimer.elapsed()) {
            this.setTask(new SafeRandomShimmyTask());
            return 60.0f;
        }
        return Float.NEGATIVE_INFINITY;
    }

    private void handleDrowning(PlayerEngineController mod) {
        boolean avoidedDrowning = false;
        if (mod.getModSettings().shouldAvoidDrowning() && !mod.getBaritone().getPathingBehavior().isPathing() && mod.getPlayer().m_20069_() && mod.getPlayer().m_20146_() < mod.getPlayer().m_6062_()) {
            mod.getInputControls().hold(Input.JUMP);
            avoidedDrowning = true;
            this.wasAvoidingDrowning = true;
        }
        if (this.wasAvoidingDrowning && !avoidedDrowning) {
            this.wasAvoidingDrowning = false;
            mod.getInputControls().release(Input.JUMP);
        }
    }

    private boolean isInLavaOhShit(PlayerEngineController mod) {
        if (mod.getPlayer().m_20077_() && !mod.getPlayer().m_21023_(MobEffects.f_19607_)) {
            this.wasInLavaTimer.reset();
            return true;
        }
        return mod.getPlayer().m_6060_() && !this.wasInLavaTimer.elapsed();
    }

    private boolean isInFire(PlayerEngineController mod) {
        if (mod.getPlayer().m_6060_() && !mod.getPlayer().m_21023_(MobEffects.f_19607_)) {
            for (BlockPos pos : WorldHelper.getBlocksTouchingPlayer(this.controller.getPlayer())) {
                Block b = mod.getWorld().m_8055_(pos).m_60734_();
                if (!(b instanceof BaseFireBlock)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isStuckInNetherPortal() {
        return WorldHelper.isInNetherPortal(this.controller) && !this.controller.getUserTaskChain().getCurrentTask().thisOrChildSatisfies(task -> task instanceof EnterNetherPortalTask);
    }

    @Override
    public String getName() {
        return "Misc World Survival Chain";
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    protected void onStop() {
        super.onStop();
    }
}

