/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.player2api;

import com.google.gson.JsonObject;
import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.player2api.AgentSideEffects;
import com.player2.playerengine.player2api.Character;
import com.player2.playerengine.player2api.ConversationHistory;
import com.player2.playerengine.player2api.Event;
import com.player2.playerengine.player2api.LLMCompleter;
import com.player2.playerengine.player2api.MessageBuffer;
import com.player2.playerengine.player2api.Player2APIService;
import com.player2.playerengine.player2api.status.AgentStatus;
import com.player2.playerengine.player2api.status.StatusUtils;
import com.player2.playerengine.player2api.status.WorldStatus;
import com.player2.playerengine.player2api.utils.Utils;
import java.util.Deque;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import net.minecraft.world.entity.LivingEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AgentConversationData {
    private static short MAX_EVENT_QUEUE_SIZE = (short)10;
    public static final Logger LOGGER = LogManager.getLogger();
    private final PlayerEngineController mod;
    private final Deque<Event> eventQueue = new ConcurrentLinkedDeque<Event>();
    private long lastProcessTime = 0L;
    private boolean isProcessing = false;
    private boolean enabled = true;
    private boolean isGreetingResponse = true;
    private boolean shouldIgnoreGreetingDance = true;
    private MessageBuffer playerEngineMsgBuffer = new MessageBuffer(10);

    public AgentConversationData(PlayerEngineController mod) {
        this.mod = mod;
    }

    public long getPriority() {
        if (!this.enabled || this.isProcessing || this.eventQueue.isEmpty()) {
            return 0L;
        }
        return System.nanoTime() - this.lastProcessTime;
    }

    public void process(Consumer<Event.CharacterMessage> onCharacterEvent, Consumer<String> extOnErrMsg, LLMCompleter completer) {
        if (this.isProcessing) {
            LOGGER.warn("Called queueData.process even though it was already processing! this should not happen");
            return;
        }
        if (this.eventQueue.isEmpty()) {
            LOGGER.warn("queueData.process called on empty event queue! this should not happen");
            return;
        }
        Consumer<String> onErrMsg = errMsg -> {
            this.isProcessing = false;
            extOnErrMsg.accept((String)errMsg);
        };
        this.lastProcessTime = System.nanoTime();
        this.isProcessing = true;
        Event lastEvent = this.mod.getAIPersistantData().dumpEventQueueToConversationHistoryAndReturnLastEvent(this.eventQueue, this.mod.getPlayer2APIService());
        Optional<String> reminderString = this.getReminderStringFromLastEvent(lastEvent);
        String defaultReminderString = " | REMEMBER TO OUTPUT ONLY VALID JSON OUTPUT";
        reminderString = reminderString.map(a -> a + defaultReminderString);
        reminderString = Optional.of(reminderString.orElse(defaultReminderString));
        String agentStatus = AgentStatus.fromMod(this.mod).toString();
        String worldStatus = WorldStatus.fromMod(this.mod).toString();
        String altoClefDebugMsgs = this.playerEngineMsgBuffer.dumpAndGetString();
        ConversationHistory historyWithWrappedStatus = this.mod.getAIPersistantData().getConversationHistoryWrappedWithStatus(worldStatus, agentStatus, altoClefDebugMsgs, this.mod.getPlayer2APIService(), reminderString);
        LOGGER.info("[AICommandBridge/processChatWithAPI]: Calling LLM: history={}", new Object[]{historyWithWrappedStatus.toString()});
        Consumer<JsonObject> onLLMResponse = jsonResp -> {
            String llmMessage = Utils.getStringJsonSafely(jsonResp, "message");
            String command = this.isGreetingResponse ? "bodylang greeting" : Utils.getStringJsonSafely(jsonResp, "command");
            this.isGreetingResponse = false;
            LOGGER.info("[AICommandBridge/processCharWithAPI]: Processed LLM repsonse: message={} command={}", (Object)llmMessage, (Object)command);
            try {
                if (llmMessage != null || command != null) {
                    this.mod.getAIPersistantData().addAssistantMessage(llmMessage, this.mod.getPlayer2APIService());
                    onCharacterEvent.accept(new Event.CharacterMessage(llmMessage, command, this));
                } else {
                    LOGGER.warn("[AICommandBridge/processChatWithAPI/onLLMResponse]: Generated null llm message and command");
                }
            }
            catch (Exception e) {
                LOGGER.error("[AICommandBridge/processChatWithAPI/onLLMRepsonse: ERROR RUNNING SIDE EFFECTS, errMsg={}", (Object)e.getMessage());
            }
            finally {
                this.isProcessing = false;
            }
        };
        completer.processToJson(this.mod.getPlayer2APIService(), historyWithWrappedStatus, onLLMResponse, onErrMsg, true);
    }

    private boolean isEventDuplicateOfLastMessage(Event evt) {
        boolean isDuplicate;
        boolean bl = isDuplicate = this.eventQueue.peekLast() != null && this.eventQueue.peekLast().equals(evt);
        if (isDuplicate) {
            LOGGER.warn("[EventQueueData]: evt={} was added twice!", (Object)evt.getConversationHistoryString());
            return true;
        }
        return false;
    }

    private void addEventToQueue(Event event) {
        if (this.isEventDuplicateOfLastMessage(event)) {
            return;
        }
        if (this.eventQueue.size() > MAX_EVENT_QUEUE_SIZE) {
            this.eventQueue.removeFirst();
        }
        LOGGER.info("queue for UUID={} name={} adding event={} ", (Object)this.getUUID(), (Object)this.getName(), (Object)event);
        this.eventQueue.add(event);
    }

    private Optional<String> getReminderStringFromLastEvent(Event lastEvent) {
        if (lastEvent instanceof Event.UserMessage) {
            return Optional.of((((Event.UserMessage)lastEvent).userName().equals(this.getMod().getOwnerUsername()) ? "Last message was from your owner." : "Last message was from a user that was not your owner.") + " Remember to output valid JSON reponse with reason, command and message.");
        }
        if (lastEvent instanceof Event.CharacterMessage) {
            return Optional.of("Last message was from an AI. Think about whether or not to respond. You may respond but don't keep the conversation going forever if no meaningful content was said in the last few msgs, do not respond (return empty string as message) Remember to output valid JSON reponse with reason, command and message.");
        }
        return Optional.of("Remember to output valid JSON reponse with reason, command and message.");
    }

    public void onEvent(Event event) {
        this.addEventToQueue(event);
    }

    public void onAICharacterMessage(Event.CharacterMessage msg) {
        boolean comingFromThisCharacter = msg.sendingCharacterData().getUUID().equals(this.getUUID());
        if (comingFromThisCharacter) {
            return;
        }
        this.eventQueue.add(msg);
    }

    public void onGreeting() {
        this.addEventToQueue(this.mod.getAIPersistantData().getGreetingEvent());
    }

    public void onCommandFinish(AgentSideEffects.CommandExecutionStopReason stopReason) {
        LOGGER.info("on command finish for cmd={}", (Object)stopReason.commandName());
        if (stopReason instanceof AgentSideEffects.CommandExecutionStopReason.Finished) {
            LOGGER.info("on command={} finish case", (Object)stopReason.commandName());
            if (this.shouldIgnoreGreetingDance && stopReason.commandName().contains("bodylang greeting")) {
                LOGGER.info("Skipping on command finish because should ignore greeting dance");
                this.shouldIgnoreGreetingDance = false;
                return;
            }
            this.shouldIgnoreGreetingDance = false;
            if (this.eventQueue.isEmpty()) {
                LOGGER.info("adding cmd={} to queue because it finished and queue not empty", (Object)stopReason.commandName());
                this.addEventToQueue(new Event.InfoMessage(String.format("Command feedback: %s finished running. What shall we do next? If no new action is needed to finish user's request, generate empty command `\"\"`.", stopReason.commandName())));
            } else {
                LOGGER.info("Skipping command stop for cmd={} because queue not empty", (Object)stopReason.commandName());
            }
        } else if (stopReason instanceof AgentSideEffects.CommandExecutionStopReason.Error) {
            LOGGER.info("adding cmd={} to queue because it errored", (Object)stopReason.commandName());
            this.addEventToQueue(new Event.InfoMessage(String.format("Command feedback: %s FAILED. The error was %s.", stopReason.commandName(), ((AgentSideEffects.CommandExecutionStopReason.Error)stopReason).errMsg())));
        } else {
            LOGGER.info("Skipping command stop for cmd={} because it was cancelled", (Object)stopReason.commandName());
        }
    }

    public float getDistance(UUID target) {
        return StatusUtils.getDistanceToUUID(this.mod, target);
    }

    public UUID getUUID() {
        return this.mod.getPlayer().m_20148_();
    }

    public PlayerEngineController getMod() {
        return this.mod;
    }

    public boolean isOwner(UUID playerToCheck) {
        return this.mod.isOwner(playerToCheck);
    }

    public LivingEntity getEntity() {
        return this.mod.getPlayer();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Character getCharacter() {
        return this.mod.getAIPersistantData().getCharacter();
    }

    public Player2APIService getPlayer2apiService() {
        return this.mod.getPlayer2APIService();
    }

    public String getName() {
        return this.getCharacter().shortName();
    }
}

